/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.mservice.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.property.DecimalProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.fbd.common.enums.FileFormatEnum;
import kd.tmc.fbd.common.enums.GetValueTypeEnum;
import kd.tmc.fbd.common.enums.ValueTypeEnum;
import kd.tmc.fbd.common.model.ExportBody;
import kd.tmc.fbd.common.model.ExportDetail;
import kd.tmc.fbd.common.model.ExportHeader;
import kd.tmc.fbd.common.model.FetchDataReponse;
import kd.tmc.fbd.common.model.FetchDataRequest;
import kd.tmc.fbd.mservice.MessageDataAPI;
import kd.tmc.fbp.common.builder.FormulaGetHandle;
import kd.tmc.fbp.common.builder.ISingleTaskContext;
import kd.tmc.fbp.common.builder.SingleTaskContext;
import kd.tmc.fbp.common.helper.ExpressionFromHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class EBankMessageDataAPIImpl
implements MessageDataAPI {
    private static Log logger = LogFactory.getLog(EBankMessageDataAPIImpl.class);

    @Override
    public String exportData(String req) {
        FetchDataReponse response = new FetchDataReponse();
        HashMap<Long, String> failureDatas = new HashMap<Long, String>(16);
        FetchDataRequest request = (FetchDataRequest)SerializationUtils.fromJsonString((String)req, FetchDataRequest.class);
        DynamicObject template = TmcDataServiceHelper.loadSingle((Object)request.getTemplateId(), (String)"fbd_export_template");
        HashMap<String, DynamicProperty> filterProperties = new HashMap<String, DynamicProperty>(16);
        DynamicObjectCollection sourceBills = ExpressionFromHelper.getFilterProperties(filterProperties, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)request.getIdSet().toArray(new Long[0]))}, (String)request.getBillNo());
        List<DynamicObject> eligibleSourceBillLst = this.filterEligibleOfApplyCondition(sourceBills, template, failureDatas, filterProperties, request.getBillNo());
        Map<String, Map<Long, Map<String, ExportDetail>>> details = this.getMessageData(eligibleSourceBillLst, template, filterProperties, request.getBillNo());
        this.assemblyHeaderInfo(response, template);
        this.assemblyBodyInfo(response, failureDatas, details);
        String jsonStr = JSON.toJSONString((Object)response, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.IgnoreNonFieldGetter, SerializerFeature.WriteClassName, SerializerFeature.NotWriteRootClassName, SerializerFeature.WriteMapNullValue});
        FetchDataReponse responseData = (FetchDataReponse)JSON.parseObject((String)jsonStr, FetchDataReponse.class);
        return SerializationUtils.toJsonString((Object)response);
    }

    private Map<String, Map<Long, Map<String, ExportDetail>>> getMessageData(List<DynamicObject> eligibleSourceBillLst, DynamicObject template, Map<String, DynamicProperty> filterProperties, String sourceBillId) {
        int length = this.getMapContainerSize(eligibleSourceBillLst, 0.75);
        HashMap<String, Map<Long, Map<String, ExportDetail>>> messageDetails = new HashMap<String, Map<Long, Map<String, ExportDetail>>>(length);
        Map<String, ExportDetail> headerDetailDatas = null;
        Map<String, ExportDetail> bodyDetailDatas = null;
        Map<String, ExportDetail> footerDetailDatas = null;
        if (0 == eligibleSourceBillLst.size()) {
            return messageDetails;
        }
        HashMap<Long, Map<String, ExportDetail>> headerMessageMap = new HashMap<Long, Map<String, ExportDetail>>(16);
        headerDetailDatas = this.assemblyMessageSettingData(eligibleSourceBillLst.get(0), template, filterProperties, sourceBillId, "header");
        headerMessageMap.put(1L, headerDetailDatas);
        messageDetails.put("header", headerMessageMap);
        this.statisticsData(headerMessageMap, eligibleSourceBillLst, "header");
        HashMap<Long, Map<String, ExportDetail>> bodysMessageMap = new HashMap<Long, Map<String, ExportDetail>>(16);
        for (DynamicObject sourceBill : eligibleSourceBillLst) {
            bodyDetailDatas = this.assemblyMessageSettingData(sourceBill, template, filterProperties, sourceBillId, "body");
            bodysMessageMap.put(sourceBill.getLong("id"), bodyDetailDatas);
        }
        messageDetails.put("body", bodysMessageMap);
        this.statisticsData(bodysMessageMap, eligibleSourceBillLst, "body");
        HashMap<Long, Map<String, ExportDetail>> footerMessageMap = new HashMap<Long, Map<String, ExportDetail>>(16);
        footerDetailDatas = this.assemblyMessageSettingData(eligibleSourceBillLst.get(0), template, filterProperties, sourceBillId, "footer");
        footerMessageMap.put(-1L, footerDetailDatas);
        messageDetails.put("footer", footerMessageMap);
        this.statisticsData(footerMessageMap, eligibleSourceBillLst, "footer");
        return messageDetails;
    }

    private Map<String, ExportDetail> assemblyMessageSettingData(DynamicObject sourceBill, DynamicObject template, Map<String, DynamicProperty> filterProperties, String sourceBillId, String type) {
        HashMap<String, ExportDetail> messageData = new HashMap<String, ExportDetail>(16);
        int index = 1;
        switch (type) {
            case "body": {
                DynamicObjectCollection bodyMessageSettings = template.getDynamicObjectCollection("messagefieldentry");
                for (DynamicObject messageSetting : bodyMessageSettings) {
                    messageData.put(messageSetting.getString("messagefield"), this.assemblyMessageData(sourceBill, messageSetting, filterProperties, sourceBillId, type, index++));
                }
                break;
            }
            case "header": {
                DynamicObjectCollection headerMessageSettings = template.getDynamicObjectCollection("header_messagefieldentry");
                for (DynamicObject messageSetting : headerMessageSettings) {
                    messageData.put(messageSetting.getString("header_messagefield"), this.assemblyMessageData(sourceBill, messageSetting, filterProperties, sourceBillId, type, index++));
                }
                break;
            }
            case "footer": {
                DynamicObjectCollection footerMessageSettings = template.getDynamicObjectCollection("footer_messagefieldentry");
                for (DynamicObject messageSetting : footerMessageSettings) {
                    messageData.put(messageSetting.getString("footer_messagefield"), this.assemblyMessageData(sourceBill, messageSetting, filterProperties, sourceBillId, type, index++));
                }
                break;
            }
        }
        return messageData;
    }

    private ExportDetail assemblyMessageData(DynamicObject sourceBill, DynamicObject messageSetting, Map<String, DynamicProperty> filterProperties, String sourceBillId, String type, int index) {
        ExportDetail message = new ExportDetail();
        message.setMsgLocation(type);
        message.setId(sourceBill.getLong("id"));
        String getValueType = messageSetting.getString(this.getControlSign(type, "getvaluetype"));
        Object value = null;
        String datafilter = messageSetting.getString(this.getControlSign(type, "getvalue_tag"));
        if (GetValueTypeEnum.SOURCE_BILL_FIELD.getValue().equalsIgnoreCase(getValueType)) {
            value = this.getResultOfExecExpression(datafilter, sourceBill, filterProperties, sourceBillId);
            value = Optional.ofNullable(value).map(o -> o).orElseGet(() -> {
                CRCondition crc = (CRCondition)SerializationUtils.fromJsonString((String)datafilter, CRCondition.class);
                String prop = crc.getExpression().trim();
                Object v = null;
                if (prop.indexOf(40) == -1) {
                    v = this.queryValueByProp(prop, sourceBillId, sourceBill.getLong("id"));
                }
                return v;
            });
        } else if (GetValueTypeEnum.FIXED_VALUE.getValue().equalsIgnoreCase(getValueType)) {
            value = messageSetting.get(this.getControlSign(type, "getvaluedesc"));
        }
        message.setField(messageSetting.getString(this.getControlSign(type, "messagefield")));
        message.setFieldDesc(messageSetting.getString(this.getControlSign(type, "fieldinstructions")));
        message.setRecord(messageSetting.getBoolean(this.getControlSign(type, "willrecord")));
        this.dealValue(messageSetting, message, value, datafilter, sourceBill, sourceBillId, type);
        return message;
    }

    private void dealValue(DynamicObject messageSetting, ExportDetail message, Object value, String expression, DynamicObject sourcebill, String sourceBillId, String type) {
        String valueType = messageSetting.getString(this.getControlSign(type, "fieldtype"));
        Integer length = messageSetting.getInt(this.getControlSign(type, "length"));
        if (ValueTypeEnum.TP_TEXT.getValue().equalsIgnoreCase(valueType)) {
            value = Optional.ofNullable(value).map(o -> {
                if (o instanceof DynamicObject) {
                    o = ((DynamicObject)o).getLocaleString("name").getLocaleValue();
                    message.setFieldValueNoSplit(o);
                }
                if (o instanceof Number) {
                    o = this.dealAmount(expression, sourcebill, sourceBillId, o, message);
                    message.setFieldValueNoSplit(o);
                }
                return o;
            }).orElseGet(() -> "");
            if (null != length && 0 != length) {
                int trueLength = Objects.toString(value).length();
                length = trueLength > length ? length : trueLength;
                value = Objects.toString(value).substring(0, length);
            }
            value = Objects.toString(value);
        } else if (ValueTypeEnum.TP_MONEY.getValue().equalsIgnoreCase(valueType)) {
            value = Optional.ofNullable(value).map(o -> {
                o = o instanceof Number ? this.dealAmount(expression, sourcebill, sourceBillId, o, message) : String.format(ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f\uff1a\u6b64\u5c5e\u6027\u201c%1$s\u201d \u4e0d\u662f\u201c%2$s\u201d\u5c5e\u6027\uff0c\u8bf7\u68c0\u67e5\u7f51\u94f6\u6a21\u7248\u914d\u7f6e\u3002", (String)"EBankMessageDataAPIImpl_3", (String)"tmc-fbp-business", (Object[])new Object[0]), this.getPropByExpress(expression), ValueTypeEnum.TP_MONEY.getName());
                return o;
            }).orElseGet(() -> "");
        } else if (ValueTypeEnum.TP_DATE.getValue().equalsIgnoreCase(valueType)) {
            value = Optional.ofNullable(value).map(o -> {
                if (!(o instanceof Date)) {
                    o = String.format(ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f\uff1a\u6b64\u5c5e\u6027\u201c%1$s\u201d \u4e0d\u662f\u201c%2$s\u201d\u5c5e\u6027\uff0c\u8bf7\u68c0\u67e5\u7f51\u94f6\u6a21\u7248\u914d\u7f6e\u3002", (String)"EBankMessageDataAPIImpl_3", (String)"tmc-fbp-business", (Object[])new Object[0]), this.getPropByExpress(expression), ValueTypeEnum.TP_DATE.getName());
                }
                return o;
            }).orElseGet(() -> "");
        } else if (ValueTypeEnum.TP_COUNT.getValue().equalsIgnoreCase(valueType)) {
            String getValueType = messageSetting.getString(this.getControlSign(type, "getvaluetype"));
            if (GetValueTypeEnum.FIXED_VALUE.getValue().equals(getValueType)) {
                value = Optional.ofNullable(value).map(o -> o.toString()).orElseGet(() -> "{count}");
                message.setCountElem("count");
            } else if (GetValueTypeEnum.SOURCE_BILL_FIELD.getValue().equals(getValueType)) {
                String prop = this.getPropByExpress(expression);
                message.setCountElem(prop);
                value = Optional.ofNullable(prop).map(o -> String.format("{%s}", o)).orElseGet(() -> null);
            }
        } else if (ValueTypeEnum.TP_SERIALNUM.getValue().equalsIgnoreCase(valueType)) {
            // empty if block
        }
        message.setLength(length);
        message.setFieldType(valueType);
        message.setFieldValue(value);
    }

    private BigDecimal dealAmount(String expression, DynamicObject sourcebill, String sourceBillId, Object value, ExportDetail message) {
        int amtprecision = 2;
        DynamicObject currency = this.getCurrency(this.getPropByExpress(expression), sourceBillId, sourcebill);
        amtprecision = Optional.ofNullable(currency).map(o -> o.getInt("amtprecision")).orElseGet(() -> 2);
        BigDecimal amount = new BigDecimal(Objects.toString(value));
        message.setAmtprecision(amtprecision);
        return amount.setScale(amtprecision, 4);
    }

    private DynamicObject getCurrency(String prop, String sourceBillId, DynamicObject sourcebill) {
        DecimalProp amtPro;
        DynamicObject currency = null;
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)sourceBillId);
        if (null != mainEntityType && null != (amtPro = (DecimalProp)mainEntityType.getProperty(prop))) {
            String linkCurrency = amtPro.getControlPropName();
            try {
                currency = (DynamicObject)this.queryValueByProp(linkCurrency, sourceBillId, sourcebill.getLong("id"));
            }
            catch (Exception e) {
                logger.error(String.format(ResManager.loadKDString((String)"\u5f53\u524d %s \u5355\uff0c\u4e0d\u5b58\u5728 %s \u7684\u5e01\u79cd\u3002", (String)"EBankMessageDataAPIImpl_2", (String)"tmc-fbp-business", (Object[])new Object[0]), sourceBillId, linkCurrency));
                currency = null;
            }
        }
        return currency;
    }

    private String getPropByExpress(String expression) {
        CRCondition crc = (CRCondition)SerializationUtils.fromJsonString((String)expression, CRCondition.class);
        return crc.getExpression().trim();
    }

    private void assemblyBodyInfo(FetchDataReponse response, Map<Long, String> failureDatas, Map<String, Map<Long, Map<String, ExportDetail>>> details) {
        ExportBody body = new ExportBody();
        body.setLength(Integer.valueOf(details.size()));
        body.setFailureDatas(failureDatas);
        body.setDetails(details);
        response.setBody(body);
    }

    private void assemblyHeaderInfo(FetchDataReponse response, DynamicObject template) {
        ExportHeader header = new ExportHeader();
        header.setExportType(FileFormatEnum.getFileFormatByValue((String)template.getString("exportformatter")));
        HashMap headerMap = new HashMap(4);
        HashMap recoderMap = new HashMap(4);
        LinkedHashMap headHeaderMap = new LinkedHashMap(16);
        LinkedHashMap headRecordMap = new LinkedHashMap(16);
        DynamicObjectCollection headerMessageSettings = template.getDynamicObjectCollection("header_messagefieldentry");
        headerMessageSettings.forEach(setting -> {
            headHeaderMap.put(setting.getString("header_messagefield"), setting.getString("header_fieldinstructions"));
            headRecordMap.put(setting.getString("header_messagefield"), setting.getBoolean("header_willrecord"));
        });
        headerMap.put("header", headHeaderMap);
        recoderMap.put("header", headRecordMap);
        LinkedHashMap bodyHeaderMap = new LinkedHashMap(16);
        LinkedHashMap bodyRecordMap = new LinkedHashMap(16);
        DynamicObjectCollection bodyMessageSettings = template.getDynamicObjectCollection("messagefieldentry");
        bodyMessageSettings.forEach(setting -> {
            bodyHeaderMap.put(setting.getString("messagefield"), setting.getString("fieldinstructions"));
            bodyRecordMap.put(setting.getString("messagefield"), setting.getBoolean("willrecord"));
        });
        headerMap.put("body", bodyHeaderMap);
        recoderMap.put("body", bodyRecordMap);
        LinkedHashMap footerHeaderMap = new LinkedHashMap(16);
        LinkedHashMap footerRecordMap = new LinkedHashMap(16);
        DynamicObjectCollection footerMessageSettings = template.getDynamicObjectCollection("footer_messagefieldentry");
        footerMessageSettings.forEach(setting -> {
            footerHeaderMap.put(setting.getString("footer_messagefield"), setting.getString("footer_fieldinstructions"));
            footerRecordMap.put(setting.getString("footer_messagefield"), setting.getBoolean("footer_willrecord"));
        });
        headerMap.put("footer", footerHeaderMap);
        recoderMap.put("footer", footerRecordMap);
        String charset = template.getString("charset");
        if (EmptyUtil.isEmpty((String)charset)) {
            charset = "GB2312";
        }
        header.setCharset(charset);
        header.setHeader(headerMap);
        header.setIsRecord(recoderMap);
        response.setHeader(header);
    }

    private List<DynamicObject> filterEligibleOfApplyCondition(DynamicObjectCollection sourceBills, DynamicObject template, Map<Long, String> failureDatas, Map<String, DynamicProperty> filterProperties, String sourceBillId) {
        ArrayList<DynamicObject> eligibleBill = new ArrayList<DynamicObject>((Collection<DynamicObject>)sourceBills);
        Iterator it = eligibleBill.iterator();
        while (it.hasNext()) {
            DynamicObject sourceBill = (DynamicObject)it.next();
            String condition = template.getString("datafilter_tag");
            CRCondition crc = (CRCondition)SerializationUtils.fromJsonString((String)condition, CRCondition.class);
            Boolean value = (Boolean)this.getResultOfExecExpression(condition, sourceBill, filterProperties, sourceBillId);
            if (value.booleanValue()) continue;
            failureDatas.put(sourceBill.getLong("id"), String.format(ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u9002\u7528\u6761\u4ef6\uff1a%s\u3002", (String)"EBankMessageDataAPIImpl_0", (String)"tmc-fbd-business", (Object[])new Object[0]), crc.getExprDesc()));
            it.remove();
        }
        return eligibleBill;
    }

    public Object getResultOfExecExpression(String datafilter, DynamicObject sourceBill, Map<String, DynamicProperty> fldProperties, String sourceBillId) {
        Object value = null;
        if (StringUtils.isNotEmpty((String)datafilter) && EBankMessageDataAPIImpl.isJson(datafilter)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)datafilter, CRCondition.class);
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)sourceBillId);
            String filterStr = condition.buildFullFormula(mainEntityType);
            SingleTaskContext taskContext = new SingleTaskContext();
            taskContext.setSrcEntityType(mainEntityType);
            if (!StringUtils.isEmpty((String)filterStr)) {
                try {
                    FormulaGetHandle basebillFilterHandle = new FormulaGetHandle((ISingleTaskContext)taskContext, filterStr, (Object)Boolean.FALSE);
                    value = basebillFilterHandle.GetVchFldValue(fldProperties, sourceBill, null);
                }
                catch (Exception e) {
                    value = String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f\u201c%1$s\u201d\uff0c\u5f02\u5e38\u4fe1\u606f\u5982\u4e0b\uff1a%2$s", (String)"EBankMessageDataAPIImpl_1", (String)"tmc-fbd-business", (Object[])new Object[0]), condition.getExpression(), ExceptionUtils.getStackTrace((Throwable)e));
                    logger.error(value.toString());
                }
            } else {
                value = "";
            }
        } else {
            value = datafilter;
        }
        return value;
    }

    private void statisticsData(Map<Long, Map<String, ExportDetail>> messageMap, List<DynamicObject> datas, String type) {
        boolean count = false;
        Long key = type.equals("header") ? 1L : (type.equals("footer") ? -1L : 0L);
        if ("body".equals(type)) {
            Set<Map.Entry<Long, Map<String, ExportDetail>>> entries = messageMap.entrySet();
            int index = 1;
            for (Map.Entry<Long, Map<String, ExportDetail>> entry : entries) {
                Map<String, ExportDetail> details = entry.getValue();
                for (Map.Entry<String, ExportDetail> detailEntry : details.entrySet()) {
                    ExportDetail detail = detailEntry.getValue();
                    if (!detail.getFieldType().equals(ValueTypeEnum.TP_SERIALNUM.getValue())) continue;
                    detail.setFieldValue((Object)index);
                    detail.setFieldValueNoSplit((Object)index);
                }
                ++index;
            }
        } else {
            Map<String, ExportDetail> exportDetailMap = messageMap.get(key);
            Set<Map.Entry<String, ExportDetail>> exportDetailEntrys = exportDetailMap.entrySet();
            for (Map.Entry<String, ExportDetail> entry : exportDetailEntrys) {
                ExportDetail detail = entry.getValue();
                String fieldType = detail.getFieldType();
                if (!ValueTypeEnum.TP_COUNT.getValue().equalsIgnoreCase(fieldType)) continue;
                String elem = detail.getCountElem();
                if (elem.equals("count")) {
                    detail.setFieldValue((Object)datas.size());
                    detail.setFieldValueNoSplit((Object)datas.size());
                    continue;
                }
                this.calcBillFieldCount(detail, datas, elem);
            }
        }
    }

    private void calcBillFieldCount(ExportDetail detail, List<DynamicObject> datas, String elem) {
        Object value = null;
        HashSet<Object> currecyIds = new HashSet<Object>(datas.size());
        try {
            String billName = null;
            BigDecimal total = BigDecimal.ZERO;
            for (DynamicObject data : datas) {
                DynamicObject currency;
                total = total.add(Optional.ofNullable(data.getBigDecimal(elem)).map(o -> o).orElseGet(() -> BigDecimal.ZERO));
                if (billName == null) {
                    billName = data.getDataEntityType().getName();
                }
                if ((currency = this.getCurrency(detail.getCountElem(), billName, data)) == null) continue;
                currecyIds.add(currency.getPkValue());
            }
            value = total;
            if (currecyIds.size() == 1) {
                int amtprecision = 2;
                if (billName != null && datas.size() > 0) {
                    DynamicObject currency = this.getCurrency(detail.getCountElem(), billName, datas.get(0));
                    amtprecision = Optional.ofNullable(currency).map(o -> o.getInt("amtprecision")).orElseGet(() -> 2);
                }
                BigDecimal amount = new BigDecimal(Objects.toString(value));
                detail.setAmtprecision(amtprecision);
                value = amount.setScale(amtprecision, 4);
            } else {
                detail.setFieldType(ValueTypeEnum.TP_TEXT.getValue());
                value = ResManager.loadKDString((String)"\u7f51\u94f6\u5bfc\u51fa\u6570\u636e\u5408\u8ba1\u91d1\u989d\u5b57\u6bb5[%s]\u4e0d\u5141\u8bb8\u5b58\u5728\u591a\u5e01\u79cd\u60c5\u51b5\u3002", (String)"EBankMessageDataAPIImpl_4", (String)"tmc-fbp-business", (Object[])new Object[]{elem});
                logger.error(value.toString());
            }
        }
        catch (Exception e) {
            detail.setFieldType(ValueTypeEnum.TP_TEXT.getValue());
            value = ResManager.loadKDString((String)"\u3010%1$s\u3011\u6c47\u603b\u8ba1\u7b97\u9879\u914d\u7f6e\u9519\u8bef\uff0c\u6b64\u5b57\u6bb5 %2$s \u4e0d\u80fd\u8fdb\u884c\u6c47\u603b\u8ba1\u7b97\u3002", (String)"EBankMessageDataAPIImpl_2", (String)"tmc-fbp-business", (Object[])new Object[]{detail.getField(), elem});
            logger.error(value.toString());
        }
        detail.setFieldValue(value);
        detail.setFieldValueNoSplit(value);
    }

    private static boolean isJson(String content) {
        if (StringUtils.isEmpty((String)content)) {
            return false;
        }
        boolean isJsonObject = true;
        boolean isJsonArray = true;
        try {
            JSONObject.parseObject((String)content);
        }
        catch (Exception e) {
            isJsonObject = false;
        }
        try {
            JSONObject.parseArray((String)content);
        }
        catch (Exception e) {
            isJsonArray = false;
        }
        return isJsonObject || isJsonArray;
    }

    private <T> int getMapContainerSize(List<T> collection, double factor) {
        return Optional.ofNullable(collection).map(list -> (int)Math.ceil((double)list.size() / factor)).orElseGet(() -> 16);
    }

    private Object queryValueByProp(String prop, String entityName, Object pkId) {
        DynamicObject querySourceBill = TmcDataServiceHelper.loadSingle((Object)pkId, (String)entityName);
        return querySourceBill.get(prop.trim());
    }

    private String getControlSign(String type, String sign) {
        return type.equals("body") ? sign : String.format("%s_%s", type, sign);
    }
}

