/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.changebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BooleanEnum;
import kd.tmc.fbp.common.enums.ChangeInfoTypeEnum;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public abstract class AbstractChangeBillAuditService
extends AbstractTmcBizOppService {
    private final Map<String, DynamicObject> entryRowMap = new HashMap<String, DynamicObject>(16);

    @Override
    public List<String> getSelector() {
        List<String> selector = super.getSelector();
        selector.add("billno");
        selector.add("srcbillpk");
        selector.add("srcbilltype");
        selector.add("chgreason");
        selector.add("entryentity");
        selector.add("entryentity.srcentryid");
        selector.add("entryentity.fieldname");
        selector.add("entryentity.entryname");
        selector.add("entryentity.srcbillentryid");
        selector.add("entryentity.newvalue");
        selector.add("entryentity.infotype");
        selector.add("entryentity.changeattachment");
        selector.add("entryentity.srcbillid");
        selector.add("modifier");
        return selector;
    }

    @Override
    public void beforeProcess(List<ExtendedDataEntity> dataEntities) throws KDException {
        super.beforeProcess(dataEntities);
        ArrayList<DynamicObject> srcBills = new ArrayList<DynamicObject>(dataEntities.size());
        Map<Long, String> srcBillTypeMap = dataEntities.stream().collect(Collectors.toMap(item -> item.getDataEntity().getLong("srcbillpk"), item -> item.getDataEntity().getString("srcbilltype")));
        DynamicObject[] srcBillArr = TmcDataServiceHelper.load((Object[])srcBillTypeMap.keySet().toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)dataEntities.get(0).getDataEntity().getString("srcbilltype")));
        Map<Long, DynamicObject> srcBillMap = Arrays.stream(srcBillArr).collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject changeBill = dataEntity.getDataEntity();
            long srcBillPk = changeBill.getLong("srcbillpk");
            DynamicObject srcBill = srcBillMap.get(srcBillPk);
            this.dealCustomProps(srcBill, changeBill);
            this.saveHistory(srcBill, changeBill);
            DynamicObjectCollection changeEntry = changeBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : changeEntry) {
                String seq = row.getString("srcentryid").trim();
                String fieldName = row.getString("fieldname");
                String entryName = row.getString("entryname").trim();
                long entryId = row.getLong("srcbillentryid");
                Object value = this.getNewValue(srcBill, row, fieldName, entryName);
                if (EmptyUtil.isNoEmpty((String)entryName)) {
                    DynamicObjectCollection entryValue = srcBill.getDynamicObjectCollection(entryName);
                    entryValue.sort(Comparator.comparingInt(row2 -> row2.getInt("seq")));
                    this.processEntry(entryValue, seq, fieldName, entryName, value, entryId);
                    continue;
                }
                srcBill.set(fieldName, value);
            }
            srcBill.set("modifier", (Object)changeBill.getDynamicObject("modifier").getLong("id"));
            srcBill.set("modifytime", (Object)new Date());
            srcBills.add(srcBill);
        }
        SaveServiceHelper.save((DynamicObject[])srcBills.toArray(new DynamicObject[0]));
    }

    @Override
    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    protected abstract void dealCustomProps(DynamicObject var1, DynamicObject var2);

    protected abstract String getHistoryTableName();

    protected abstract String getHistoryEntityName();

    protected abstract String getHistoryVersionPrefix();

    private void saveHistory(DynamicObject srcBill, DynamicObject changeBill) {
        BillChangeHistoryHelper.addChangeHistory((Long)((Long)changeBill.getPkValue()), (String)changeBill.getDataEntityType().getName(), (String)changeBill.getString("billno"), (String)changeBill.getString("chgreason"), (String)this.getHistoryVersionPrefix(), (DynamicObject)srcBill, (String)this.getHistoryTableName(), (String)this.getHistoryEntityName());
    }

    private void processEntry(DynamicObjectCollection entryValue, String seq, String fieldName, String entryName, Object value, long entryId) {
        String entryRowKey = entryName + seq + entryId;
        DynamicObject srmEntryRow = this.entryRowMap.get(entryRowKey);
        if (srmEntryRow == null) {
            srmEntryRow = this.putEntryRowMap(entryValue, entryRowKey, entryId);
        }
        if (srmEntryRow != null) {
            srmEntryRow.set(fieldName, value);
        }
    }

    private DynamicObject putEntryRowMap(DynamicObjectCollection entryValue, String entryRowKey, long entryId) {
        DynamicObject resEntryRow = null;
        if (entryId != 0L && entryId != 1L) {
            for (DynamicObject entryRow : entryValue) {
                long id = entryRow.getLong("id");
                if (id != entryId) continue;
                this.entryRowMap.put(entryRowKey, entryRow);
                resEntryRow = entryRow;
            }
        } else {
            DynamicObject newRow = entryValue.addNew();
            long newSeq = entryValue.size() + 1;
            newRow.set("seq", (Object)newSeq);
            this.entryRowMap.put(entryRowKey, newRow);
            resEntryRow = newRow;
        }
        return resEntryRow;
    }

    private Object getNewValue(DynamicObject srcBill, DynamicObject row, String fieldName, String entryName) {
        Object value;
        String newValue = row.getString("newvalue");
        String infoType = row.getString("infotype");
        ChangeInfoTypeEnum infoTypeEnum = ChangeInfoTypeEnum.getEnumByValue((String)infoType);
        switch (infoTypeEnum) {
            case MULBASEDATA: {
                value = this.getMulBaseDataValue(srcBill, row, entryName, fieldName);
                break;
            }
            case BASEDATA: {
                if (EmptyUtil.isNoEmpty((String)entryName)) {
                    IDataEntityProperty property = (IDataEntityProperty)srcBill.getDynamicObjectCollection(entryName).getDynamicObjectType().getProperties().get((Object)fieldName);
                    String srcBillId = row.getString("srcbillid");
                    if (property instanceof BasedataProp) {
                        String entityName = ((BasedataProp)property).getBaseEntityId();
                        value = EmptyUtil.isNoEmpty((String)srcBillId) ? TmcDataServiceHelper.loadSingle((Object)srcBillId, (String)entityName) : null;
                        break;
                    }
                    value = EmptyUtil.isNoEmpty((String)row.getString("srcbillid").trim()) ? row.getString("srcbillid").trim() : null;
                    break;
                }
                value = EmptyUtil.isNoEmpty((String)row.getString("srcbillid").trim()) ? row.getString("srcbillid").trim() : null;
                break;
            }
            case DATE: {
                value = DateUtils.stringToDate((String)newValue, (String)"yyyy-MM-dd");
                break;
            }
            case BOOLEAN: {
                value = newValue != null && newValue.equals(BooleanEnum.TRUE.getName());
                break;
            }
            case ATTACHMENT: {
                value = this.getAttachmentValue(row);
                break;
            }
            default: {
                value = newValue;
            }
        }
        return value;
    }

    private Object getAttachmentValue(DynamicObject row) {
        DynamicObjectCollection changeAttachmentCol = row.getDynamicObjectCollection("changeattachment");
        DynamicObjectCollection entryAttNewValue = new DynamicObjectCollection(changeAttachmentCol.getDynamicObjectType(), null);
        ORM orm = ORM.create();
        for (DynamicObject changeAttachment : changeAttachmentCol) {
            DynamicObject targetAttachment = this.getTargetAttachment(orm, changeAttachment);
            targetAttachment.set("fbasedataid", changeAttachment.get(1));
            entryAttNewValue.add((Object)targetAttachment);
        }
        return entryAttNewValue;
    }

    private DynamicObject getTargetAttachment(ORM orm, DynamicObject changeAttachment) {
        return orm.newDynamicObject((DynamicObjectType)changeAttachment.getDataEntityType());
    }

    public void deleteInvalidRows(DynamicObject billObj, String entryName) {
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection(entryName);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)rows)) {
            MainEntityType mainType = (MainEntityType)billObj.getDataEntityType();
            EntryProp entryProp = (EntryProp)mainType.getProperties().get((Object)entryName);
            String key = entryProp.getKeyFieldId();
            Iterator ite = rows.iterator();
            HashSet<String> seqSet = new HashSet<String>(16);
            while (ite.hasNext()) {
                Object keyFieldValue;
                DynamicObject obj = (DynamicObject)ite.next();
                if (key != null && ((keyFieldValue = obj.get(key)) == null || keyFieldValue.toString().trim().equals("") || keyFieldValue instanceof DynamicObjectCollection && ((DynamicObjectCollection)keyFieldValue).isEmpty() || "indextype".equals(key) && "0".equals(keyFieldValue))) {
                    ite.remove();
                    continue;
                }
                if (seqSet.contains(obj.getString("seq"))) {
                    ite.remove();
                    continue;
                }
                seqSet.add(obj.getString("seq"));
            }
        }
    }

    private Object getMulBaseDataValue(DynamicObject srcBill, DynamicObject row, String entryName, String fieldName) {
        DynamicObjectCollection col = new DynamicObjectCollection();
        DynamicObject tempRow = null;
        if (EmptyUtil.isNoEmpty((String)entryName)) {
            EntryType entryType = (EntryType)((EntryProp)srcBill.getDataEntityType().getProperties().get((Object)entryName)).getItemType();
            tempRow = new DynamicObject((DynamicObjectType)entryType);
        } else {
            tempRow = srcBill;
        }
        MulBasedataProp mulBasedataProp = (MulBasedataProp)tempRow.getDataEntityType().getProperties().get((Object)fieldName);
        DynamicObjectType muldata_EtryType = (DynamicObjectType)mulBasedataProp.getItemType();
        String value = row.getString("srcbillid").trim();
        if (EmptyUtil.isNoEmpty((String)value)) {
            DynamicObject[] baseDataValues;
            String[] ids = value.split(",");
            QFilter idFilter = new QFilter("id", "in", this.transToList(ids));
            for (DynamicObject baseData : baseDataValues = BusinessDataServiceHelper.load((String)mulBasedataProp.getBaseEntityId(), (String)"id", (QFilter[])new QFilter[]{idFilter})) {
                DynamicObject dynObj = new DynamicObject(muldata_EtryType);
                dynObj.set(1, (Object)baseData);
                col.add((Object)dynObj);
            }
        }
        return col;
    }

    private Set<Long> transToList(String[] ids) {
        HashSet<Long> idList = new HashSet<Long>(ids.length);
        for (String id : ids) {
            idList.add(Long.valueOf(id));
        }
        return idList;
    }
}

