/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.common.chain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.fbp.business.opservice.common.chain.BusinessBatchHandler;
import kd.tmc.fbp.business.opservice.common.chain.BusinessHandleParam;

public class BusinessBatchHandlerChain {
    private final List<BusinessBatchHandler> handlers = new ArrayList<BusinessBatchHandler>(8);
    private BusinessHandleParam handleParam = null;

    public BusinessHandleParam getHandleParam() {
        return this.handleParam;
    }

    public BusinessBatchHandlerChain setHandleParam(BusinessHandleParam handleParam) {
        this.handleParam = handleParam;
        return this;
    }

    public BusinessBatchHandlerChain addHandler(BusinessBatchHandler ... handlerList) {
        this.handlers.addAll(Arrays.asList(handlerList));
        return this;
    }

    public void doBeforeProcess(DynamicObject[] bizBills) {
        this.handlers.stream().filter(h -> h.doFilter(bizBills, this.handleParam)).forEach(h -> h.doBeforeProcess(bizBills, this.handleParam));
    }

    public void doProcess(DynamicObject[] bizBills) {
        this.handlers.stream().filter(h -> h.doFilter(bizBills, this.handleParam)).forEach(h -> h.doProcess(bizBills, this.handleParam));
    }

    public void doBeforeCommit(DynamicObject[] bizBills) {
        this.handlers.stream().filter(h -> h.doFilter(bizBills, this.handleParam)).forEach(h -> h.doBeforeCommit(bizBills, this.handleParam));
    }

    public void doAfterProcess(DynamicObject[] bizBills) {
        this.handlers.stream().filter(h -> h.doFilter(bizBills, this.handleParam)).forEach(h -> h.doAfterProcess(bizBills, this.handleParam));
    }

    public void doAfterProcessRollback(DynamicObject[] bizBills) {
        this.handlers.stream().filter(h -> h.doFilter(bizBills, this.handleParam)).forEach(h -> h.doAfterProcessRollback(bizBills, this.handleParam));
    }
}

