/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.common.chain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.fbp.business.opservice.common.chain.BusinessHandleParam;
import kd.tmc.fbp.business.opservice.common.chain.BusinessHandler;

public class BusinessHandlerChain {
    private final List<BusinessHandler> handlers = new ArrayList<BusinessHandler>(10);
    private BusinessHandleParam handleParam;

    public BusinessHandleParam getHandleParam() {
        return this.handleParam;
    }

    public BusinessHandlerChain setHandleParam(BusinessHandleParam handleParam) {
        this.handleParam = handleParam;
        return this;
    }

    public BusinessHandlerChain addHandler(BusinessHandler ... handlerList) {
        this.handlers.addAll(Arrays.asList(handlerList));
        return this;
    }

    public void doBeforeProcess(DynamicObject bizBill) {
        this.handlers.stream().filter(h -> h.doFilter(bizBill, this.handleParam)).forEach(h -> h.doBeforeProcess(bizBill, this.handleParam));
    }

    public void doProcess(DynamicObject bizBill) {
        this.handlers.stream().filter(h -> h.doFilter(bizBill, this.handleParam)).forEach(h -> h.doProcess(bizBill, this.handleParam));
    }

    public void doBeforeCommit(DynamicObject bizBill) {
        this.handlers.stream().filter(h -> h.doFilter(bizBill, this.handleParam)).forEach(h -> h.doBeforeCommit(bizBill, this.handleParam));
    }

    public void doAfterProcess(DynamicObject bizBill) {
        this.handlers.stream().filter(h -> h.doFilter(bizBill, this.handleParam)).forEach(h -> h.doAfterProcess(bizBill, this.handleParam));
    }

    public void doAfterProcessRollback(DynamicObject bizBill) {
        this.handlers.stream().filter(h -> h.doFilter(bizBill, this.handleParam)).forEach(h -> h.doAfterProcessRollback(bizBill, this.handleParam));
    }
}

