/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.feedetail;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FeeDetailSrcBillStatusEnum;
import kd.tmc.fbp.common.enums.FeeSourceEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.property.FeeDetailBillProp;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FeeDetailAuditService
extends AbstractTmcBizOppService {
    @Override
    public List<String> getSelector() {
        List<String> sic = super.getSelector();
        sic.add("billno");
        sic.add("id");
        sic.add("feedetail");
        return sic;
    }

    @Override
    public void process(DynamicObject[] dynamicObjects) throws KDException {
        DynamicObject[] updateFeeBills;
        List cfmBizBillIds = Arrays.stream(dynamicObjects).map(o -> o.getLong("id")).collect(Collectors.toList());
        QFilter feeHandFilter = new QFilter("entry.srcbillid", "in", cfmBizBillIds).and("feesource", "=", (Object)FeeSourceEnum.LINKGEN.getValue()).and("entry.srcstatus", "not in", (Object)FeeDetailBillProp.ENTRY_SRCSTATUS_VALUE);
        Object[] feeBills = TmcDataServiceHelper.load((String)"cfm_feebill", (String)"id,billstatus,auditor", (QFilter[])new QFilter[]{feeHandFilter});
        if (EmptyUtil.isNoEmpty((Object[])feeBills)) {
            for (Object feeBill : feeBills) {
                feeBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
                feeBill.set("auditor", (Object)RequestContext.get().getCurrUserId());
            }
            SaveServiceHelper.save((DynamicObject[])feeBills);
        }
        ArrayList<DynamicObject> needSaveFeeBillLists = new ArrayList<DynamicObject>(10);
        QFilter qFilter = new QFilter("entry.srcbillid", "in", cfmBizBillIds).and("entry.srcstatus", "in", (Object)FeeDetailBillProp.ENTRY_SRCSTATUS_VALUE);
        for (DynamicObject feeBill : updateFeeBills = TmcDataServiceHelper.load((String)"cfm_feebill", (String)"id,enpayamt,payamt,entry.srcbillid,entry.srcstatus,entry.feedetailamt", (QFilter[])qFilter.toArray())) {
            DynamicObjectCollection entrys = feeBill.getDynamicObjectCollection("entry");
            BigDecimal enPayAmt = feeBill.getBigDecimal("enpayamt");
            for (DynamicObject row : entrys) {
                if (!cfmBizBillIds.contains(row.getLong("srcbillid")) || !EmptyUtil.isNoEmpty((String)row.getString("srcstatus"))) continue;
                row.set("srcstatus", (Object)FeeDetailSrcBillStatusEnum.AUDIT.getValue());
                BigDecimal payAmt = row.getBigDecimal("feedetailamt");
                enPayAmt = enPayAmt.subtract(payAmt);
            }
            feeBill.set("enpayamt", (Object)enPayAmt);
            needSaveFeeBillLists.add(feeBill);
        }
        if (EmptyUtil.isNoEmpty(needSaveFeeBillLists)) {
            SaveServiceHelper.save((DynamicObject[])needSaveFeeBillLists.toArray(new DynamicObject[0]));
        }
    }
}

