/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.init;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.olap.util.Pair;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.init.ITmcSyncData;
import kd.tmc.fbp.common.init.SyncDataResult;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankBalanceUpdateService
implements ITmcSyncData {
    private static final String SELECT_FIELD = "id,billstatus,company,billno,bizdate,currency,amount,valibalance,lstbalance,bank,accountbank,datasource,freezebalance,extraaccno,description,logo,isupdate,modifytime,auditdate,createtime,modifier,sourcebillid,auditor,creator,exchangerate,locamt";
    private static final String ACCOUNTBANK = "accountbank";
    private static final String BIZDATE = "bizdate";
    private static int updateDays = 365;
    private static final Log logger = LogFactory.getLog(BankBalanceUpdateService.class);

    public SyncDataResult syncData() {
        SyncDataResult result = new SyncDataResult();
        result.setBeginDate((Date)DateUtils.getCurrentTime());
        int successCount = 0;
        Date currencyDate = DateUtils.getCurrentDate();
        StringBuilder faildDate = new StringBuilder();
        for (int i = 0; i < updateDays; ++i) {
            long oneDateBeginTime = System.currentTimeMillis();
            Date updateDate = DateUtils.getNextDay((Date)currencyDate, (int)(i - updateDays));
            try {
                HashSet<Long> singleAccount = new HashSet<Long>(16);
                HashSet<Long> mulitAccount = new HashSet<Long>(16);
                ArrayList<Pair<Long, Long>> mulitAccountInfo = new ArrayList<Pair<Long, Long>>(10);
                BankBalanceUpdateService.getAccountIds(updateDate, singleAccount, mulitAccount, mulitAccountInfo);
                Set<Long> updateAccount = BankBalanceUpdateService.getHaveBalanceAccountIds(updateDate, singleAccount);
                logger.info("\u5f53\u5929\u9700\u8981\u5347\u7ea7\u4f59\u989d\u8d26\u6237\u6570\u91cf" + updateAccount.size() + "\u65e5\u671f\uff1a" + DateUtils.formatString((Date)updateDate, (String)"yyyy-MM-dd"));
                logger.info(DateUtils.formatString((Date)updateDate, (String)"yyyy-MM-dd") + "\u5f53\u5929\u9700\u8981\u5347\u7ea7\u4f59\u989d\u7684\u8d26\u6237\uff1a" + updateAccount.stream().map(a -> String.valueOf(a)).collect(Collectors.joining(",")));
                ArrayList<Object[]> oneDateBatch = new ArrayList<Object[]>(10);
                if (i == 0) {
                    for (Long updateAccountId : updateAccount) {
                        this.dealOneAccount(updateDate, updateAccountId, oneDateBatch);
                    }
                    this.dealFirstMulitAccount(mulitAccount, mulitAccountInfo, updateDate, oneDateBatch);
                } else {
                    this.dealBatchAccount(updateDate, updateAccount, oneDateBatch);
                    this.dealBatchMulitAccount(mulitAccount, mulitAccountInfo, updateDate, oneDateBatch);
                }
                if (EmptyUtil.isNoEmpty(oneDateBatch)) {
                    this.saveOneDate(oneDateBatch);
                    successCount += oneDateBatch.size();
                    logger.info("\u8d26\u6237\u4f59\u989d\u5347\u7ea7\uff0c\u65e5\u671f\uff1a" + DateUtils.formatString((Date)updateDate, (String)"yyyy-MM-dd") + " \u63d2\u5165\u6570\u91cf:" + oneDateBatch.size());
                    logger.info(DateUtils.formatString((Date)updateDate, (String)"yyyy-MM-dd") + "\u8d26\u6237\u4f59\u989d\u5347\u7ea7\u8d26\u6237\uff1a" + oneDateBatch.stream().map(r -> String.valueOf((Long)r[10])).collect(Collectors.joining(",")));
                }
                logger.info("\u4e00\u5929\u4f59\u989d\u5347\u7ea7\u8017\u65f6:" + (System.currentTimeMillis() - oneDateBeginTime) + "date:" + DateUtils.formatString((Date)updateDate, (String)"yyyy-MM-dd"));
                continue;
            }
            catch (Exception e) {
                logger.error("\u8d26\u6237\u4f59\u989d\u5347\u7ea7\u5931\u8d25" + DateUtils.formatString((Date)updateDate, (String)"yyyy-MM-dd"));
                logger.error((Throwable)e);
                faildDate.append(DateUtils.formatString((Date)updateDate, (String)"yyyy-MM-dd"));
            }
        }
        result.setSuccessCount(successCount);
        result.setEndDate((Date)DateUtils.getCurrentTime());
        if (EmptyUtil.isNoEmpty((String)faildDate.toString())) {
            result.setResult(faildDate.toString());
        }
        return result;
    }

    private void dealBatchMulitAccount(Set<Long> mulitAccount, List<Pair<Long, Long>> mulitAccountInfo, Date updateDate, List<Object[]> oneDateBatch) {
        QFilter filter = new QFilter(ACCOUNTBANK, "in", mulitAccount);
        QFilter dateFilter = new QFilter(BIZDATE, ">=", (Object)DateUtils.getDataFormat((Date)updateDate, (boolean)true));
        dateFilter.and(BIZDATE, "<", (Object)DateUtils.getDataFormat((Date)DateUtils.getNextDay((Date)updateDate, (int)1), (boolean)true));
        filter.and(dateFilter);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"BankBalanceUpdateService.getHaveBalanceAccountIds", (String)"bei_bankbalance", (String)"accountbank,currency", (QFilter[])new QFilter[]{filter}, null);
        ArrayList<Pair> haveBalanceAccountInfo = new ArrayList<Pair>(10);
        while (ds.hasNext()) {
            Row row = ds.next();
            haveBalanceAccountInfo.add(new Pair((Object)row.getLong(ACCOUNTBANK), (Object)row.getLong("currency")));
        }
        mulitAccountInfo.removeAll(haveBalanceAccountInfo);
        for (Pair<Long, Long> tempInfo : mulitAccountInfo) {
            Date lastDate = DateUtils.getNextDay((Date)updateDate, (int)-1);
            QFilter lastBalanceFilter = new QFilter(ACCOUNTBANK, "=", tempInfo.getValue0());
            lastBalanceFilter.and("currency", "=", tempInfo.getValue1());
            QFilter lastBalaceDateFilter = new QFilter(BIZDATE, ">=", (Object)DateUtils.getDataFormat((Date)lastDate, (boolean)true));
            lastBalaceDateFilter.and(BIZDATE, "<", (Object)DateUtils.getDataFormat((Date)updateDate, (boolean)true));
            DataSet lastBalance = QueryServiceHelper.queryDataSet((String)"BankBalanceUpdateService.queryone", (String)"bei_bankbalance", (String)SELECT_FIELD, (QFilter[])new QFilter[]{lastBalanceFilter, lastBalaceDateFilter}, (String)"bizdate desc", (int)1);
            this.addNewRow(updateDate, oneDateBatch, lastBalance);
        }
    }

    private void dealFirstMulitAccount(Set<Long> mulitAccount, List<Pair<Long, Long>> mulitAccountInfo, Date updateDate, List<Object[]> oneDateBatch) {
        QFilter filter = new QFilter(ACCOUNTBANK, "in", mulitAccount);
        QFilter dateFilter = new QFilter(BIZDATE, ">=", (Object)DateUtils.getDataFormat((Date)updateDate, (boolean)true));
        dateFilter.and(BIZDATE, "<", (Object)DateUtils.getDataFormat((Date)DateUtils.getNextDay((Date)updateDate, (int)1), (boolean)true));
        filter.and(dateFilter);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"BankBalanceUpdateService.getHaveBalanceAccountIds", (String)"bei_bankbalance", (String)"accountbank,currency", (QFilter[])new QFilter[]{filter}, null);
        ArrayList<Pair> haveBalanceAccountInfo = new ArrayList<Pair>(10);
        while (ds.hasNext()) {
            Row row = ds.next();
            haveBalanceAccountInfo.add(new Pair((Object)row.getLong(ACCOUNTBANK), (Object)row.getLong("currency")));
        }
        mulitAccountInfo.removeAll(haveBalanceAccountInfo);
        for (Pair<Long, Long> tempInfo : mulitAccountInfo) {
            QFilter lastBalanceFilter = new QFilter(ACCOUNTBANK, "=", tempInfo.getValue0());
            lastBalanceFilter.and("currency", "=", tempInfo.getValue1());
            lastBalanceFilter.and(BIZDATE, "<", (Object)updateDate);
            DataSet lastBalance = QueryServiceHelper.queryDataSet((String)"BankBalanceUpdateService.queryone", (String)"bei_bankbalance", (String)SELECT_FIELD, (QFilter[])lastBalanceFilter.toArray(), (String)"bizdate desc", (int)1);
            this.addNewRow(updateDate, oneDateBatch, lastBalance);
        }
    }

    private void dealBatchAccount(Date updateDate, Set<Long> updateAccount, List<Object[]> oneDateBatch) {
        Date lastDate = DateUtils.getNextDay((Date)updateDate, (int)-1);
        QFilter filter = new QFilter(ACCOUNTBANK, "in", updateAccount);
        QFilter dateFilter = new QFilter(BIZDATE, ">=", (Object)DateUtils.getDataFormat((Date)lastDate, (boolean)true));
        dateFilter.and(BIZDATE, "<", (Object)DateUtils.getDataFormat((Date)updateDate, (boolean)true));
        filter.and(dateFilter);
        DataSet lastBalance = QueryServiceHelper.queryDataSet((String)"BankBalanceUpdateService.queryone", (String)"bei_bankbalance", (String)SELECT_FIELD, (QFilter[])filter.toArray(), null);
        this.addNewRow(updateDate, oneDateBatch, lastBalance);
    }

    private void saveOneDate(List<Object[]> oneDateBatch) {
        String insertSql = "insert into t_bei_bankbalance(fid,fbillstatus,fcompanyid,fbillno,fbizdate,fcurrencyid,famount,fvalibalance,flstbalance,fbankid,faccountbankid,fdatasource,ffreezebalance,fextraaccno,fdescription,flogo,fisupdate,fmodifytime,fauditdate,fcreatetime,fmodifierid,fsourcebillid,fauditorid,fcreatorid,fexchangerate,flocamt) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)insertSql, oneDateBatch);
    }

    private void dealOneAccount(Date updateDate, Long updateAccountId, List<Object[]> oneDateBatch) {
        QFilter filter = new QFilter(ACCOUNTBANK, "=", (Object)updateAccountId);
        filter.and(BIZDATE, "<", (Object)updateDate);
        DataSet lastBalance = QueryServiceHelper.queryDataSet((String)"BankBalanceUpdateService.queryone", (String)"bei_bankbalance", (String)SELECT_FIELD, (QFilter[])filter.toArray(), (String)"bizdate desc", (int)1);
        this.addNewRow(updateDate, oneDateBatch, lastBalance);
    }

    private void addNewRow(Date updateDate, List<Object[]> oneDateBatch, DataSet lastBalance) {
        for (Row row : lastBalance) {
            Object[] newRow = new Object[]{DBServiceHelper.genGlobalLongId(), row.get("billstatus"), row.get("company"), row.get("billno"), updateDate, row.get("currency"), row.get("amount"), row.get("valibalance"), row.get("lstbalance"), row.get("bank"), row.get(ACCOUNTBANK), "update", row.get("freezebalance"), row.get("extraaccno"), row.get("description"), row.get("logo"), row.get("isupdate"), new Date(), row.get("auditdate"), row.get("createtime"), row.get("modifier"), row.get("id"), row.get("auditor"), row.get("creator"), row.get("exchangerate"), row.get("locamt")};
            oneDateBatch.add(newRow);
        }
    }

    public static void getAccountIds(Date queryDate, Set<Long> singleAccount, Set<Long> mulitAccount, List<Pair<Long, Long>> mulitAccountInfo) {
        QFilter notBankIntefaceFilter = new QFilter("issetbankinterface", "=", (Object)Boolean.FALSE);
        QFilter accountFilter = new QFilter("opendate", "<", (Object)DateUtils.getNextDay((Date)DateUtils.getDataFormat((Date)queryDate, (boolean)true), (int)1));
        QFilter closeDateFilter = new QFilter("closedate", "is null", null).or("closedate", ">=", (Object)DateUtils.getNextDay((Date)DateUtils.getDataFormat((Date)queryDate, (boolean)true), (int)1));
        DataSet bankAcctSet = QueryServiceHelper.queryDataSet((String)"BankAcctSum", (String)"bd_accountbanks", (String)"id,currency.fbasedataid.id as currencyid", (QFilter[])new QFilter[]{accountFilter, closeDateFilter, notBankIntefaceFilter}, null).groupBy(new String[]{"id"}).count("accnum").finish();
        DataSet[] splitAcctDataSet = bankAcctSet.splitByFilter(new String[]{"accnum > 1"}, true);
        for (Row row : splitAcctDataSet[0]) {
            mulitAccount.add(row.getLong("id"));
        }
        for (Row row : splitAcctDataSet[1]) {
            singleAccount.add(row.getLong("id"));
        }
        DataSet multiAcctSet = QueryServiceHelper.queryDataSet((String)"multiBankAcctSum", (String)"bd_accountbanks", (String)"id,currency.fbasedataid.id as currencyid", (QFilter[])new QFilter[]{new QFilter("id", "in", mulitAccount)}, null);
        for (Row row : multiAcctSet) {
            mulitAccountInfo.add((Pair<Long, Long>)new Pair((Object)row.getLong("id"), (Object)row.getLong("currencyid")));
        }
        logger.info("single\u8d26\u6237\u6570\u91cf" + singleAccount.size() + "multi\u8d26\u6237\u6570\u91cf" + mulitAccount.size() + "\u65e5\u671f\uff1a" + DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd"));
        logger.info("\u5f53\u5929\u9700\u8981\u6709\u4f59\u989d\u7684single\u8d26\u6237\uff1a" + singleAccount.stream().map(a -> String.valueOf(a)).collect(Collectors.joining(",")));
        logger.info("\u5f53\u5929\u9700\u8981\u6709\u4f59\u989d\u7684multi\u8d26\u6237\uff1a" + mulitAccount.stream().map(a -> String.valueOf(a)).collect(Collectors.joining(",")));
    }

    public static Set<Long> getHaveBalanceAccountIds(Date queryDate, Set<Long> accountIds) {
        QFilter filter = new QFilter(ACCOUNTBANK, "in", accountIds);
        QFilter dateFilter = new QFilter(BIZDATE, ">=", (Object)DateUtils.getDataFormat((Date)queryDate, (boolean)true));
        dateFilter.and(BIZDATE, "<", (Object)DateUtils.getDataFormat((Date)DateUtils.getNextDay((Date)queryDate, (int)1), (boolean)true));
        filter.and(dateFilter);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"BankBalanceUpdateService.getHaveBalanceAccountIds", (String)"bei_bankbalance", (String)"accountbank,currency", (QFilter[])new QFilter[]{filter}, null);
        HashSet<Long> haveBalanceAccountIds = new HashSet<Long>(16);
        while (ds.hasNext()) {
            haveBalanceAccountIds.add(ds.next().getLong(ACCOUNTBANK));
        }
        logger.info("\u5f53\u5929\u6709\u4f59\u989d\u8d26\u6237\u6570\u91cf" + haveBalanceAccountIds.size() + "\u65e5\u671f\uff1a" + DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd"));
        logger.info("\u5f53\u5929\u6709\u4f59\u989d\u7684\u8d26\u6237\uff1a" + haveBalanceAccountIds.stream().map(a -> String.valueOf(a)).collect(Collectors.joining(",")));
        accountIds.removeAll(haveBalanceAccountIds);
        return accountIds;
    }
}

