/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.init;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.init.ITmcSyncData;
import kd.tmc.fbp.common.init.SyncDataResult;
import kd.tmc.fbp.common.util.DateUtils;

public class ElecBalanceRecUpdateService
implements ITmcSyncData {
    private static Log logger = LogFactory.getLog(ElecBalanceRecUpdateService.class);

    public SyncDataResult syncData() {
        SyncDataResult result = new SyncDataResult();
        result.setBeginDate(new Date());
        result.setSuccessCount(this.mergeElecBalState());
        result.setEndDate(new Date());
        return result;
    }

    private int mergeElecBalState() {
        AtomicInteger count = new AtomicInteger();
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                String selectStr = "select a.faccountbankid,a.fperiod,b.fprotocol,b.fstateno,count(1) from t_bei_elecstatement a left join t_bei_elecstatement_b b on a.fid=b.fid where a.fbilltype='bei_elecbalancestate' group by a.faccountbankid,a.fperiod,b.fprotocol,b.fstateno having count(1) > 1;";
                List filterList = (List)DB.query((DBRoute)DBRouteConst.TMC, (String)selectStr, (Object[])new Object[0], rs -> {
                    ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(5);
                    while (rs.next()) {
                        QFilter qFilter = new QFilter("billtype", "=", (Object)"bei_elecbalancestate");
                        qFilter.and("accountbank", "=", (Object)rs.getLong(1));
                        qFilter.and("period", "=", (Object)rs.getDate(2));
                        qFilter.and("protocol", "=", (Object)rs.getString(3));
                        qFilter.and("stateno", "=", (Object)rs.getString(4));
                        qFilterList.add(qFilter);
                    }
                    return qFilterList;
                });
                filterList.forEach(filter -> {
                    DynamicObjectCollection urlEntry;
                    DynamicObject[] updateObj = BusinessDataServiceHelper.load((String)"bei_elecbalancestate", (String)"id,modifytime,modifier,accountbank,period,protocol,stateno,billtype,urlentry,urlentry.e_fileservicepath,urlentry.e_filesuffix", (QFilter[])new QFilter[]{filter});
                    LinkedHashMap<String, String> fileMap = new LinkedHashMap<String, String>(5);
                    for (DynamicObject obj : updateObj) {
                        urlEntry = obj.getDynamicObjectCollection("urlentry");
                        for (DynamicObject url : urlEntry) {
                            String fileServicePath = url.getString("e_fileservicepath");
                            String fileSuffix = url.getString("e_filesuffix");
                            fileMap.put(fileServicePath, fileSuffix);
                        }
                    }
                    for (DynamicObject upObj : updateObj) {
                        upObj.set("modifytime", (Object)DateUtils.getCurrentTime());
                        upObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
                        urlEntry = upObj.getDynamicObjectCollection("urlentry");
                        urlEntry.clear();
                        for (Map.Entry entry : fileMap.entrySet()) {
                            DynamicObject urlAddNew = urlEntry.addNew();
                            urlAddNew.set("e_fileservicepath", entry.getKey());
                            urlAddNew.set("e_filesuffix", entry.getValue());
                        }
                        count.getAndIncrement();
                    }
                    SaveServiceHelper.save((DynamicObject[])updateObj);
                });
            }
            catch (Exception e) {
                logger.error("ElecBalanceRecUpdateService#mergeElecBalState error", (Throwable)e);
                txHandle.markRollback();
                throw e;
            }
        }
        return count.get();
    }
}

