/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.init;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.init.ITmcSyncData;
import kd.tmc.fbp.common.init.SyncDataResult;

public class FinSubscribeUpdateService
implements ITmcSyncData {
    private static Log logger = LogFactory.getLog(FinSubscribeUpdateService.class);

    public SyncDataResult syncData() {
        SyncDataResult result = new SyncDataResult();
        result.setBeginDate(new Date());
        String subSql = "select fid,fpaybillno,fpaybillid from t_cim_finsubscribe where fpaybillno is not null and fpaybillno <>'' and fpaybillno <>' ' and (fpaybillid is null or fpaybillid=0)";
        Map subResult = (Map)DB.query((DBRoute)DBRouteConst.TMC, (String)subSql, (ResultSetHandler)new ResultSetHandler<Map<String, Long>>(){

            public Map<String, Long> handle(ResultSet resultSet) throws Exception {
                HashMap<String, Long> dataMap = new HashMap<String, Long>(2);
                while (resultSet.next()) {
                    dataMap.put(resultSet.getString("fpaybillno"), resultSet.getLong("fid"));
                }
                return dataMap;
            }
        });
        if (Objects.isNull(subResult) || subResult.isEmpty()) {
            result.setResult(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u66f4\u65b0\u7684\u6570\u636e\u3002", (String)"FinSubscribeUpdateService_1", (String)"tmc-fbp-business", (Object[])new Object[0]));
            return result;
        }
        logger.info("\u7406\u8d22\u7533\u8d2d\u5355\u9700\u8981\u66f4\u65b0\u6570\u636e\uff1a{}\u884c", (Object)subResult.size());
        QFilter qFilter = new QFilter("billno", "in", subResult.keySet());
        DynamicObjectCollection payBillCols = QueryServiceHelper.query((String)"cas_paybill", (String)"id,billno", (QFilter[])qFilter.toArray());
        Map<String, Long> payResult = payBillCols.stream().collect(Collectors.toMap(r -> r.getString("billno"), r -> r.getLong("id")));
        if (Objects.isNull(payResult) || payResult.isEmpty()) {
            result.setResult(ResManager.loadKDString((String)"\u6709\u5f85\u66f4\u65b0\u7684\u6570\u636e\uff0c\u4f46\u5728\u4ed8\u6b3e\u5355\u4e2d\u672a\u67e5\u5230\u6570\u636e\u3002", (String)"FinSubscribeUpdateService_2", (String)"tmc-fbp-business", (Object[])new Object[0]));
            return result;
        }
        logger.info("\u4ed8\u6b3e\u5355\u67e5\u8be2\u5230 {} \u884c", (Object)payResult.size());
        String updateSql = "update t_cim_finsubscribe set fpaybillid=? where fid=?";
        ArrayList<Object[]> list = new ArrayList<Object[]>(subResult.size());
        for (Map.Entry entry : subResult.entrySet()) {
            Object[] param = new Object[]{payResult.get(entry.getKey()), entry.getValue()};
            list.add(param);
        }
        int[] batchResult = DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)updateSql, list);
        result.setEndDate(new Date());
        long successNum = Arrays.stream(batchResult).filter(r -> r == 1).count();
        int sucNum = Integer.parseInt(successNum + "");
        result.setSuccessCount(sucNum);
        result.setFailCount(batchResult.length - sucNum);
        result.setResult(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"FinSubscribeUpdateService_3", (String)"tmc-fbp-business", (Object[])new Object[0]));
        return result;
    }
}

