/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.init;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.ReceredtypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.init.ITmcSyncData;
import kd.tmc.fbp.common.init.SyncDataResult;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InnerAcctInitbalanceUpgradeService
implements ITmcSyncData {
    public SyncDataResult syncData() {
        SyncDataResult result = new SyncDataResult();
        result.setBeginDate(new Date());
        int idCount = this.updateBalance();
        result.setSuccessCount(idCount);
        return result;
    }

    private int updateBalance() {
        QFilter intQFilter = new QFilter("isinit", "=", (Object)"1");
        DynamicObjectCollection initAccts = QueryServiceHelper.query((String)"ifm_inneraccountinit", (String)"inneraccount.id, currency.id, amount, amountdate", (QFilter[])intQFilter.toArray());
        int count = 0;
        for (DynamicObject acct : initAccts) {
            Long innerId = acct.getLong("inneraccount.id");
            Long ccyId = acct.getLong("currency.id");
            if (EmptyUtil.isEmpty((Long)innerId) || EmptyUtil.isEmpty((Long)ccyId)) continue;
            DynamicObject acctBank = TmcDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,company, bank, scorg", (QFilter[])new QFilter[]{new QFilter("inneracct.id", "=", (Object)acct.getLong("inneraccount.id"))});
            BigDecimal amount = acct.getBigDecimal("amount");
            Date amountDate = acct.getDate("amountdate");
            QFilter qFilter = new QFilter("sourcebilltype", "=", (Object)"bd_accountbanks");
            qFilter.and(new QFilter("sourcebillid", "=", (Object)acctBank.getLong("id")));
            if (TmcDataServiceHelper.exists((String)"ifm_transdetail", (QFilter[])qFilter.toArray())) continue;
            InnerAcctInitbalanceUpgradeService.createInitTransDetail(acctBank, ccyId, amount, amountDate);
            ++count;
        }
        return count;
    }

    public static DynamicObject createInitTransDetail(DynamicObject acct, Long currency, BigDecimal amount, Date bizDate) {
        DynamicObject transDetail = BusinessDataServiceHelper.newDynamicObject((String)"ifm_transdetail");
        transDetail.set("company", acct.getDynamicObject("company").getPkValue());
        transDetail.set("accountbank", acct.getPkValue());
        transDetail.set("currency", (Object)currency);
        transDetail.set("bizdate", (Object)DateUtils.truncateDate((Date)bizDate));
        transDetail.set("biztime", (Object)DateUtils.truncateDate((Date)bizDate));
        transDetail.set("bank", acct.getDynamicObject("bank").getPkValue());
        transDetail.set("creditamount", (Object)amount);
        transDetail.set("debitamount", (Object)BigDecimal.ZERO);
        transDetail.set("scorg", acct.getDynamicObject("scorg").getPkValue());
        transDetail.set("datasource", (Object)"fromifm");
        transDetail.set("sourcebilltype", (Object)"bd_accountbanks");
        transDetail.set("sourcebillid", acct.getPkValue());
        transDetail.set("createtime", (Object)new Date());
        transDetail.set("modifytime", (Object)new Date());
        transDetail.set("lastmodifytime", (Object)new Date());
        transDetail.set("modifier", (Object)RequestContext.get().getCurrUserId());
        transDetail.set("description", (Object)ResManager.loadKDString((String)"\u8d26\u6237\u521d\u59cb\u5316\u4f59\u989d", (String)"InnerAcctInitbalanceUpgradeService_0", (String)"tmc-fbp-business", (Object[])new Object[0]));
        transDetail.set("isdowntobankstate", (Object)"1");
        transDetail.set("receredtype", (Object)ReceredtypeEnum.ACCOUNTED.getValue());
        TmcOperateServiceHelper.execOperate((String)"save", (String)"ifm_transdetail", (DynamicObject[])new DynamicObject[]{transDetail}, (OperateOption)OperateOption.create());
        return transDetail;
    }
}

