/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.init;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.init.ITmcSyncData;
import kd.tmc.fbp.common.init.SyncDataResult;
import kd.tmc.fbp.common.util.EmptyUtil;

public class IntObjectCurrencyUpdate
implements ITmcSyncData {
    public SyncDataResult syncData() {
        SyncDataResult result = new SyncDataResult();
        result.setBeginDate(new Date());
        SqlBuilder sqlBuilder = new SqlBuilder();
        ArrayList<String> params = new ArrayList<String>();
        params.add("Internal");
        sqlBuilder.append("select fid, finneracctid from t_ifm_intobject where fbiztype = ?;", params);
        DataSet queryDataSet = DB.queryDataSet((String)"IntObjectCurrencyUpdate", (DBRoute)new DBRoute("tmc"), (SqlBuilder)sqlBuilder);
        ArrayList<Long> intobjectIds = new ArrayList<Long>(16);
        ArrayList<Long> innerAcctIds = new ArrayList<Long>(16);
        HashMap<Long, Long> dataMap = new HashMap<Long, Long>(16);
        while (queryDataSet.hasNext()) {
            Row row2 = queryDataSet.next();
            intobjectIds.add(row2.getLong("fid"));
            innerAcctIds.add(row2.getLong("finneracctid"));
            dataMap.put(row2.getLong("fid"), row2.getLong("finneracctid"));
        }
        if (EmptyUtil.isEmpty(intobjectIds) || EmptyUtil.isEmpty(innerAcctIds)) {
            result.setEndDate(new Date());
            return result;
        }
        DynamicObject[] innerAccts = TmcDataServiceHelper.load((Object[])innerAcctIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountbanks"));
        DynamicObject[] intobjects = TmcDataServiceHelper.load((Object[])intobjectIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ifm_intobject"));
        Map<Long, DynamicObject> innerAcctMap = Arrays.stream(innerAccts).collect(Collectors.toMap(row -> row.getLong("id"), o -> o));
        for (DynamicObject intobject : intobjects) {
            DynamicObject inneracct;
            Long innerAcctId = (Long)dataMap.get(intobject.getLong("id"));
            if (EmptyUtil.isEmpty((Long)innerAcctId) || EmptyUtil.isEmpty((DynamicObject)(inneracct = innerAcctMap.get(innerAcctId)))) continue;
            DynamicObject currency = inneracct.getDynamicObject("defaultcurrency");
            intobject.set("currency", (Object)currency);
            intobject.set("name", (Object)inneracct.getString("name"));
        }
        Object[] sucess = TmcDataServiceHelper.save((DynamicObject[])intobjects);
        result.setSuccessCount(sucess.length);
        result.setFailCount(intobjects.length - sucess.length);
        return result;
    }
}

