/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.init;

import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.init.ITmcSyncData;
import kd.tmc.fbp.common.init.SyncDataResult;
import org.apache.commons.lang3.tuple.Pair;

public class PayBillNoUpdateService
implements ITmcSyncData {
    private static final Log logger = LogFactory.getLog(PayBillNoUpdateService.class);
    public static final String PAYBILL = "paybill";

    public SyncDataResult syncData() {
        SyncDataResult result = new SyncDataResult();
        result.setBeginDate(new Date());
        Pair<Integer, Integer> repayPair = this.upgradePayBillNo("cfm_repaymentbill", "paybillno");
        Pair<Integer, Integer> interestPair = this.upgradePayBillNo("cfm_interestbill", "payeebillno");
        result.setSuccessCount((Integer)repayPair.getLeft() + (Integer)interestPair.getLeft());
        result.setFailCount((Integer)repayPair.getRight() + (Integer)interestPair.getRight());
        result.setResult("upgrade success");
        result.setEndDate(new Date());
        return result;
    }

    private Pair<Integer, Integer> upgradePayBillNo(String upgradeEntityName, String paybillnoFiledName) {
        QFilter repayFilter = new QFilter(paybillnoFiledName, "!=", (Object)" ").and(new QFilter("datasource", "!=", (Object)"invest"));
        logger.info(upgradeEntityName + "\u7684\u4ed8\u6b3e\u5355\u7f16\u53f7\u5347\u7ea7\u5f00\u59cb============");
        int totalCnt = TmcDataServiceHelper.count((String)upgradeEntityName, (QFilter[])repayFilter.toArray());
        int failCnt = 0;
        StringJoiner joiner = new StringJoiner(",", "[", "]");
        int pageSize = 200;
        int pages = totalCnt / pageSize;
        pages = totalCnt % pageSize == 0 ? pages : pages + 1;
        for (int pageIndex = 0; pageIndex < pages; ++pageIndex) {
            DynamicObject[] repayBills = TmcDataServiceHelper.load((String)upgradeEntityName, (String)(paybillnoFiledName + "," + PAYBILL), (QFilter[])repayFilter.toArray(), (String)"id", (int)pageIndex, (int)pageSize);
            Set paybillnos = Arrays.stream(repayBills).map(repay -> repay.getString(paybillnoFiledName)).collect(Collectors.toSet());
            DynamicObject[] payBills = TmcDataServiceHelper.load((String)"cas_paybill", (String)"billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", paybillnos)});
            Map<String, Object> payBillNoIdMap = Arrays.stream(payBills).collect(Collectors.toMap(pay -> pay.getString("billno"), DataEntityBase::getPkValue));
            for (DynamicObject repaybill : repayBills) {
                Object paybillid = payBillNoIdMap.get(repaybill.getString(paybillnoFiledName));
                if (Objects.isNull(paybillid)) {
                    joiner.add(repaybill.getPkValue().toString());
                    ++failCnt;
                    continue;
                }
                repaybill.set(PAYBILL, paybillid);
            }
            TmcDataServiceHelper.save((DynamicObject[])repayBills);
        }
        if (failCnt > 0) {
            logger.info(upgradeEntityName + joiner + "\u7b49\u5355\u636e\u65e0\u6cd5\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u4ed8\u6b3e\u5355ID");
        }
        logger.info(upgradeEntityName + "\u7684\u4ed8\u6b3e\u5355\u7f16\u53f7\u5347\u7ea7\u7ed3\u675f\u3002" + totalCnt);
        return Pair.of((Object)(totalCnt - failCnt), (Object)failCnt);
    }
}

