/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.init;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.RateTermEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.init.ITmcSyncData;
import kd.tmc.fbp.common.init.SyncDataResult;

public class ReferRateUpdateService
implements ITmcSyncData {
    public SyncDataResult syncData() {
        DynamicObject[] marketRates;
        int fail = 0;
        int souccess = 0;
        SyncDataResult result = new SyncDataResult();
        result.setBeginDate(new Date());
        HashSet<Long> keys = new HashSet<Long>();
        ArrayList<DynamicObject> rateList = new ArrayList<DynamicObject>(20);
        ArrayList<DynamicObject> dataList = new ArrayList<DynamicObject>(20);
        for (DynamicObject marketRate : marketRates = TmcDataServiceHelper.load((String)"fbd_loanmarketrate", (String)"number,lendingmarket,termcategory,rate,currency,publishdate", null)) {
            DynamicObject market = marketRate.getDynamicObject("lendingmarket");
            String referrate = market.getString("number");
            DynamicObject term = marketRate.getDynamicObject("termcategory");
            DynamicObject currency = marketRate.getDynamicObject("currency");
            Long id = (market.getLong("id") + term.getLong("id")) / 2L;
            if (!keys.contains(id)) {
                DynamicObject referRate = TmcDataServiceHelper.newDynamicObject((String)"tbd_referrate");
                referRate.set("id", (Object)id);
                referRate.set("referrate", (Object)referrate);
                referRate.set("enable", (Object)1);
                referRate.set("status", (Object)Character.valueOf('C'));
                referRate.set("currency", (Object)marketRate.getDynamicObject("currency"));
                String t = this.getTerm(term.getString("number"));
                RateTermEnum termE = RateTermEnum.getEnum((String)t.toLowerCase(Locale.ROOT));
                if (termE != null) {
                    referRate.set("term", (Object)termE.getValue());
                } else {
                    referRate.set("term", (Object)t);
                }
                if (referrate.length() > 2) {
                    referRate.set("number", (Object)(currency.getString("number") + referrate.substring(0, 2) + this.getTerm(term.getString("number"))));
                } else {
                    referRate.set("number", (Object)(currency.getString("number") + referrate + this.getTerm(term.getString("number"))));
                }
                rateList.add(referRate);
                keys.add(id);
            }
            DynamicObject dataRate = TmcDataServiceHelper.newDynamicObject((String)"md_datarate");
            dataRate.set("referrate", (Object)id);
            dataRate.set("bizdate", (Object)marketRate.getDate("publishdate"));
            dataRate.set("endprice", (Object)marketRate.getBigDecimal("rate"));
            dataRate.set("datasource", (Object)ResManager.loadKDString((String)"\u624b\u5de5\u65b0\u589e", (String)"CheckedResultSourceEnum_3", (String)"fi-cas-common", (Object[])new Object[0]));
            dataRate.set("modifytime", (Object)new Date());
            dataRate.set("enable", (Object)1);
            dataRate.set("status", (Object)Character.valueOf('C'));
            dataList.add(dataRate);
        }
        List rateIds = rateList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        DeleteServiceHelper.delete((IDataEntityType)TmcDataServiceHelper.newDynamicObject((String)"tbd_referrate").getDataEntityType(), (Object[])rateIds.toArray());
        List dataIds = dataList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        DeleteServiceHelper.delete((IDataEntityType)TmcDataServiceHelper.newDynamicObject((String)"md_datarate").getDataEntityType(), (Object[])dataIds.toArray());
        SaveServiceHelper.save((DynamicObject[])rateList.toArray(new DynamicObject[rateList.size()]));
        SaveServiceHelper.save((DynamicObject[])dataList.toArray(new DynamicObject[dataList.size()]));
        result.setSuccessCount(souccess);
        result.setFailCount(fail);
        result.setEndDate(new Date());
        return result;
    }

    private String getTerm(String term) {
        switch (term) {
            case "0/N": {
                term = "0";
                break;
            }
            case "7D": {
                term = "1W";
                break;
            }
            case "14D": 
            case "15D": {
                term = "2W";
                break;
            }
            case "21D": {
                term = "3W";
            }
        }
        return term;
    }
}

