/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.init;

import java.util.Date;
import java.util.LinkedList;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.init.ITmcSyncData;
import kd.tmc.fbp.common.init.SyncDataResult;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepaymentBillUpdateService
implements ITmcSyncData {
    private static final Log logger = LogFactory.getLog(RepaymentBillUpdateService.class);

    public SyncDataResult syncData() throws KDException {
        SyncDataResult result = new SyncDataResult();
        result.setBeginDate(new Date());
        logger.info("\u8fd8\u6b3e\u5355\u5206\u5f55\u6570\u636e\u5347\u7ea7\u5f00\u59cb============");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"cfm_repaymentbill_loans", (String)"cfm_repaymentbill", (String)"id", (QFilter[])QFilter.isNull((String)"loans").toArray(), (String)"id");
        LinkedList<Long> repayIds = new LinkedList<Long>();
        while (dataSet.hasNext()) {
            repayIds.add(dataSet.next().getLong("id"));
        }
        if (EmptyUtil.isNoEmpty(repayIds)) {
            int totalCnt = repayIds.size();
            logger.info("\u8fd8\u6b3e\u5355\u5206\u5f55\u6570\u91cf============" + totalCnt);
            int pageSize = 200;
            int pages = totalCnt / pageSize + 1;
            for (int pageIndex = 0; pageIndex < pages; ++pageIndex) {
                Object[] detailRepayBills = TmcDataServiceHelper.load((String)"cfm_repaymentbill", (String)"id,createtime,sourcebillid,loancontractbill,drawamount,notrepayamount,amount,ispayinterest,predictinterest,actinterest,loans,loans.e_loanbill,loans.e_drawamount,loans.e_notrepayamount,loans.e_repayamount,loans.e_ispayinst,loans.e_calintamt,loans.e_actintamt", (QFilter[])new QFilter("id", "in", repayIds).toArray(), (String)"id", (int)pageIndex, (int)pageSize);
                if (!EmptyUtil.isNoEmpty((Object[])detailRepayBills)) continue;
                for (Object repayBill : detailRepayBills) {
                    DynamicObjectCollection entrys;
                    long sourcebillId;
                    DynamicObject loanBill;
                    if (EmptyUtil.isEmpty((DynamicObject)repayBill.getDynamicObject("loancontractbill")) && EmptyUtil.isNoEmpty((DynamicObject)(loanBill = TmcDataServiceHelper.loadSingle((String)"cfm_loanbill", (String)"sourcebillid", (QFilter[])new QFilter("id", "=", (Object)(sourcebillId = repayBill.getLong("sourcebillid"))).toArray())))) {
                        repayBill.set("loancontractbill", (Object)loanBill.getLong("sourcebillid"));
                    }
                    if (!EmptyUtil.isEmpty((DynamicObjectCollection)(entrys = repayBill.getDynamicObjectCollection("loans")))) continue;
                    DynamicObject entry = entrys.addNew();
                    entry.set("e_loanbill", repayBill.get("sourcebillid"));
                    entry.set("e_drawamount", repayBill.get("drawamount"));
                    entry.set("e_notrepayamount", repayBill.get("notrepayamount"));
                    entry.set("e_repayamount", repayBill.get("amount"));
                    entry.set("e_ispayinst", repayBill.get("ispayinterest"));
                    entry.set("e_calintamt", repayBill.get("predictinterest"));
                    entry.set("e_actintamt", repayBill.get("actinterest"));
                }
                SaveServiceHelper.save((DynamicObject[])detailRepayBills);
            }
            logger.info("\u8fd8\u6b3e\u5355\u5206\u5f55\u6570\u636e\u5347\u7ea7\u7ed3\u675f" + totalCnt);
            result.setSuccessCount(totalCnt);
            result.setResult("upgrade success");
            result.setEndDate(new Date());
        } else {
            logger.info("no data need upgrade");
            result.setSuccessCount(0);
            result.setResult("no data need upgrade");
            result.setEndDate(new Date());
        }
        return result;
    }
}

