/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.init;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.init.ITmcSyncData;
import kd.tmc.fbp.common.init.SyncDataResult;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SlbankRepayintUpdateService
implements ITmcSyncData {
    public SyncDataResult syncData() {
        SyncDataResult result = new SyncDataResult();
        result.setBeginDate(new Date());
        Set<Long> repayIds = this.repaySlbankUpate();
        this.updateRepaySlbank(repayIds);
        Set<Long> interestIds = this.interestSlbankUpdate();
        this.updateInterestSlbank(interestIds);
        result.setSuccessCount(repayIds.size() + interestIds.size());
        result.setResult(repayIds.stream().map(String::valueOf).collect(Collectors.joining(",")) + interestIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
        result.setEndDate(new Date());
        return result;
    }

    private void updateInterestSlbank(Set<Long> interestIds) {
        if (EmptyUtil.isEmpty(interestIds)) {
            return;
        }
        ArrayList<DynamicObject> interests = new ArrayList<DynamicObject>();
        DynamicObject[] interestBills = TmcDataServiceHelper.load((String)"cfm_interestbill", (String)"billno,instbillctg,currency,convertrate,sourcebillid,repaymentid,loancurrency,actualinstamt,convertintamt,slentryentity.s_bankrole,slentryentity.s_bank,slentryentity.s_repayinst,slentryentity.s_loanamount,slentryentity.s_convertintamt", (QFilter[])new QFilter[]{new QFilter("id", "in", interestIds)});
        HashMap<String, Map<Long, BigDecimal>> interestMap = new HashMap<String, Map<Long, BigDecimal>>();
        HashMap<Long, Map<Long, BigDecimal>> repayInterestMap = new HashMap<Long, Map<Long, BigDecimal>>();
        HashMap<String, Map<Long, BigDecimal>> interestConverMap = new HashMap<String, Map<Long, BigDecimal>>();
        HashSet<Long> interestBatchIds = new HashSet<Long>();
        for (DynamicObject interestBill : interestBills) {
            DynamicObject currency = interestBill.getDynamicObject("currency");
            DynamicObject loanCurrency = interestBill.getDynamicObject("loancurrency");
            DynamicObjectCollection slentryentitys = interestBill.getDynamicObjectCollection("slentryentity");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{currency, loanCurrency}) || EmptyUtil.isEmpty((DynamicObjectCollection)slentryentitys)) continue;
            BigDecimal actualinstAmt = interestBill.getBigDecimal("actualinstamt");
            BigDecimal convertintAmt = interestBill.getBigDecimal("convertintamt");
            BigDecimal slTotalInAmount = slentryentitys.stream().map(o -> o.getBigDecimal("s_repayinst")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            if (BigDecimal.ZERO.compareTo(slTotalInAmount) == 0) {
                BigDecimal rate = interestBill.getBigDecimal("convertrate");
                BigDecimal loanTotalAmount = slentryentitys.stream().map(o -> o.getBigDecimal("s_loanamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                for (DynamicObject slentryentity : slentryentitys) {
                    slentryentity.set("s_repayinst", (Object)slentryentity.getBigDecimal("s_loanamount").multiply(actualinstAmt).divide(loanTotalAmount, currency.getInt("amtprecision"), RoundingMode.HALF_UP));
                    slentryentity.set("s_convertintamt", (Object)slentryentity.getBigDecimal("s_repayinst").multiply(rate).setScale(loanCurrency.getInt("amtprecision"), RoundingMode.HALF_UP));
                }
            }
            boolean isUpdateInt = this.updateEntryAmount(slentryentitys, actualinstAmt, "s_repayinst");
            boolean isUpdateIntConver = this.updateEntryAmount(slentryentitys, convertintAmt, "s_convertintamt");
            if (BigDecimal.ZERO.compareTo(slTotalInAmount) == 0 || isUpdateInt || isUpdateIntConver) {
                interests.add(interestBill);
            }
            HashMap<Long, BigDecimal> amountMap = new HashMap<Long, BigDecimal>();
            HashMap<Long, BigDecimal> amountConertMap = new HashMap<Long, BigDecimal>();
            for (DynamicObject slentryentity : slentryentitys) {
                DynamicObject bank = slentryentity.getDynamicObject("s_bank");
                if (EmptyUtil.isEmpty((DynamicObject)bank)) continue;
                amountMap.put(bank.getLong("id"), slentryentity.getBigDecimal("s_repayinst"));
                amountConertMap.put(bank.getLong("id"), slentryentity.getBigDecimal("s_convertintamt"));
            }
            if ("payprinandinte".equals(interestBill.getString("instbillctg"))) {
                repayInterestMap.put(interestBill.getLong("repaymentid"), amountMap);
                continue;
            }
            String interestId = String.valueOf(interestBill.getLong("id"));
            interestMap.put(interestId + interestBill.getLong("sourcebillid"), amountMap);
            interestConverMap.put(interestId + interestBill.getLong("sourcebillid"), amountConertMap);
            interestBatchIds.add(interestBill.getLong("id"));
        }
        if (interests.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])interests.toArray(new DynamicObject[0]));
        }
        this.updateBatchIntFromInterest(interestBatchIds, interestConverMap, interestMap);
        this.updateRepayFromInterest(repayInterestMap);
    }

    private void updateBatchIntFromInterest(Set<Long> interestBatchId, Map<String, Map<Long, BigDecimal>> interestConverMap, Map<String, Map<Long, BigDecimal>> interestMap) {
        if (interestConverMap.size() == 0) {
            return;
        }
        DynamicObject[] intBatchBills = TmcDataServiceHelper.load((String)"cfm_intbill_batch_loan", (String)"entry.intbillid,entry.loanbillid,slentryentity.s_loanbillno,slentryentity.s_repayinst,slentryentity.s_convertintamt,slentryentity.s_bank", (QFilter[])new QFilter[]{new QFilter("entry.intbillid", "in", interestBatchId)});
        ArrayList<DynamicObject> initBatchs = new ArrayList<DynamicObject>(intBatchBills.length);
        for (DynamicObject intBatchBill : intBatchBills) {
            DynamicObjectCollection entrys = intBatchBill.getDynamicObjectCollection("entry");
            boolean isUpdate = false;
            DynamicObjectCollection slentryentitys = intBatchBill.getDynamicObjectCollection("slentryentity");
            for (DynamicObject slentryentity : slentryentitys) {
                DynamicObject entry;
                DynamicObject bank = slentryentity.getDynamicObject("s_bank");
                DynamicObject loanBill = slentryentity.getDynamicObject("s_loanbillno");
                if (EmptyUtil.isEmpty((DynamicObject)loanBill) || EmptyUtil.isEmpty((DynamicObject)bank) || EmptyUtil.isEmpty((DynamicObject)(entry = (DynamicObject)entrys.stream().filter(o -> loanBill.getLong("id") == o.getLong("loanbillid")).findFirst().orElse(null)))) continue;
                long loanId = slentryentity.getDynamicObject("s_loanbillno").getLong("id");
                Map<Long, BigDecimal> initMap = interestMap.get(entry.getString("intbillid") + loanId);
                Map<Long, BigDecimal> initConverMap = interestConverMap.get(entry.getString("intbillid") + loanId);
                if (EmptyUtil.isEmpty(initMap)) continue;
                BigDecimal initAmt = initMap.get(bank.getLong("id"));
                BigDecimal initConverAmt = initConverMap.get(bank.getLong("id"));
                slentryentity.set("s_repayinst", (Object)initAmt);
                slentryentity.set("s_convertintamt", (Object)initConverAmt);
                isUpdate = true;
            }
            if (!isUpdate) continue;
            initBatchs.add(intBatchBill);
        }
        if (initBatchs.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])initBatchs.toArray(new DynamicObject[0]));
        }
    }

    private void updateRepayFromInterest(Map<Long, Map<Long, BigDecimal>> interestMap) {
        if (interestMap.size() == 0) {
            return;
        }
        DynamicObject[] repaySlentrys = TmcDataServiceHelper.load((String)"cfm_repaymentbill", (String)"id,slentryentity.id,slentryentity.s_bank,slentryentity.s_repayinst", (QFilter[])new QFilter[]{new QFilter("id", "in", interestMap.keySet())});
        ArrayList<DynamicObject> repayBills = new ArrayList<DynamicObject>(repaySlentrys.length);
        for (DynamicObject repaySlentry : repaySlentrys) {
            boolean isUpdate = false;
            Map<Long, BigDecimal> interestEntryMap = interestMap.get(repaySlentry.getLong("id"));
            DynamicObjectCollection slentryentitys = repaySlentry.getDynamicObjectCollection("slentryentity");
            for (DynamicObject slentryentity : slentryentitys) {
                BigDecimal initAmt;
                DynamicObject bank = slentryentity.getDynamicObject("s_bank");
                if (EmptyUtil.isEmpty((DynamicObject)bank) || interestEntryMap == null || (initAmt = interestEntryMap.get(bank.getLong("id"))) == null) continue;
                slentryentity.set("s_repayinst", (Object)initAmt);
                isUpdate = true;
            }
            if (!isUpdate) continue;
            repayBills.add(repaySlentry);
        }
        if (repayBills.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])repayBills.toArray(new DynamicObject[0]));
        }
    }

    private boolean updateEntryAmount(DynamicObjectCollection slentryentitys, BigDecimal totalAmount, String field) {
        BigDecimal slTotalAmount = slentryentitys.stream().map(o -> o.getBigDecimal(field)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        DynamicObject entry = slentryentitys.stream().filter(o -> "MB".equals(o.getString("s_bankrole"))).findFirst().orElse(null);
        if (EmptyUtil.isEmpty((DynamicObject)entry) || totalAmount.compareTo(slTotalAmount) == 0) {
            return false;
        }
        BigDecimal subAmount = totalAmount.subtract(slTotalAmount);
        BigDecimal intAmount = entry.getBigDecimal(field).add(subAmount);
        if (intAmount.compareTo(BigDecimal.ZERO) > 0) {
            entry.set(field, (Object)intAmount);
            return true;
        }
        for (DynamicObject slentryentity : slentryentitys) {
            BigDecimal slAmount = slentryentity.getBigDecimal(field);
            if (slAmount.add(subAmount).compareTo(BigDecimal.ZERO) < 0) {
                entry.set(field, (Object)BigDecimal.ZERO);
                subAmount = subAmount.add(slAmount);
            } else {
                entry.set(field, (Object)slAmount.add(subAmount));
                subAmount = BigDecimal.ZERO;
            }
            if (subAmount.compareTo(BigDecimal.ZERO) != 0) continue;
            break;
        }
        return true;
    }

    private void updateRepaySlbank(Set<Long> repayIds) {
        DynamicObject[] repayBills;
        if (EmptyUtil.isEmpty(repayIds)) {
            return;
        }
        for (DynamicObject repayBill : repayBills = TmcDataServiceHelper.load((String)"cfm_repaymentbill", (String)"billno,currency,loans.e_loanbill,loans.e_repayamount,slentryentity.s_loanbillno,slentryentity.s_loanamount,slentryentity.s_bankrole,slentryentity.s_repayamount,slentryentity.s_bank", (QFilter[])new QFilter[]{new QFilter("id", "in", repayIds)})) {
            DynamicObject currency = repayBill.getDynamicObject("currency");
            DynamicObjectCollection loans = repayBill.getDynamicObjectCollection("loans");
            DynamicObjectCollection slentryentity = repayBill.getDynamicObjectCollection("slentryentity");
            for (DynamicObject loan : loans) {
                if (EmptyUtil.isEmpty((DynamicObject)loan.getDynamicObject("e_loanbill"))) continue;
                int amtPrecision = EmptyUtil.isNoEmpty((DynamicObject)currency) ? currency.getInt("amtprecision") : 4;
                this.updateSlEntry(slentryentity, loan.getDynamicObject("e_loanbill").getLong("id"), loan.getBigDecimal("e_repayamount"), amtPrecision);
            }
        }
        SaveServiceHelper.save((DynamicObject[])repayBills);
    }

    private void updateSlEntry(DynamicObjectCollection slentryentity, long loanId, BigDecimal repayAmount, int amtPrecision) {
        BigDecimal slrepayAmount;
        BigDecimal slloanAmount;
        List slEntrys = slentryentity.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("s_loanbillno")) && loanId == o.getDynamicObject("s_loanbillno").getLong("id")).collect(Collectors.toList());
        BigDecimal slTotalAmount = slEntrys.stream().map(o -> o.getBigDecimal("s_repayamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal slTotalLoanAmount = slEntrys.stream().map(o -> o.getBigDecimal("s_loanamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        if (BigDecimal.ZERO.compareTo(slTotalAmount) == 0) {
            for (DynamicObject slEntry : slEntrys) {
                slEntry.set("s_repayamount", (Object)slEntry.getBigDecimal("s_loanamount").multiply(repayAmount).divide(slTotalLoanAmount, amtPrecision, RoundingMode.HALF_UP));
            }
        }
        slTotalAmount = slEntrys.stream().map(o -> o.getBigDecimal("s_repayamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal subAmount = repayAmount.subtract(slTotalAmount);
        DynamicObject entry = slEntrys.stream().filter(o -> "MB".equals(o.getString("s_bankrole"))).findFirst().orElse(null);
        if (EmptyUtil.isNoEmpty((DynamicObject)entry) && (slloanAmount = entry.getBigDecimal("s_loanamount")).compareTo(slrepayAmount = entry.getBigDecimal("s_repayamount").add(subAmount)) >= 0) {
            entry.set("s_repayamount", (Object)slrepayAmount);
            return;
        }
        for (DynamicObject slEntry : slEntrys) {
            BigDecimal slloanAmount2 = slEntry.getBigDecimal("s_loanamount");
            BigDecimal slrepayAmount2 = slEntry.getBigDecimal("s_repayamount").add(subAmount);
            if (slrepayAmount2.compareTo(slloanAmount2) > 0) {
                BigDecimal tempAmt = slloanAmount2.subtract(slEntry.getBigDecimal("s_repayamount"));
                entry.set("s_repayamount", (Object)slloanAmount2);
                subAmount = subAmount.subtract(tempAmt);
            } else {
                entry.set("s_repayamount", (Object)slrepayAmount2);
                subAmount = BigDecimal.ZERO;
            }
            if (subAmount.compareTo(BigDecimal.ZERO) != 0) continue;
            break;
        }
    }

    private Set<Long> repaySlbankUpate() {
        DataSet repayDs = QueryServiceHelper.queryDataSet((String)"repaySlbankUpate", (String)"cfm_repaymentbill", (String)"id repayid,loans.e_loanbill loanid,loans.e_repayamount repayamount", (QFilter[])new QFilter[]{new QFilter("loantype", "=", (Object)"sl").and("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue()).and("slentryentity.id", ">", (Object)0)}, null);
        DataSet repaySlDs = QueryServiceHelper.queryDataSet((String)"repaySlbankUpate_sl", (String)"cfm_repaymentbill", (String)"id slrepayid,slentryentity.s_loanbillno slloanid,slentryentity.s_repayamount slrepayamount", (QFilter[])new QFilter[]{new QFilter("loantype", "=", (Object)"sl").and("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue())}, null);
        repaySlDs = repaySlDs.groupBy(new String[]{"slrepayid", "slloanid"}).sum("slrepayamount").finish();
        DataSet diffSlbankDs = repayDs.leftJoin(repaySlDs).on("repayid", "slrepayid").on("loanid", "slloanid").select(new String[]{"repayid", "loanid", "repayamount", "slrepayamount"}).finish().updateField("slrepayamount", "case when slrepayamount=null then 0 else slrepayamount end").filter("repayamount!=slrepayamount");
        HashSet<Long> repayIds = new HashSet<Long>();
        if (diffSlbankDs.isEmpty()) {
            return repayIds;
        }
        for (Row diffSlbank : diffSlbankDs) {
            repayIds.add(diffSlbank.getLong("repayid"));
        }
        return repayIds;
    }

    private Set<Long> interestSlbankUpdate() {
        DataSet interestDs = QueryServiceHelper.queryDataSet((String)"interestSlbankUpdate", (String)"cfm_interestbill", (String)"id,actualinstamt intamount,convertintamt conintamount", (QFilter[])new QFilter[]{new QFilter("loantype", "=", (Object)"sl").and("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue())}, null);
        DataSet interestSlDs = QueryServiceHelper.queryDataSet((String)"interestSlbankUpdate_sl", (String)"cfm_interestbill", (String)"id slid,slentryentity.s_repayinst slintamount,slentryentity.s_convertintamt slconintamount", (QFilter[])new QFilter[]{new QFilter("loantype", "=", (Object)"sl").and("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue())}, null);
        interestSlDs = interestSlDs.updateField("slintamount", "case when slintamount=null then 0 else slintamount end").updateField("slconintamount", "case when slconintamount=null then 0 else slconintamount end").groupBy(new String[]{"slid"}).sum("slintamount").sum("slconintamount").finish();
        DataSet diffInterestDs = interestDs.leftJoin(interestSlDs).on("id", "slid").select(new String[]{"id", "intamount", "conintamount", "slintamount", "slconintamount"}).finish().filter("intamount!=slintamount or conintamount!=slconintamount");
        HashSet<Long> interestIds = new HashSet<Long>();
        if (diffInterestDs.isEmpty()) {
            return interestIds;
        }
        for (Row diffInterest : diffInterestDs) {
            interestIds.add(diffInterest.getLong("id"));
        }
        return interestIds;
    }
}

