/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.init;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.DispatchGetParamHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.init.ITmcSyncData;
import kd.tmc.fbp.common.init.SyncDataResult;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TransDetailLogGenUpdateService
implements ITmcSyncData {
    private static final Log logger = LogFactory.getLog(TransDetailLogGenUpdateService.class);
    private static final String BIZ_DATE_PROP = "bizdate";
    private static final int DEFAULT_THRESHOD = 1000000;
    private static final String ALGO_KEY = "TransDetailLogGenUpdateService";

    public SyncDataResult syncData() {
        SyncDataResult result = new SyncDataResult();
        result.setBeginDate(new Date());
        logger.info("\u4ea4\u6613\u660e\u7ec6\u65e5\u5fd7\u521d\u59cb\u5316\u6267\u884cstart...");
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        int transDetailThreshold = this.getThreshold(rootOrgId);
        logger.info("\u4ea4\u6613\u660e\u7ec6\u65e5\u5fd7\u521d\u59cb\u5316\u83b7\u53d6\u5230\u7684\u9608\u503c\uff1a" + transDetailThreshold);
        QFilter qFilter = new QFilter(BIZ_DATE_PROP, "is not null", null);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bei_transdetail", (String)"min(bizdate) startDate, max(bizdate) endDate", (QFilter[])new QFilter[]{qFilter}, null, (int)1);
        if (query == null || query.get(0) == null || ((DynamicObject)query.get(0)).getDate("startDate") == null || ((DynamicObject)query.get(0)).getDate("endDate") == null) {
            result.setEndDate(new Date());
            result.setResult("no data,no execute");
            return result;
        }
        Date startDate = ((DynamicObject)query.get(0)).getDate("startDate");
        Date endDate = ((DynamicObject)query.get(0)).getDate("endDate");
        logger.info("\u4ea4\u6613\u660e\u7ec6\u65e5\u5fd7\u521d\u59cb\u5316\u6700\u65e9\u65f6\u95f4\uff1a" + startDate + " \u6700\u665a\u65f6\u95f4\uff1a" + endDate);
        while (startDate.compareTo(endDate) < 0) {
            Date fiveYearEndDate = DateUtils.getNextYear((Date)startDate, (int)5);
            QFilter dateFilter = this.dateFilter(startDate, fiveYearEndDate);
            dateFilter.and(this.otherFilters());
            int count = TmcDataServiceHelper.count((String)"bei_transdetail", (QFilter[])new QFilter[]{dateFilter});
            logger.info("\u4ea4\u6613\u660e\u7ec6\u65e5\u5fd7\u521d\u59cb\u5316\u5f00\u59cb\u65f6\u95f4\uff1a" + startDate + " \u7ed3\u675f\u65f6\u95f4\uff1a" + fiveYearEndDate + " count: " + count);
            if (count > transDetailThreshold) {
                this.saveLogsByMonth(startDate, fiveYearEndDate);
            } else {
                this.saveLogsByGroupMonth(startDate, fiveYearEndDate);
            }
            startDate = fiveYearEndDate;
        }
        logger.info("\u4ea4\u6613\u660e\u7ec6\u65e5\u5fd7\u521d\u59cb\u5316\u6267\u884cend...");
        result.setEndDate(new Date());
        result.setResult("execute success");
        return result;
    }

    private int getThreshold(long rootOrgId) {
        int threshold = (Integer)DispatchGetParamHelper.getParamValue((String)"transdetailthreshold", Integer.class);
        if (EmptyUtil.isEmpty((Integer)threshold)) {
            threshold = 1000000;
        }
        return threshold;
    }

    private void saveLogsByGroupMonth(Date startDate, Date endDate) {
        QFilter dateFilter = this.dateFilter(startDate, endDate);
        dateFilter.and(this.otherFilters());
        DataSet ds = QueryServiceHelper.queryDataSet((String)"TransDetailLogGenUpdateServicesaveLogsByGroupMonth", (String)"bei_transdetail", (String)"company.id,bizdate", (QFilter[])new QFilter[]{dateFilter}, null);
        DataSet groupDS = ds.groupBy(new String[]{"company.id", BIZ_DATE_PROP}).finish();
        this.doSaveLogs(groupDS);
        ds.close();
    }

    private void saveLogsByMonth(Date startDate, Date endDate) {
        while (startDate.compareTo(endDate) < 0) {
            Date oneMonthEndDate = DateUtils.getNextMonth((Date)startDate, (int)1);
            QFilter dateFilter = this.dateFilter(startDate, oneMonthEndDate);
            dateFilter.and(this.otherFilters());
            DataSet ds = QueryServiceHelper.queryDataSet((String)"TransDetailLogGenUpdateServicesaveLogsByMonth", (String)"bei_transdetail", (String)"company.id,bizdate", (QFilter[])new QFilter[]{dateFilter}, null);
            DataSet groupDS = ds.groupBy(new String[]{"company.id", BIZ_DATE_PROP}).finish();
            this.doSaveLogs(groupDS);
            startDate = oneMonthEndDate;
            ds.close();
        }
    }

    private void doSaveLogs(DataSet ds) {
        ArrayList<DynamicObject> logList = new ArrayList<DynamicObject>(16);
        for (Row row : ds) {
            Long orgId = row.getLong("company.id");
            Date bizDate = row.getDate(BIZ_DATE_PROP);
            DynamicObject transDetailLog = TmcDataServiceHelper.newDynamicObject((String)"tda_transdetaillog");
            transDetailLog.set("org", (Object)orgId);
            transDetailLog.set(BIZ_DATE_PROP, (Object)bizDate);
            transDetailLog.set("isfinish", (Object)false);
            transDetailLog.set("billno", (Object)(orgId + "-" + DateUtils.formatString((Date)DateUtils.getFirstDayOfMonth((Date)bizDate), (String)"yyyyMM")));
            transDetailLog.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            transDetailLog.set("creator", (Object)RequestContext.get().getCurrUserId());
            transDetailLog.set("createtime", (Object)DateUtils.getCurrentTime());
            logList.add(transDetailLog);
        }
        TmcDataServiceHelper.save((DynamicObject[])logList.toArray(new DynamicObject[0]));
        ds.close();
    }

    private QFilter otherFilters() {
        return new QFilter("company.id", "!=", (Object)0);
    }

    private QFilter dateFilter(Date startDate, Date endDate) {
        QFilter dateFilter = new QFilter(BIZ_DATE_PROP, ">=", (Object)startDate);
        dateFilter.and(BIZ_DATE_PROP, "<", (Object)endDate);
        return dateFilter;
    }
}

