/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.quota;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.sdk.tmc.tmbrm.extpoint.IEvaluationRefData;
import kd.sdk.tmc.tmbrm.extpoint.bean.RefDataItem;
import kd.sdk.tmc.tmbrm.extpoint.bean.RefDataRequest;
import kd.tmc.fbp.business.opservice.quota.DepositParam;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.EvalRefDataHelper;
import kd.tmc.fbp.common.helper.InvestCommonHelper;
import kd.tmc.fbp.common.model.tda.invest.InvestRequest;
import kd.tmc.fbp.common.util.DateUtils;

public class TotalDepositRefData
implements IEvaluationRefData {
    private static final String[] AMOUNT_FIELD = new String[]{"amount"};
    private static final List<String> INVESTTYPELIST = Arrays.asList(InvestTypeEnum.notice.getValue(), InvestTypeEnum.fixed.getValue(), InvestTypeEnum.structure.getValue(), InvestTypeEnum.huge.getValue());

    public List<RefDataItem> getDataItemValue(RefDataRequest request) {
        Map extMap = request.getExtMap();
        List allOrgIds = (List)extMap.get("allOrgIds");
        Map finOrgIdMap = (Map)extMap.get("finOrgIdMap");
        List finOrgIds = request.getFinOrgIds();
        String refIndexNo = request.getKey();
        Date currentDate = DateUtils.getCurrentDate();
        ArrayList<RefDataItem> refDataItems = new ArrayList<RefDataItem>(finOrgIds.size());
        for (Long finOrgId : finOrgIds) {
            Set allFinOrgIds = finOrgIdMap.computeIfAbsent(finOrgId, t -> new HashSet(16));
            DepositParam depositParam = new DepositParam(request.getFromDate(), request.getToDate(), allOrgIds, new ArrayList<Object>(allFinOrgIds));
            InvestRequest investRequest = new InvestRequest(TotalDepositRefData.class.getName(), currentDate, Long.valueOf(0L), Long.valueOf(8L), this.getDateList(depositParam), this.getFinSubscribeFilter(depositParam), this.getDepositFilter(depositParam));
            DataSet investDs = InvestCommonHelper.getAllViewData((InvestRequest)investRequest).select("avgprinciple amount, currency");
            DataSet resultDs = investDs.groupBy(new String[]{"currency"}).sum("amount").finish();
            resultDs = AmountTransHelper.tranDataSetRate((DataSet)resultDs, (Long)8L, (Long)1L, (String)"currency", Collections.singleton("amount"), (Date)DateUtils.getCurrentDate());
            resultDs = resultDs.updateFields(AMOUNT_FIELD, EvalRefDataHelper.calcFieldExpress((String[])AMOUNT_FIELD));
            refDataItems.add(new RefDataItem(finOrgId, refIndexNo, EvalRefDataHelper.getTotalAmount((DataSet)resultDs)));
        }
        return refDataItems;
    }

    private List<Object[]> getDateList(DepositParam param) {
        ArrayList<Object[]> resList = new ArrayList<Object[]>(10);
        resList.add(new Object[]{param.getFromDate(), param.getToDate(), "Y"});
        return resList;
    }

    private QFilter getFinSubscribeFilter(DepositParam param) {
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        filter.and("finservicestatus", "!=", (Object)"subscribe_ing");
        this.appendTradechannelFilter(filter);
        filter.and(this.getDateFilter(param.getFromDate(), param.getToDate(), "valuedate"));
        filter.and("org.id", "in", param.getAllSubOrgIds());
        filter.and("finorginfo.id", "in", param.getAllFinOrgIds());
        return filter;
    }

    private QFilter getDepositFilter(DepositParam param) {
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        filter.and("investvarieties.investtype", "in", INVESTTYPELIST);
        filter.and("bizstatus", "!=", (Object)"subscribe_ing");
        this.appendTradechannelFilter(filter);
        filter.and(this.getDateFilter(param.getFromDate(), param.getToDate(), "intdate"));
        filter.and("org", "in", param.getAllSubOrgIds());
        filter.and("finorginfo.id", "in", param.getAllFinOrgIds());
        return filter;
    }

    private void appendTradechannelFilter(QFilter qFilter) {
        QFilter channelFilter = QFilter.of((String)"((tradechannel = ? AND bebankstatus = ?) OR tradechannel = ?)", (Object[])new Object[]{"online", BeBillStatusEnum.TS.getValue(), "offline"});
        qFilter.and(channelFilter);
    }

    private QFilter getDateFilter(Date queryStartDate, Date queryEndDate, String intdateName) {
        QFilter dateFilter = new QFilter(intdateName, "<=", (Object)queryEndDate);
        QFilter clearDateFilter = QFilter.isNull((String)"cleardate").or(new QFilter("cleardate", ">", (Object)queryStartDate));
        return dateFilter.and(clearDateFilter);
    }
}

