/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.opservice.quota;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.tmc.tmbrm.extpoint.IEvaluationRefData;
import kd.sdk.tmc.tmbrm.extpoint.bean.RefDataItem;
import kd.sdk.tmc.tmbrm.extpoint.bean.RefDataRequest;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.EvalRefDataHelper;
import kd.tmc.fbp.common.util.DateUtils;

public class TotalLoanAmountRefData
implements IEvaluationRefData {
    private static final String[] AMOUNT_FIELD = new String[]{"amount"};

    public List<RefDataItem> getDataItemValue(RefDataRequest request) {
        List finOrgIds = request.getFinOrgIds();
        String refIndexNo = request.getKey();
        Long orgViewId = 8L;
        Long rmbCurrencyId = 1L;
        Map extMap = request.getExtMap();
        List allOrgIds = (List)extMap.get("allOrgIds");
        Map finOrgIdMap = (Map)extMap.get("finOrgIdMap");
        ArrayList<RefDataItem> refDataItems = new ArrayList<RefDataItem>(finOrgIds.size());
        QFilter dateFilter = EvalRefDataHelper.getDateFilter((String)"startintdate", (Date)request.getFromDate(), (Date)request.getToDate());
        for (Long finOrgId : finOrgIds) {
            Set allFinOrgIds = (Set)finOrgIdMap.get(finOrgId);
            ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
            filters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            filters.add(new QFilter("loantype", "=", (Object)"loan"));
            filters.add(new QFilter("org.id", "in", (Object)allOrgIds));
            filters.add(new QFilter("creditor", "in", (Object)allFinOrgIds));
            filters.add(dateFilter);
            DataSet loanDs = QueryServiceHelper.queryDataSet((String)TotalLoanAmountRefData.class.getName(), (String)"cfm_loanbill", (String)"currency,drawamount as amount", (QFilter[])filters.toArray(new QFilter[0]), null);
            loanDs = loanDs.groupBy(new String[]{"currency"}).sum("amount").finish();
            DataSet loanRateDs = AmountTransHelper.tranDataSetRate((DataSet)loanDs, (Long)orgViewId, (Long)rmbCurrencyId, (String)"currency", Collections.singleton("amount"), (Date)DateUtils.getCurrentDate());
            loanRateDs = loanRateDs.updateFields(AMOUNT_FIELD, EvalRefDataHelper.calcFieldExpress((String[])AMOUNT_FIELD));
            BigDecimal totalAmount = BigDecimal.ZERO;
            for (Row row : loanRateDs) {
                totalAmount = totalAmount.add(row.getBigDecimal("amount"));
            }
            filters.clear();
            filters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            filters.add(new QFilter("loantype", "=", (Object)"sl"));
            filters.add(new QFilter("org.id", "in", (Object)allOrgIds));
            filters.add(new QFilter("banksyndicate_entry.e_bank.id", "in", (Object)allFinOrgIds));
            filters.add(dateFilter);
            DataSet slDs = QueryServiceHelper.queryDataSet((String)TotalLoanAmountRefData.class.getName(), (String)"cfm_loanbill", (String)"currency,banksyndicate_entry.e_shareamount as amount", (QFilter[])filters.toArray(new QFilter[0]), null);
            slDs = slDs.groupBy(new String[]{"currency"}).sum("amount").finish();
            DataSet slRateDs = AmountTransHelper.tranDataSetRate((DataSet)slDs, (Long)orgViewId, (Long)rmbCurrencyId, (String)"currency", Collections.singleton("amount"), (Date)DateUtils.getCurrentDate());
            slRateDs = slRateDs.updateFields(AMOUNT_FIELD, EvalRefDataHelper.calcFieldExpress((String[])AMOUNT_FIELD));
            for (Row row : slRateDs) {
                totalAmount = totalAmount.add(row.getBigDecimal("amount"));
            }
            refDataItems.add(new RefDataItem(finOrgId, refIndexNo, String.format("%.2f", totalAmount)));
        }
        return refDataItems;
    }
}

