/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.validate.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class Push2PayBillValidator
extends AbstractTmcBizOppValidator {
    private static final Set<String> EXCLUDE_ENTITYS = new HashSet<String>(Collections.singleton("tm_businessbill"));

    @Override
    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        String entityName = dataEntitys[0].getDataEntity().getDynamicObjectType().getName();
        if (EXCLUDE_ENTITYS.contains(entityName)) {
            return;
        }
        Set<String> includeTargetEntitys = Collections.singleton("cas_paybill");
        List billIds = Arrays.stream(dataEntitys).map(d -> d.getDataEntity().getLong("id")).collect(Collectors.toList());
        Map<String, QFilter> filterMap = Collections.singletonMap("cas_paybill", new QFilter("billstatus", "not in", Arrays.asList("G", "F")));
        Map targetBillMsgMap = TmcBotpHelper.getDirtTargetBillMsgMap((String)entityName, billIds, null, includeTargetEntitys, filterMap);
        if (EmptyUtil.isEmpty((Object)targetBillMsgMap)) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            long billId = dataEntity.getDataEntity().getLong("id");
            String msg = (String)targetBillMsgMap.get(billId);
            if (!EmptyUtil.isNoEmpty((String)msg)) continue;
            this.addErrorMessage(dataEntity, msg);
        }
    }
}

