/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.validate.feedetail;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.property.FeeDetailBillProp;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FeeDetailAuditValidator
extends AbstractTmcBizOppValidator {
    @Override
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Set bizBillIds = Arrays.stream(dataEntity).map(s -> s.getDataEntity().getLong("id")).collect(Collectors.toSet());
        QFilter feeFilter = new QFilter("entry.srcbillid", "in", bizBillIds).and("entry.srcstatus", "in", (Object)FeeDetailBillProp.ENTRY_SRCSTATUS_VALUE);
        DynamicObjectCollection feeBills = QueryServiceHelper.query((String)"cfm_feebill", (String)"id,billno,enpayamt,entry.srcstatus srcstatus,entry.srcbillid srcbillid,entry.feedetailamt feedetailamt", (QFilter[])new QFilter[]{feeFilter});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)feeBills)) {
            Map bizBillGroup = feeBills.stream().collect(Collectors.groupingBy(s -> s.getLong("srcbillid"), Collectors.mapping(o -> o.getLong("id"), Collectors.toSet())));
            Map<Long, BigDecimal> feeDetailSumAmts = feeBills.stream().collect(Collectors.groupingBy(s -> s.getLong("id"), Collectors.mapping(o -> o.getBigDecimal("feedetailamt"), Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            Map feeBillGroup = feeBills.stream().collect(Collectors.groupingBy(s -> s.getLong("id"), Collectors.mapping(o -> o, Collectors.toList())));
            Set<Long> foundFeeBizBillIds = bizBillGroup.keySet();
            HashSet<Long> errorFeeBill = new HashSet<Long>(16);
            for (Map.Entry feeBill : feeBillGroup.entrySet()) {
                Long feeBillId = feeBill.getKey();
                BigDecimal enpayAmt = ((DynamicObject)feeBill.getValue().get(0)).getBigDecimal("enpayamt");
                BigDecimal feeDetailSumAmt = feeDetailSumAmts.get(feeBill.getKey());
                if (feeDetailSumAmt.abs().compareTo(enpayAmt.abs()) <= 0) continue;
                errorFeeBill.add(feeBillId);
            }
            if (EmptyUtil.isNoEmpty(errorFeeBill)) {
                for (ExtendedDataEntity extendedDataEntity : dataEntity) {
                    DynamicObject info = extendedDataEntity.getDataEntity();
                    long bizBillId = info.getLong("id");
                    if (!foundFeeBizBillIds.contains(bizBillId)) continue;
                    Set feeBillIds = bizBillGroup.get(bizBillId);
                    HashSet tempSet = new HashSet(errorFeeBill);
                    tempSet.retainAll(feeBillIds);
                    for (Long feeId : tempSet) {
                        String feeBillno = ((DynamicObject)feeBillGroup.get(feeId).get(0)).getString("billno");
                        this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5f55\u5165\u7684\u8d39\u7528\u91d1\u989d\u8d85\u8fc7\u5173\u8054\u7684\u8d39\u7528\u660e\u7ec6[%s]\u7684\u5269\u4f59\u8d39\u7528\u91d1\u989d\u3002", (String)"FeeDetailAuditValidator_0", (String)"tmc-fbp-business", (Object[])new Object[0]), feeBillno));
                    }
                }
            }
        }
    }
}

