/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.business.validate.feedetail;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.OppUnitTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FeeDetailSaveOrSubmitOpValidator
extends AbstractTmcBizOppValidator {
    @Override
    public List<String> getSelector() {
        List<String> sic = super.getSelector();
        sic.add("billno");
        sic.add("feedetail");
        sic.add("feedetail.feeoppunittype");
        sic.add("feedetail.feeoppunittext");
        sic.add("feedetail.feetype");
        sic.add("feedetail.feepaydate");
        sic.add("feedetail.feeamt");
        return sic;
    }

    @Override
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Map variables = this.getOption().getVariables();
        String formId = (String)variables.get("FeeDetailEditPageSaveOp");
        if (EmptyUtil.isNoEmpty((String)formId)) {
            DynamicObject info = dataEntity[0].getDataEntity();
            MainEntityType tagEntityType = MetadataServiceHelper.getDataEntityType((String)info.getDataEntityType().getName());
            DynamicObject mainOrg = info.getDynamicObject(tagEntityType.getMainOrg());
            DynamicObjectCollection feeDetailEntrys = info.getDynamicObjectCollection("feedetail");
            for (int i = 0; i < feeDetailEntrys.size(); ++i) {
                BigDecimal excrate;
                String oppType;
                BigDecimal feeAmt;
                Date feePayDate;
                DynamicObject feeEntry = (DynamicObject)feeDetailEntrys.get(i);
                String feeType = feeEntry.getString("feetype");
                if (EmptyUtil.isEmpty((String)feeType)) {
                    this.addMessage(dataEntity[0], String.format(ResManager.loadKDString((String)"\u8d39\u7528\u660e\u7ec6\u7684\u7b2c\u3010%s\u3011\u884c\u8d39\u7528\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FeeDetailSaveOrSubmitOpValidator_1", (String)"tmc-fbp-business", (Object[])new Object[0]), i + 1));
                }
                if (EmptyUtil.isEmpty((Object)(feePayDate = feeEntry.getDate("feepaydate")))) {
                    this.addMessage(dataEntity[0], String.format(ResManager.loadKDString((String)"\u8d39\u7528\u660e\u7ec6\u7684\u7b2c\u3010%s\u3011\u884c\u8d39\u7528\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FeeDetailSaveOrSubmitOpValidator_2", (String)"tmc-fbp-business", (Object[])new Object[0]), i + 1));
                }
                if (EmptyUtil.isEmpty((BigDecimal)(feeAmt = feeEntry.getBigDecimal("feeamt")))) {
                    this.addMessage(dataEntity[0], String.format(ResManager.loadKDString((String)"\u8d39\u7528\u660e\u7ec6\u7684\u7b2c\u3010%s\u3011\u884c\u8d39\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FeeDetailSaveOrSubmitOpValidator_3", (String)"tmc-fbp-business", (Object[])new Object[0]), i + 1));
                }
                if (EmptyUtil.isEmpty((String)(oppType = feeEntry.getString("feeoppunittype")))) {
                    this.addMessage(dataEntity[0], String.format(ResManager.loadKDString((String)"\u8d39\u7528\u660e\u7ec6\u7684\u7b2c\u3010%s\u3011\u884c\u5bf9\u65b9\u5355\u4f4d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FeeDetailSaveOrSubmitOpValidator_4", (String)"tmc-fbp-business", (Object[])new Object[0]), i + 1));
                }
                String oppName = feeEntry.getString("feeoppunittext");
                if (EmptyUtil.isNoEmpty((String)oppType) && EmptyUtil.isNoEmpty((String)oppName) && !OppUnitTypeEnum.OTHER.getValue().equals(oppType)) {
                    QFilter existFilter = new QFilter("name", "=", (Object)oppName);
                    if (OppUnitTypeEnum.SUPPLIER.getValue().equals(oppType) || OppUnitTypeEnum.CUSTOMER.getValue().equals(oppType)) {
                        existFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)oppType, (Long)mainOrg.getLong("id")));
                    }
                    if (!TmcDataServiceHelper.exists((String)oppType, (QFilter[])existFilter.toArray())) {
                        this.addMessage(dataEntity[0], String.format(ResManager.loadKDString((String)"\u8d39\u7528\u660e\u7ec6\u7684\u7b2c\u3010%s\u3011\u884c\u5bf9\u65b9\u5355\u4f4d\u7c7b\u578b\u548c\u5bf9\u65b9\u5355\u4f4d\u503c\u4e0d\u5339\u914d,\u8bf7\u91cd\u65b0\u70b9\u51fb\u5bf9\u65b9\u5355\u4f4d\u9009\u62e9\u3002", (String)"FeeDetailSaveOrSubmitOpValidator_5", (String)"tmc-fbp-business", (Object[])new Object[0]), i + 1));
                    }
                }
                if (!feeEntry.containsProperty("excrate") || !EmptyUtil.isEmpty((BigDecimal)(excrate = feeEntry.getBigDecimal("excrate")))) continue;
                this.addErrorMessage(dataEntity[0], String.format(ResManager.loadKDString((String)"\u8d39\u7528\u660e\u7ec6\u7684\u7b2c\u3010%s\u3011\u884c\u6298\u503a\u52a1\u5e01\u79cd\u6c47\u7387\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FeeDetailSaveOrSubmitOpValidator_6", (String)"tmc-fbp-business", (Object[])new Object[0]), i + 1));
            }
        }
    }
}

