/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.bd;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcDataBaseList;

public class TmcBaseDataList
extends AbstractTmcDataBaseList {
    private static final Log logger = LogFactory.getLog(TmcBaseDataList.class);

    @Override
    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        if (this.initAuthorizedBankOrgProperty().contains(fieldName)) {
            Long userPK = Long.valueOf(RequestContext.get().getUserId());
            String appId = this.getView().getFormShowParameter().getAppId();
            String entityId = this.getDataEntityName();
            if ("bd_accountbanks".equals(entityId) && !"cas".equals(appId) && !"am".equals(appId)) {
                appId = null;
            }
            if (EmptyUtil.isNoEmpty((String)appId)) {
                List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userPK, (String)appId, (String)entityId, (String)this.getPermissionItem());
                args.getQFilters().add(new QFilter("id", "in", (Object)orgIdList));
            }
        }
    }

    private Set<String> initAuthorizedBankOrgProperty() {
        HashSet<String> bankOrgSet = new HashSet<String>();
        bankOrgSet.add("company.name");
        return bankOrgSet;
    }

    public void setFilter(SetFilterEvent e) {
        if (EmptyUtil.isNoEmpty((String)this.getPrimaryOrgId())) {
            QFilter filter2;
            List filters = e.getQFilters();
            this.initSelectCurrentOrg(filters);
            for (QFilter filter2 : filters) {
                if (!filter2.getProperty().equals(this.getPrimaryOrgId())) continue;
                return;
            }
            String mainOrg = EntityMetadataCache.getDataEntityType((String)this.getDataEntityName()).getMainOrg();
            if (EmptyUtil.isEmpty((String)mainOrg) && (filter2 = this.initFilterForAuthorizedOrg()) != null) {
                e.setMainOrgQFilter(filter2);
            }
        }
        super.setFilter(e);
    }

    private void initSelectCurrentOrg(List<QFilter> filters) {
        List<Long> selOrgs = new ArrayList<Long>();
        if (filters != null && filters.size() > 0) {
            for (QFilter filter : filters) {
                if (!filter.getProperty().equals(this.getPrimaryOrgId())) continue;
                if (filter.getValue() instanceof Long) {
                    selOrgs.add((Long)filter.getValue());
                    break;
                }
                if (!(filter.getValue() instanceof List)) break;
                selOrgs = (List)filter.getValue();
                break;
            }
        }
        this.getPageCache().put("selectedFilterOrgs", JSON.toJSONString(selOrgs));
    }

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        e.getParameter().getCustomParams().put("selectedFilterOrgs", this.getPageCache().get("selectedFilterOrgs"));
        super.beforeShowBill(e);
    }

    private QFilter initFilterForAuthorizedOrg() {
        Long userPK = Long.valueOf(RequestContext.get().getUserId());
        String appId = this.getView().getFormShowParameter().getAppId();
        String entityId = this.getDataEntityName();
        if ("bd_accountbanks".equals(entityId) && !"cas".equals(appId) && !"am".equals(appId)) {
            appId = null;
        }
        if (EmptyUtil.isNoEmpty((String)appId)) {
            List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userPK, (String)appId, (String)entityId, (String)this.getPermissionItem());
            return new QFilter(this.getPrimaryOrgId(), "in", (Object)orgIdList);
        }
        return null;
    }

    private String getPrimaryOrgId() {
        return "company.id";
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bar_operlog": {
                List<Long> idList = this.getSelectedIdList();
                this.showOnLineQueryFrm(idList);
            }
        }
    }

    private void showOnLineQueryFrm(List<Long> idList) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("tmc_operationlog");
        parameter.getCustomParams().put("biz_obj", idList);
        this.getView().showForm(parameter);
    }
}

