/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.bill;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOpLogShowHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class TmcBaseBillEdit
extends AbstractTmcBillEdit {
    private static final Log logger = LogFactory.getLog(TmcBaseBillEdit.class);

    @Override
    protected void initControlEvi() {
        BasedataEdit openorg;
        BasedataEdit company;
        if (this.getModel().getProperty("company") != null && (company = (BasedataEdit)this.getControl("company")) != null) {
            company.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                Long userPK = Long.valueOf(RequestContext.get().getUserId());
                String appId = this.getView().getFormShowParameter().getAppId();
                List orgIdSet = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userPK, (String)appId, (String)this.getDataEntityName(), (String)this.getPermissionItem());
                showParameter.setCustomParam("range", (Object)orgIdSet);
            });
        }
        if (this.getModel().getProperty("openorg") != null && this.getView().getControl("openorg") != null && (openorg = (BasedataEdit)this.getControl("openorg")) != null) {
            openorg.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                Long userPK = Long.valueOf(RequestContext.get().getUserId());
                String appId = this.getView().getFormShowParameter().getAppId();
                List orgIdSet = TmcOrgDataHelper.getAuthorizedAccountLegalOrgId((Long)userPK, (String)appId, (String)this.getDataEntityName(), (String)this.getPermissionItem());
                showParameter.setCustomParam("range", (Object)orgIdSet);
            });
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "barlog": {
                Object number = this.getModel().getValue("number");
                FormShowParameter showPara = TmcOpLogShowHelper.create((String)this.getModel().getDataEntityType().getAppId(), (String)this.getModel().getDataEntityType().getName(), (Object)number);
                this.getView().showForm(showPara);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        try {
            IDataModel model = this.getModel();
            if (this.getView().getControl("company") != null) {
                DynamicObject currentOrg;
                List orgs;
                String orgIds;
                if (this.getView().getFormShowParameter().getCustomParams().containsKey("selectedFilterOrgs") && EmptyUtil.isNoEmpty((String)(orgIds = (String)this.getView().getFormShowParameter().getCustomParams().get("selectedFilterOrgs"))) && (orgs = (List)JSON.parseObject((String)orgIds, List.class)) != null && orgs.size() == 1) {
                    this.getModel().setValue("company", orgs.get(0));
                }
                if (EmptyUtil.isEmpty((DynamicObject)(currentOrg = (DynamicObject)this.getModel().getValue("company")))) {
                    String appId = this.getView().getFormShowParameter().getAppId();
                    currentOrg = TmcOrgDataHelper.getCurrentPermOrg((String)appId, (String)this.getDataEntityName(), (String)this.getPermissionItem());
                    this.getModel().setValue("company", currentOrg.getPkValue());
                }
                if (!EmptyUtil.isEmpty((DynamicObject)currentOrg) && model.getProperty("openorg") != null && this.getView().getControl("openorg") != null) {
                    DynamicObject accountOrg = TmcOrgDataHelper.getAccountOrgByFundsOrg((DynamicObject)currentOrg);
                    if (!EmptyUtil.isEmpty((DynamicObject)accountOrg)) {
                        this.getModel().setValue("openorg", accountOrg.getPkValue());
                    } else {
                        this.getModel().setValue("openorg", null);
                    }
                }
            }
            model.setValue("org", this.getModel().getValue("company"));
            if (model.getProperty("bizdate") != null) {
                model.setValue("bizdate", (Object)new Date());
            }
            if (model.getProperty("basecurrency") != null && model.getProperty("currency") != null && model.getProperty("company") != null) {
                DynamicObject currency = TmcBusinessBaseHelper.getBaseCurrency((long)((DynamicObject)model.getValue("company")).getLong("id"));
                if (model.getProperty("currency") != null) {
                    model.setValue("currency", currency.getPkValue());
                }
                if (model.getProperty("basecurrency") != null) {
                    model.setValue("basecurrency", currency.getPkValue());
                }
            }
            if (model.getProperty("exchangerate") != null) {
                model.setValue("exchangerate", (Object)Constants.ONE);
            }
            if (model.getProperty("amount") != null) {
                model.setValue("amount", (Object)Constants.ZERO);
                model.setValue("locamt", (Object)Constants.ZERO);
            }
            if (model.getProperty("billstatus") != null) {
                model.setValue("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            }
        }
        catch (Exception err) {
            logger.error("TmcBaseBillEdit afterCreateNewData error: \n", (Throwable)err);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "bizdate": 
            case "company": 
            case "currency": {
                if (EmptyUtil.isEmpty((Object)this.getModel().getValue("currency")) || EmptyUtil.isEmpty((Object)this.getModel().getValue("company")) || this.getModel().getProperty("bizdate") == null || EmptyUtil.isEmpty((Object)this.getModel().getValue("bizdate"))) break;
                BigDecimal rate = Constants.ONE;
                this.getModel().setValue("exchangerate", (Object)rate);
                this.calLocAmount();
                break;
            }
            case "amount": {
                this.calLocAmount();
            }
        }
    }

    private void calLocAmount() {
        BigDecimal rate;
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        if (amount == null) {
            amount = Constants.ZERO;
        }
        if ((rate = (BigDecimal)this.getModel().getValue("exchangerate")) == null) {
            rate = Constants.ONE;
        }
        this.getModel().setValue("locamt", (Object)amount.multiply(rate));
    }

    protected String getDataEntityName() {
        return this.getModel().getDataEntityType().getName();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("showlog".equals(operateKey)) {
            String billNo = (String)this.getModel().getValue("billno");
            ListShowParameter sp = ShowFormHelper.createShowListForm((String)"bei_banklog", (boolean)false);
            String targetKey = this.getView().getFormShowParameter().getOpenStyle().getTargetKey();
            if ("_submaintab_".equals(targetKey)) {
                sp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                sp.getOpenStyle().setInlineStyleCss(null);
            } else {
                sp.getOpenStyle().setShowType(ShowType.Modal);
            }
            sp.setFormId("bos_list");
            sp.getListFilterParameter().setFilter(new QFilter("entryentity.e_billnumber", "=", (Object)billNo).and(new QFilter("entryentity.e_billtype", "=", (Object)this.getView().getEntityId())));
            this.getView().showForm((FormShowParameter)sp);
        }
    }

    protected String getPermissionItem() {
        return "47156aff000000ac";
    }
}

