/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.common;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TmcFilterContainerPlugin
extends AbstractListPlugin {
    public static final String FILTER_CONTAINER = "filtercontainerap";
    private static final List<String> ACCT_MANAGER_BY_ORG_ENTITYS = Arrays.asList("cas_balanceadjust", "bei_elecstatement", "bei_checkdetailcorrect", "bei_elecmatchcheck", "bei_elecbalancestate_acc");
    private static final String FDATAID = "fdataid";
    private static final String ACCOUNTBANKS_U_WHERE_FUSEORGID_IN = "select fdataid from t_bd_accountbanks_u where fuseorgid in ";
    private static final String DELIMITER = ",";
    private static final String PREFIX = "(";
    private static final String SUFFIX = ")";
    private static final String QUESTION_MARK = "?";
    private static final String FORM_ID = "formId";

    public void initialize() {
        String formId = this.getPageCache().get(FORM_ID);
        if (!(this.getView() instanceof ListView) && EmptyUtil.isNoEmpty((String)formId)) {
            FilterContainer filterContainer = (FilterContainer)this.getControl(FILTER_CONTAINER);
            filterContainer.setBillFormId(formId);
            filterContainer.addBeforeF7SelectListener(this::filterContainerBeforeF7Select);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        this.addFilterByAccountBank(args);
    }

    private void addFilterByAccountBank(BeforeFilterF7SelectEvent args) {
        String refEntityId = args.getRefEntityId();
        if ("bd_accountbanks".equals(refEntityId) || "am_accountbank".equals(refEntityId) || "cas_accountcash".equals(refEntityId)) {
            String appId = "";
            String billFormId = "";
            if (this.getView() instanceof ListView) {
                ListShowParameter listParam = (ListShowParameter)this.getView().getFormShowParameter();
                appId = listParam.getAppId();
                billFormId = listParam.getBillFormId();
            } else {
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                appId = formShowParameter.getFormConfig().getAppId();
                billFormId = formShowParameter.getFormConfig().getEntityTypeId();
            }
            List authorizedOrgs = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)billFormId, (String)"47150e89000000ac");
            if (EmptyUtil.isNoEmpty((Object)authorizedOrgs)) {
                Set<Object> orgIds = authorizedOrgs.stream().collect(Collectors.toSet());
                if (ACCT_MANAGER_BY_ORG_ENTITYS.contains(billFormId) || "cas_accountcash".equals(refEntityId)) {
                    QFilter qFilter = new QFilter("org", "in", orgIds);
                    args.getQfilters().add(qFilter);
                } else {
                    Set<Long> acctIdsByUseOrg = this.getAcctIdsByUseOrg(orgIds);
                    if (EmptyUtil.isNoEmpty(acctIdsByUseOrg)) {
                        QFilter qFilter = new QFilter("id", "in", acctIdsByUseOrg);
                        args.getQfilters().add(qFilter);
                    }
                }
            }
        }
    }

    private Set<Long> getAcctIdsByUseOrg(Set<Object> orgIds) {
        StringJoiner stringJoiner = new StringJoiner(DELIMITER, PREFIX, SUFFIX);
        orgIds.forEach(o -> stringJoiner.add(QUESTION_MARK));
        String selectSql = ACCOUNTBANKS_U_WHERE_FUSEORGID_IN + stringJoiner;
        Set acctIdsByUseOrg = (Set)DB.query((DBRoute)DBRouteConst.SYS, (String)selectSql, (Object[])orgIds.toArray(), rs -> {
            HashSet<Long> dataIds = new HashSet<Long>(orgIds.size());
            while (rs.next()) {
                if (!EmptyUtil.isNoEmpty((Object)rs) || !EmptyUtil.isNoEmpty((Long)rs.getLong(FDATAID))) continue;
                dataIds.add(rs.getLong(FDATAID));
            }
            return dataIds;
        });
        return acctIdsByUseOrg;
    }
}

