/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.common;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tmc.fbp.common.enums.TmcMatchPlanEnum;

public class TmcMatchPlanPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        this.initFieldColumn();
        this.echoMathPlanInfo();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"num"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            if (this.verify()) {
                this.returnDataToParent();
            }
        } else if ("btncancel".equals(key)) {
            this.getView().close();
        }
    }

    private boolean verify() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        if (entryEntity != null && entryEntity.size() > 0) {
            String blankLine = null;
            String blankLine_num = null;
            String errMessage = null;
            for (int i = 0; i < entryEntity.size(); ++i) {
                int temp;
                DynamicObject entry = (DynamicObject)entryEntity.get(i);
                if (entry.get("originalfields") == null || entry.get("relation") == null || entry.get("targetfields") == null || "".equals(entry.get("originalfields")) || "".equals(entry.get("relation")) || "".equals(entry.get("targetfields"))) {
                    if (blankLine == null) {
                        temp = i + 1;
                        blankLine = temp + ",";
                    } else {
                        temp = i + 1;
                        blankLine = blankLine + temp + ",";
                    }
                }
                if (!TmcMatchPlanEnum.DIFF.getValue().equals(entry.get("relation")) || entry.get("num") != null && !"".equals(entry.get("num"))) continue;
                if (blankLine_num == null) {
                    temp = i + 1;
                    blankLine_num = temp + ",";
                    continue;
                }
                temp = i + 1;
                blankLine_num = blankLine_num + temp + ",";
            }
            if (blankLine != null) {
                blankLine = blankLine.substring(0, blankLine.length() - 1);
                errMessage = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6709\u672a\u5f55\u5165\u5b57\u6bb5,\u8bf7\u5f55\u5165\u3002", (String)"TmcMatchPlanPlugin_0", (String)"tmc-fbp-formplugin", (Object[])new Object[0]), blankLine);
            }
            if (blankLine_num != null) {
                blankLine_num = blankLine_num.substring(0, blankLine_num.length() - 1);
                errMessage = errMessage == null ? String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8bf7\u9009\u62e9\u76f8\u5dee\u5c0f\u4e8e\u7684\u5929\u6570\u3002", (String)"TmcMatchPlanPlugin_2", (String)"tmc-fbp-formplugin", (Object[])new Object[0]), blankLine_num) : String.format(ResManager.loadKDString((String)"%1$s;\u7b2c%2$s\u884c\u8bf7\u9009\u62e9\u76f8\u5dee\u5c0f\u4e8e\u7684\u5929\u6570\u3002", (String)"TmcMatchPlanPlugin_3", (String)"tmc-fbp-formplugin", (Object[])new Object[0]), errMessage, blankLine_num);
            }
            if (errMessage != null) {
                this.getView().showTipNotification(errMessage);
                return false;
            }
            return true;
        }
        return true;
    }

    private void returnDataToParent() {
        IDataModel model = this.getModel();
        HashMap<String, String> data = new HashMap<String, String>(10);
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        String targetEntity = (String)this.getView().getFormShowParameter().getCustomParam("targetEntity");
        String originalEntity = (String)this.getView().getFormShowParameter().getCustomParam("originalEntity");
        if (entryEntity != null && entryEntity.size() > 0) {
            ArrayList list = new ArrayList(entryEntity.size());
            String showDataStr = "";
            StringBuilder showDataSB = new StringBuilder();
            EntityTypeUtil targetEntityTypeUtil = new EntityTypeUtil();
            EntityTypeUtil originalEntityTypeUtil = new EntityTypeUtil();
            for (DynamicObject entry : entryEntity) {
                HashMap<String, Object> dataMap = new HashMap<String, Object>(5);
                dataMap.put("targetfields", entry.get("targetfields"));
                dataMap.put("relation", entry.get("relation"));
                dataMap.put("originalfields", entry.get("originalfields"));
                dataMap.put("isnullmatch", entry.get("isnullmatch"));
                dataMap.put("num", entry.get("num"));
                list.add(dataMap);
                String targetFiledStr = entry.getString("targetfields");
                String relationStr = entry.getString("relation");
                String originalFiledStr = entry.getString("originalfields");
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)targetEntity);
                List filterFields = targetEntityTypeUtil.getFilterFields((IDataEntityType)entityType);
                for (FilterField field : filterFields) {
                    LocaleString caption = field.getCaption();
                    String fullFieldName = field.getFullFieldName();
                    if (!fullFieldName.equals(targetFiledStr)) continue;
                    showDataSB.append(" and ").append('\'').append(caption).append('\'');
                }
                showDataSB.append(" ");
                if (TmcMatchPlanEnum.EQUALS.getValue().equals(relationStr)) {
                    showDataSB.append(ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"TmcMatchPlanPlugin_8", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
                } else if (TmcMatchPlanEnum.DIFF.getValue().equals(relationStr)) {
                    showDataSB.append(ResManager.loadKDString((String)"\u76f8\u5dee\u5c0f\u4e8e", (String)"TmcMatchPlanPlugin_9", (String)"tmc-fbp-formplugin", (Object[])new Object[0])).append(entry.getString("num")).append(ResManager.loadKDString((String)"\u5929", (String)"TmcMatchPlanPlugin_10", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
                } else if (TmcMatchPlanEnum.LIKE.getValue().equals(relationStr)) {
                    showDataSB.append(ResManager.loadKDString((String)"\u6a21\u7cca\u5339\u914d", (String)"TmcMatchPlanPlugin_11", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
                }
                showDataSB.append(" ");
                MainEntityType entityType2 = EntityMetadataCache.getDataEntityType((String)originalEntity);
                List filterFields2 = originalEntityTypeUtil.getFilterFields((IDataEntityType)entityType2);
                for (FilterField field : filterFields2) {
                    LocaleString caption = field.getCaption();
                    String fullFieldName = field.getFullFieldName();
                    if (!fullFieldName.equals(originalFiledStr)) continue;
                    showDataSB.append('\'').append(caption).append('\'');
                }
            }
            showDataStr = showDataSB.toString();
            String jsonString = SerializationUtils.toJsonString(list);
            data.put("matchplanInfo", jsonString);
            data.put("displayInfo", showDataStr.substring(5));
        } else {
            data.put("matchplanInfo", null);
            data.put("displayInfo", "");
        }
        this.getView().returnDataToParent(data);
        this.getView().close();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        String name = e.getProperty().getName();
        String targetName = (String)this.getView().getFormShowParameter().getCustomParam("targetName");
        String targetEntity = (String)this.getView().getFormShowParameter().getCustomParam("targetEntity");
        if ("relation".equals(name)) {
            if (newValue != null && (model.getValue("targetfields") == null || "".equals(model.getValue("targetfields")))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bbe\u7f6e\u5339\u914d\u5173\u7cfb\u524d\u8bf7\u5148\u9009\u62e9%s\u5339\u914d\u5b57\u6bb5\u3002", (String)"TmcMatchPlanPlugin_5", (String)"tmc-fbp-formplugin", (Object[])new Object[0]), targetName));
                model.setValue("relation", null);
                return;
            }
            if (!TmcMatchPlanEnum.DIFF.getValue().equals(newValue)) {
                model.setValue("num", null);
            }
            if (TmcMatchPlanEnum.DIFF.getValue().equals(newValue)) {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)targetEntity);
                EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
                List filterFields = entityTypeUtil.getFilterFields((IDataEntityType)entityType);
                for (FilterField filterField : filterFields) {
                    IDataEntityProperty fieldProp;
                    if (!filterField.getFullFieldName().equals(model.getValue("targetfields")) || (fieldProp = filterField.getFieldProp()) instanceof DateProp || fieldProp instanceof TimeProp || fieldProp instanceof DateTimeProp || fieldProp instanceof ModifyDateProp || fieldProp instanceof CreateDateProp) continue;
                    LocaleString caption = filterField.getCaption();
                    String format = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5339\u914d\u5173\u7cfb'%1$s'\u4e0e\u60a8\u9009\u62e9\u7684%2$s\u5339\u914d\u5b57\u6bb5'%3$s'\u4e0d\u5339\u914d,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TmcMatchPlanPlugin_6", (String)"tmc-fbp-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u76f8\u5dee\u5c0f\u4e8e", (String)"TmcMatchPlanPlugin_9", (String)"tmc-fbp-formplugin", (Object[])new Object[0]), targetName, caption);
                    model.setValue("relation", null);
                    this.getView().showTipNotification(format);
                }
            } else if (TmcMatchPlanEnum.LIKE.getValue().equals(newValue)) {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)targetEntity);
                EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
                List filterFields = entityTypeUtil.getFilterFields((IDataEntityType)entityType);
                for (FilterField filterField : filterFields) {
                    IDataEntityProperty fieldProp;
                    if (!filterField.getFullFieldName().equals(model.getValue("targetfields")) || (fieldProp = filterField.getFieldProp()) instanceof TextProp) continue;
                    LocaleString caption = filterField.getCaption();
                    String format = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5339\u914d\u5173\u7cfb'%1$s'\u4e0e\u60a8\u9009\u62e9\u7684%2$s\u5339\u914d\u5b57\u6bb5'%3$s'\u4e0d\u5339\u914d,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TmcMatchPlanPlugin_7", (String)"tmc-fbp-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6a21\u7cca\u5339\u914d", (String)"TmcMatchPlanPlugin_11", (String)"tmc-fbp-formplugin", (Object[])new Object[0]), targetName, caption);
                    model.setValue("relation", null);
                    this.getView().showTipNotification(format);
                }
            }
        } else if ("targetfields".equals(name)) {
            model.setValue("relation", null);
            model.setValue("num", null);
        }
    }

    private void initFieldColumn() {
        ComboEdit targetFields = (ComboEdit)this.getControl("targetfields");
        ComboEdit originalFields = (ComboEdit)this.getControl("originalfields");
        String targetName = (String)this.getView().getFormShowParameter().getCustomParam("targetName");
        String originalName = (String)this.getView().getFormShowParameter().getCustomParam("originalName");
        targetFields.setCaption(new LocaleString(targetName));
        originalFields.setCaption(new LocaleString(originalName));
        HashMap<ComboEdit, String> initEntityMap = new HashMap<ComboEdit, String>(2);
        String targetEntity = (String)this.getView().getFormShowParameter().getCustomParam("targetEntity");
        String originalEntity = (String)this.getView().getFormShowParameter().getCustomParam("originalEntity");
        initEntityMap.put(targetFields, targetEntity);
        initEntityMap.put(originalFields, originalEntity);
        for (Map.Entry next : initEntityMap.entrySet()) {
            ComboEdit filedEdit = (ComboEdit)next.getKey();
            String entityName = (String)next.getValue();
            ArrayList<ComboItem> items = new ArrayList<ComboItem>();
            MainEntityType targetEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
            List filterFields = entityTypeUtil.getFilterFields((IDataEntityType)targetEntityType);
            for (FilterField field : filterFields) {
                boolean flag = field.isFieldPropAliasEmpty();
                if (flag) continue;
                LocaleString caption = field.getCaption();
                String fullFieldName = field.getFullFieldName();
                ComboItem item = new ComboItem(caption, fullFieldName);
                items.add(item);
            }
            filedEdit.setComboItems(items);
        }
    }

    private void echoMathPlanInfo() {
        String matchPlanInfo = (String)this.getView().getFormShowParameter().getCustomParam("matchplanInfo");
        if (matchPlanInfo != null && !"".equals(matchPlanInfo.trim())) {
            List list = (List)SerializationUtils.fromJsonString((String)matchPlanInfo, List.class);
            IDataModel model = this.getModel();
            for (Map map : list) {
                int index = model.createNewEntryRow("entryentity");
                for (Map.Entry next : map.entrySet()) {
                    model.setValue((String)next.getKey(), next.getValue(), index);
                }
            }
        }
    }
}

