/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.common.billversion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractBillVersionTabEdit
extends AbstractBasePlugIn
implements HyperLinkClickListener {
    private DynamicObject historyBill;
    private DynamicObject deserialBill;
    protected final List<String> hisHeadFields = Arrays.asList("h_id", "h_reason", "h_version", "h_applyid", "h_applycreate", "h_applybillno", "h_creator", "h_createtime");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid grid = (EntryGrid)this.getControl(this.getModifyEntryName());
        if (grid != null) {
            grid.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("openHistoryId")) {
            this.getView().setFormTitle(this.getFormTitle());
            Long historyId = (Long)this.getView().getFormShowParameter().getCustomParams().get("openHistoryId");
            this.historyBill = BillChangeHistoryHelper.getChangeHistoryById((Long)historyId, (String)this.getHistoryEntity());
            this.deserialBill = BillChangeHistoryHelper.deserializeBillInfo((DynamicObject)this.historyBill);
            this.coverNowPageInfo();
            String billStatus = "billstatus";
            if (this.isBaseDatabill()) {
                billStatus = "status";
            }
            this.getModel().setValue(billStatus, (Object)BillStatusEnum.SAVE.getValue());
            this.getView().setVisible(Boolean.valueOf(false), this.getHiddenButton().toArray(new String[0]));
        }
    }

    private void coverNowPageInfo() {
        for (IDataEntityProperty property : this.getModel().getDataEntityType().getProperties()) {
            String prop = property.getName();
            if (property instanceof EntryProp) {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(prop);
                for (int seq = entryEntity.size() - 1; seq >= 0; --seq) {
                    this.getModel().deleteEntryRow(prop, seq);
                }
                if (!this.deserialBill.getDataEntityType().getProperties().containsKey((Object)prop)) continue;
                DynamicObjectCollection entrys = this.deserialBill.getDynamicObjectCollection(prop);
                for (DynamicObject entry : entrys) {
                    DynamicObject addNew = this.getModel().getEntryEntity(prop).addNew();
                    for (IDataEntityProperty entryProperty : this.getModel().getEntryEntity(prop).getDynamicObjectType().getProperties()) {
                        String entryName = entryProperty.getName();
                        if (!entry.getDataEntityType().getProperties().containsKey((Object)entryName) || "multilanguagetext".equals(entryName)) continue;
                        addNew.set(entryName, entry.get(entryName));
                    }
                }
                continue;
            }
            if (!this.deserialBill.getDataEntityType().getProperties().containsKey((Object)prop) || prop.endsWith("_id") || prop.equals("multilanguagetext")) continue;
            this.getModel().setValue(prop, this.deserialBill.get(prop));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("openHistoryId")) {
            Pair pairBill = BillChangeHistoryHelper.getNextChangeHistory((DynamicObject)this.historyBill, (String)this.getHistoryEntity());
            DynamicObject compare = (DynamicObject)pairBill.getRight();
            if (compare == null) {
                String bizBillInfo = (String)this.getView().getFormShowParameter().getCustomParams().get("bizBillInfo");
                compare = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)bizBillInfo);
            }
            BillChangeHistoryHelper.showChangePropForFormView((DynamicObject)this.deserialBill, (DynamicObject)compare, (IFormView)this.getView());
            Map<String, String> bizEntryMap = this.getEntryNameAndEntryKey();
            for (Map.Entry<String, String> entry : bizEntryMap.entrySet()) {
                boolean isModify = BillChangeHistoryHelper.showChangePropForEntryGrid((DynamicObject)this.deserialBill, (DynamicObject)compare, (String)entry.getKey(), (String)entry.getValue(), (IFormView)this.getView());
                if (!isModify) continue;
                this.showTabMessage(entry.getKey());
            }
            Map<String, String> secondEntryMap = this.getSecondEntryNameAndEntryKey();
            for (Map.Entry<String, String> entry : secondEntryMap.entrySet()) {
                BillChangeHistoryHelper.showChangePropForEntryGrid((DynamicObject)this.deserialBill, (DynamicObject)compare, (String)entry.getKey(), (String)entry.getValue(), (IFormView)this.getView());
            }
            this.setModifyTabHide(false);
            this.getModel().setDataChanged(false);
        } else {
            this.initModifyInfo();
        }
    }

    protected void showTabMessage(String entryName) {
        String tabPageName;
        Map<String, String> map = this.getEntryPropAndTabPage();
        if (map != null && (tabPageName = map.get(entryName)) != null) {
            TabPage tabPage = (TabPage)this.getControl(tabPageName);
            tabPage.setMessage(ResManager.loadKDString((String)"(\u6709\u4fee\u6539)", (String)"AbstractBillVersionTabEdit_0", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
        }
    }

    protected Map<String, String> getEntryPropAndTabPage() {
        return null;
    }

    protected void initModifyInfo() {
        if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.setModifyTabHide(false);
            return;
        }
        Long pkId = (Long)this.getModel().getValue("id");
        Object[] historys = BillChangeHistoryHelper.getChangeHistoryByBizId((Long)pkId, (String)this.getModel().getDataEntityType().getName(), (String)this.getHistoryEntity());
        if (EmptyUtil.isEmpty((Object[])historys)) {
            this.setModifyTabHide(false);
            return;
        }
        this.setModifyTabHide(true);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(this.getModifyEntryName());
        TableValueSetter vs = new TableValueSetter(new String[0]);
        model.beginInit();
        List<String> showProps = this.getShowFieldProp();
        LinkedHashMap<String, String> maps = new LinkedHashMap<String, String>(16);
        for (String showProp : showProps) {
            vs.addField(showProp.contains(".") ? showProp.substring(0, showProp.indexOf(".")) : showProp, new Object[0]);
            String[] split = showProp.split("_");
            maps.put(split[1], showProp);
        }
        this.dealVsEntryInfo((DynamicObject[])historys, vs, maps);
        model.batchCreateNewEntryRow(this.getModifyEntryName(), vs);
        model.endInit();
        this.getView().updateView(this.getModifyEntryName());
        this.getModel().setDataChanged(false);
    }

    protected void dealVsEntryInfo(DynamicObject[] historys, TableValueSetter vs, LinkedHashMap<String, String> maps) {
        for (DynamicObject history : historys) {
            ArrayList<Object> addRow = new ArrayList<Object>(16);
            DynamicObject applyBill = BillChangeHistoryHelper.deserializeBillInfo((DynamicObject)history);
            for (Map.Entry<String, String> map : maps.entrySet()) {
                String key = map.getKey();
                String value = map.getValue();
                try {
                    addRow.add(this.hisHeadFields.contains(value) ? history.get(key) : applyBill.get(key));
                }
                catch (Exception e) {}
            }
            vs.addRow(addRow.toArray());
        }
    }

    private void setModifyTabHide(boolean hiden) {
        this.getView().setVisible(Boolean.valueOf(hiden), new String[]{this.getModifyTabName()});
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        int rowIndex = evt.getRowIndex();
        DynamicObject rowData = (DynamicObject)this.getModel().getEntryEntity(this.getModifyEntryName()).get(rowIndex);
        Object showParameter = this.isBaseDatabill() ? new BaseShowParameter() : new BillShowParameter();
        if (this.getClickVersion().equals(fieldName)) {
            showParameter.setPkId(this.getModel().getValue("id"));
            showParameter.setFormId(this.getModel().getDataEntityType().getName());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("openHistoryId", (Object)rowData.getLong("h_id"));
            showParameter.setEnableUserReentrant(true);
            showParameter.setStatus(OperationStatus.EDIT);
            if (rowIndex + 1 == this.getModel().getEntryEntity(this.getModifyEntryName()).size()) {
                showParameter.setCustomParam("bizBillInfo", (Object)this.getBizBillInfo());
            }
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (this.getClickApplyNo().equals(fieldName)) {
            showParameter.setFormId(this.getApplyBillEntity());
            showParameter.setPkId((Object)rowData.getLong("h_applyid"));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private boolean isBaseDatabill() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return formShowParameter instanceof BaseShowParameter;
    }

    protected abstract String getApplyBillEntity();

    protected abstract Map<String, String> getEntryNameAndEntryKey();

    protected Map<String, String> getSecondEntryNameAndEntryKey() {
        return new HashMap<String, String>(16);
    }

    protected abstract String getModifyTabName();

    protected abstract String getModifyEntryName();

    protected abstract List<String> getShowFieldProp();

    protected abstract String getClickVersion();

    protected abstract String getClickApplyNo();

    protected abstract List<String> getHiddenButton();

    protected abstract LocaleString getFormTitle();

    protected abstract String getBizBillInfo();

    protected String getHistoryEntity() {
        return "fcs_changehistory";
    }
}

