/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.common.guaranteeuse;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class GuaranteeUseListPlugin
extends AbstractTmcBillBaseList {
    public static final String AFTER_CONFIRM = "afterConfirm";
    private static final String AFTER_CREDIT_SURETY_AMT_CONFIRM = "after_credit_surety_amt_confirm";
    public static final String CONFIRM_GUARANTEE_AMOUNT = "confirm_guarantee_amount";
    public static final String GUARANTEE_NO = "guaranteeno";
    public static final String OP_SUBMIT = "submit";
    public static final String OP_UN_SUBMIT = "unsubmit";
    public static final String OP_UN_AUDIT = "unaudit";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        switch (op.getOperateKey()) {
            case "submit": {
                op.getOption().setVariableValue("formId", ((ListView)this.getView()).getBillFormId());
                this.verifyGuaranteeContractAmt(args, op);
                break;
            }
            case "unsubmit": 
            case "unaudit": {
                op.getOption().setVariableValue("formId", ((ListView)this.getView()).getBillFormId());
            }
        }
    }

    private void verifyGuaranteeContractAmt(BeforeDoOperationEventArgs args, FormOperate op) {
        if (!op.getOption().getVariables().containsKey(AFTER_CONFIRM)) {
            List<Long> lgIds = this.getSelectedIdList();
            HashMap<String, List> billNoToGcUseMap = new HashMap<String, List>(16);
            ArrayList<Long> gcIds = new ArrayList<Long>(8);
            ArrayList<Long> gDebtOrgIds = new ArrayList<Long>(8);
            HashMap<String, DynamicObject> billNoToBillMap = new HashMap<String, DynamicObject>(8);
            if ("gm_letterofguaapply".equals(((ListView)this.getView()).getBillFormId()) || "cfm_contract_apply".equals(((ListView)this.getView()).getBillFormId())) {
                DynamicObject[] bills;
                for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)((ListView)this.getView()).getBillFormId(), (String)String.join((CharSequence)",", "billno", "letterofguarantee", "org", "gcontract", "gamount", "gexchrate"), (QFilter[])new QFilter[]{new QFilter("id", "in", lgIds)})) {
                    billNoToBillMap.put(bill.getString("billno"), bill);
                    billNoToGcUseMap.put(bill.getString("billno"), new ArrayList(8));
                    for (DynamicObject gcUseBill : bill.getDynamicObjectCollection("entry_gcontract")) {
                        gcIds.add(gcUseBill.getDynamicObject("gcontract").getLong("id"));
                        gDebtOrgIds.add(bill.getDynamicObject("org").getLong("id"));
                        ((List)billNoToGcUseMap.get(bill.getString("billno"))).add(gcUseBill);
                    }
                }
            } else {
                DynamicObject[] gcUseBills = TmcDataServiceHelper.load((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", "gcontract", "gdebtorg", "gamount", "gexchrate", "gsrcbillid", "gsrcbillno"), (QFilter[])new QFilter[]{new QFilter("gsrcbillid", "in", lgIds)});
                for (DynamicObject gcUse : gcUseBills) {
                    gcIds.add(gcUse.getDynamicObject("gcontract").getLong("id"));
                    gDebtOrgIds.add(gcUse.getLong("gdebtorg"));
                    billNoToGcUseMap.computeIfAbsent(gcUse.getString("gsrcbillno"), k -> new ArrayList(8));
                    ((List)billNoToGcUseMap.get(gcUse.getString("gsrcbillno"))).add(gcUse);
                }
            }
            if (billNoToGcUseMap.size() == 0) {
                return;
            }
            Map availMap = GuaranteeUseHelper.getGContractAvailableDutyAmt(gcIds, gDebtOrgIds);
            HashMap billNoToGContractNo = new HashMap(16);
            for (Map.Entry entry : billNoToGcUseMap.entrySet()) {
                List useList = (List)entry.getValue();
                ArrayList<String> contractNoForTips = new ArrayList<String>(10);
                for (int i = 0; i < useList.size(); ++i) {
                    BigDecimal exRate;
                    BigDecimal gAmount;
                    DynamicObject gcUse = (DynamicObject)useList.get(i);
                    DynamicObject gc = gcUse.getDynamicObject("gcontract");
                    Long gcId = gc.getLong("id");
                    DynamicObject bill = (DynamicObject)billNoToBillMap.get(entry.getKey());
                    BigDecimal amount = this.queryTargetBillUseAmount(gc, bill);
                    BigDecimal availAmt = availMap.get(gcId) != null ? ((BigDecimal)availMap.get(gcId)).add(amount) : BigDecimal.ZERO.add(amount);
                    if (availAmt.compareTo((gAmount = gcUse.getBigDecimal("gamount")).multiply(exRate = gcUse.getBigDecimal("gexchrate"))) >= 0) continue;
                    contractNoForTips.add(i + 1 + "");
                }
                if (contractNoForTips.isEmpty()) continue;
                billNoToGContractNo.put(entry.getKey(), contractNoForTips);
            }
            if (billNoToGContractNo.size() == 0) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : billNoToGContractNo.entrySet()) {
                sb.append(String.format(ResManager.loadResFormat((String)"\u3010%1$s\u3011\u62c5\u4fdd\u4fe1\u606f\u7b2c%2$s\u884c\u5206\u5f55", (String)"GuaranteeUseListPlugin_1", (String)"tmc-fbp-formplugin", (Object[])new Object[0]), entry.getKey(), String.join((CharSequence)",", (Iterable)entry.getValue())));
                sb.append('\n');
            }
            sb.append(ResManager.loadKDString((String)"\u4e2d\u7684\u62c5\u4fdd\u91d1\u989d\u5df2\u7ecf\u8d85\u51fa\u88ab\u62c5\u4fdd\u91d1\u989d\uff0c\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\uff1f", (String)"GuaranteeUseListPlugin_0", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(sb.toString(), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_GUARANTEE_AMOUNT, (IFormPlugin)this));
            args.setCancel(true);
        }
    }

    private BigDecimal queryTargetBillUseAmount(DynamicObject guaranteeContract, DynamicObject applyBill) {
        Object[] sourceBillUse;
        DynamicObject letterOfGuaranteeF7;
        if ("gm_letterofguaapply".equals(((ListView)this.getView()).getBillFormId()) && (letterOfGuaranteeF7 = applyBill.getDynamicObject("letterofguarantee")) != null && EmptyUtil.isNoEmpty((Object[])(sourceBillUse = TmcDataServiceHelper.load((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", "gdebtbalance", "gexchrate"), (QFilter[])new QFilter[]{new QFilter("gsrcbillid", "=", letterOfGuaranteeF7.getPkValue()).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("gcontract", "=", guaranteeContract.getPkValue())})))) {
            return sourceBillUse[0].getBigDecimal("gdebtbalance").multiply(sourceBillUse[0].getBigDecimal("gexchrate"));
        }
        return BigDecimal.ZERO;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (CONFIRM_GUARANTEE_AMOUNT.equals(callBackId) && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue(AFTER_CONFIRM, "1");
            if (EmptyUtil.isNoEmpty((String)this.getPageCache().get(AFTER_CREDIT_SURETY_AMT_CONFIRM))) {
                option.setVariableValue(AFTER_CREDIT_SURETY_AMT_CONFIRM, "1");
                this.getPageCache().remove(AFTER_CREDIT_SURETY_AMT_CONFIRM);
            }
            this.getView().invokeOperation(OP_SUBMIT, option);
        }
    }
}

