/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.field.ComboItem;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.IntCalMethodEnum;

public class IntcalMethodChgHelper {
    private static final List<BasisEnum> compOrTotalcallint = new ArrayList<BasisEnum>(16);
    private static final List<BasisEnum> onecallint = new ArrayList<BasisEnum>(16);
    private static final List<BasisEnum> periodcallint = new ArrayList<BasisEnum>(16);

    public static List<ComboItem> getBasisComboItem(String intcalMethod, String status) {
        if (BillStatusEnum.AUDIT.getValue().equals(status)) {
            return Arrays.stream(BasisEnum.values()).map(basis -> IntcalMethodChgHelper.createComboItem(basis)).collect(Collectors.toList());
        }
        if (IntCalMethodEnum.isTotalcallint((String)intcalMethod) || IntCalMethodEnum.isCompcallint((String)intcalMethod)) {
            return IntcalMethodChgHelper.getComboItems(compOrTotalcallint);
        }
        if (IntCalMethodEnum.isOnecallint((String)intcalMethod)) {
            return IntcalMethodChgHelper.getComboItems(onecallint);
        }
        if (IntCalMethodEnum.isPeriodcallint((String)intcalMethod)) {
            return IntcalMethodChgHelper.getComboItems(periodcallint);
        }
        return Collections.emptyList();
    }

    public static List<ComboItem> getComboItems(List<BasisEnum> basiss) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        for (BasisEnum basis : basiss) {
            comboItems.add(IntcalMethodChgHelper.createComboItem(basis));
        }
        return comboItems;
    }

    public static ComboItem createComboItem(BasisEnum basisEnum) {
        ComboItem comboItem = new ComboItem();
        comboItem.setValue(basisEnum.getValue());
        comboItem.setCaption(new LocaleString(basisEnum.getName()));
        return comboItem;
    }

    static {
        compOrTotalcallint.add(BasisEnum.Actual_360);
        compOrTotalcallint.add(BasisEnum.Actual_365);
        periodcallint.add(BasisEnum.SIA_30_360);
        periodcallint.add(BasisEnum.BMA_30_360);
        periodcallint.add(BasisEnum.ISDA_30_360);
        periodcallint.add(BasisEnum.European_30_360);
        periodcallint.add(BasisEnum.ICMA_30_360);
        periodcallint.add(BasisEnum.DEP_30_360);
        onecallint.add(BasisEnum.Actual_360);
        onecallint.add(BasisEnum.Actual_365);
        onecallint.add(BasisEnum.Actual_actual);
        onecallint.add(BasisEnum.ICMA_Actual_actual);
        onecallint.add(BasisEnum.ICMA_Actual_360);
        onecallint.add(BasisEnum.ICMA_Actual_365);
        onecallint.add(BasisEnum.ISDA_Actual_365);
        onecallint.add(BasisEnum.BUS_252);
        onecallint.add(BasisEnum.Japanese_Actual_365);
    }
}

