/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.common.pricerule;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FieldTip;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PriceRuleEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public static final String FPRICERULE = "pricerule";
    public static final String REFERDATE = "referdate";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit priceRule = (BasedataEdit)this.getView().getControl(FPRICERULE);
        priceRule.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit pricerule = (BasedataEdit)this.getView().getControl(FPRICERULE);
        Optional.ofNullable(pricerule).ifPresent(c -> c.addBeforeF7ViewDetailListener(this::beforeF7ViewDetail));
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String fieldKey = arg.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)FPRICERULE)) {
            this.priceRuleFilter(arg);
        }
    }

    protected void priceRuleFilter(BeforeF7SelectEvent arg) {
        ListShowParameter showParameter = (ListShowParameter)arg.getFormShowParameter();
        IFormView parentView = this.getView().getParentView();
        String entityId = parentView.getEntityId();
        IDataModel model = parentView.getModel();
        if (ProductTypeEnum.STRUCTDEPOSIT.getEntity().equals(entityId) || ProductTypeEnum.FORWRATEAGREE.getEntity().equals(entityId) || ProductTypeEnum.SWAP.getEntity().equals(entityId)) {
            String billstatus = (String)model.getValue("billstatus");
            if (!BillStatusEnum.SAVE.getValue().equals(billstatus)) {
                ArrayList<Long> currencyIds = new ArrayList<Long>(2);
                DynamicObject currency = (DynamicObject)model.getValue("currency");
                currencyIds.add(currency.getLong("id"));
                if (ProductTypeEnum.SWAP.getEntity().equals(entityId)) {
                    String swapType = (String)model.getValue("rateswaptype");
                    if ("currency".equals(swapType)) {
                        DynamicObject reccurrency = (DynamicObject)model.getValue("reccurrency");
                        currencyIds.add(reccurrency.getLong("id"));
                        QFilter qFilter = new QFilter("markets.fbasedataid.currency.id", "in", currencyIds);
                        DynamicObject[] pricerules = TmcDataServiceHelper.load((String)"md_pricerule", (String)"id,markets", (QFilter[])qFilter.toArray());
                        if (pricerules != null) {
                            ArrayList<Long> priceruleIds = new ArrayList<Long>();
                            for (DynamicObject pricerule : pricerules) {
                                DynamicObjectCollection markets = pricerule.getDynamicObjectCollection("markets");
                                Set ids = markets.stream().map(e -> e.getDynamicObject("fbasedataid").getDynamicObject("currency").getLong("id")).collect(Collectors.toSet());
                                if (!ids.contains(currency.getLong("id")) || !ids.contains(reccurrency.getLong("id"))) continue;
                                priceruleIds.add(pricerule.getLong("id"));
                            }
                            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", priceruleIds));
                        }
                    } else {
                        QFilter qFilter = new QFilter("markets.fbasedataid.currency.id", "=", (Object)currency.getLong("id"));
                        showParameter.getListFilterParameter().setFilter(qFilter);
                    }
                } else {
                    QFilter qFilter = new QFilter("markets.fbasedataid.currency.id", "=", (Object)currency.getLong("id"));
                    showParameter.getListFilterParameter().setFilter(qFilter);
                }
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long pricerule = (Long)this.getView().getFormShowParameter().getCustomParam(FPRICERULE);
        String referdate = (String)this.getView().getFormShowParameter().getCustomParam(REFERDATE);
        if (EmptyUtil.isNoEmpty((Long)pricerule)) {
            this.getModel().setValue(FPRICERULE, (Object)pricerule);
        }
        if (EmptyUtil.isNoEmpty((String)referdate)) {
            this.getModel().setValue(REFERDATE, (Object)DateUtils.stringToDate((String)referdate, (String)"yyyy-MM-dd"));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if ("md_yieldline".equals(this.getView().getFormShowParameter().getParentFormId())) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{FPRICERULE});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FPRICERULE});
        }
        Object bizBillStatus = this.getView().getFormShowParameter().getCustomParam("billstatus");
        if (TcBillStatusEnum.SURVIVAL.getValue().equals(bizBillStatus) || TcBillStatusEnum.FINISH.getValue().equals(bizBillStatus) || TcBillStatusEnum.SUBMIT.getValue().equals(bizBillStatus) || TcBillStatusEnum.AUDIT.getValue().equals(bizBillStatus)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{FPRICERULE});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operate = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("ok".equals(operate)) {
            Date referDate = (Date)this.getModel().getValue(REFERDATE);
            if (EmptyUtil.isEmpty((Object)referDate)) {
                FieldTip tip = new FieldTip();
                tip.setFieldKey(REFERDATE);
                tip.setLevel(FieldTip.FieldTipsLevel.Error);
                tip.setSuccess(false);
                tip.setTip(ResManager.loadKDString((String)"\u53c2\u8003\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"PriceRuleEdit_0", (String)"tmc-tbp-formplugin", (Object[])new Object[0]));
                this.getView().showFieldTip(tip);
                return;
            }
            this.getView().returnDataToParent((Object)this.getModel().getDataEntity());
            this.getModel().setDataChanged(false);
            this.getView().close();
            return;
        }
    }

    private void beforeF7ViewDetail(BeforeF7ViewDetailEvent event) {
        Object pkId = event.getPkId();
        BasedataEdit source = (BasedataEdit)event.getSource();
        String key = source.getKey();
        if (FPRICERULE.equals(key) && ShowType.Modal.equals((Object)this.getView().getFormShowParameter().getOpenStyle().getShowType())) {
            HashMap<String, Object> returnData = new HashMap<String, Object>(1);
            returnData.put("pkId", pkId);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }
}

