/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.common.push2payrec;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.tmc.fbp.common.util.EmptyUtil;

public abstract class AbstractPush2PayRecPlugIn
extends AbstractFormPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String tagBillType = this.getPush2PayOrRecType(args);
        if (EmptyUtil.isNoEmpty((String)tagBillType)) {
            boolean isPayBill = !"cas_recbill".equalsIgnoreCase(tagBillType);
            IFormView view = this.getView();
            if (view.getFormShowParameter() instanceof ListShowParameter) {
                this.listPush2PayRecOp(args, view, isPayBill);
            } else {
                this.formPush2PayRecOp(args, view, isPayBill);
            }
        }
    }

    private String getPush2PayOrRecType(BeforeDoOperationEventArgs args) {
        String targetbill;
        FormOperate formOperate = (FormOperate)args.getSource();
        String type = formOperate.getType();
        String operateKey = formOperate.getOperateKey();
        Map parameter = formOperate.getParameter();
        if ("push".equalsIgnoreCase(type) && EmptyUtil.isNoEmpty((Object)parameter) && !operateKey.endsWith("_nofrdcheck") && ("cas_paybill".equalsIgnoreCase(targetbill = (String)parameter.get("targetbill")) || "cas_recbill".equalsIgnoreCase(targetbill))) {
            return targetbill.toLowerCase();
        }
        return null;
    }

    private void formPush2PayRecOp(BeforeDoOperationEventArgs args, IFormView view, boolean isPayBill) {
        String errorInfo = isPayBill ? this.formPagePush2PayForwardValid(view.getModel().getDataEntity()) : this.formPagePush2RecForwardValid(view.getModel().getDataEntity());
        if (EmptyUtil.isNoEmpty((String)errorInfo)) {
            args.setCancel(true);
            view.showErrorNotification(errorInfo);
        }
    }

    private void listPush2PayRecOp(BeforeDoOperationEventArgs args, IFormView view, boolean isPayBill) {
        List<Object> selectEdPks = args.getListSelectedData().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        String entityName = ((FormOperate)args.getSource()).getEntityId();
        List<String> errorMessages = isPayBill ? this.listPagePush2PayForwardValid(selectEdPks, entityName) : this.listPagePush2RecForwardValid(selectEdPks, entityName);
        if (EmptyUtil.isNoEmpty(errorMessages)) {
            view.showErrorNotification(String.join((CharSequence)"\n", errorMessages));
            args.setCancel(true);
        }
    }

    public String formPagePush2PayForwardValid(DynamicObject info) {
        return null;
    }

    public List<String> listPagePush2PayForwardValid(List<Object> selectEdPks, String entityName) {
        return null;
    }

    public String formPagePush2RecForwardValid(DynamicObject info) {
        return null;
    }

    public List<String> listPagePush2RecForwardValid(List<Object> selectEdPks, String entityName) {
        return null;
    }
}

