/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.common.selectprop;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboEdit;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.tmc.fbp.common.bean.EntityPropInfo;
import kd.tmc.fbp.common.enums.EntityPropTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.common.selectprop.SelectEntityPropParam;

public class SelectEntityPropHelper {
    public static List<EntityPropInfo> getEntityProps(String entityNumber, boolean includeEntity, EntityPropTypeEnum ... propTypes) {
        ArrayList<EntityPropInfo> props = new ArrayList<EntityPropInfo>(8);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map fieldMap = includeEntity ? entityType.getAllFields() : entityType.getFields();
        ISimpleProperty primaryKey = entityType.getPrimaryKey();
        fieldMap.put(primaryKey.getName(), primaryKey);
        for (Map.Entry entry : fieldMap.entrySet()) {
            String localeValue;
            String propCode = (String)entry.getKey();
            IDataEntityProperty property = (IDataEntityProperty)entry.getValue();
            LocaleString displayName = property.getDisplayName();
            String parentCode = property.getParent() != null ? property.getParent().getName() : null;
            String string = localeValue = displayName != null ? displayName.getLocaleValue() : propCode;
            if (EmptyUtil.isEmpty((Object[])propTypes)) {
                props.add(EntityPropInfo.build((String)parentCode, (String)propCode, (String)localeValue));
                continue;
            }
            block13: for (EntityPropTypeEnum propType : propTypes) {
                switch (propType) {
                    case LONG: {
                        if (!(property instanceof LongProp)) continue block13;
                        props.add(EntityPropInfo.build((String)parentCode, (String)propCode, (String)localeValue));
                        continue block13;
                    }
                    case ENUM: {
                        if (!(property instanceof ComboProp)) continue block13;
                        props.add(EntityPropInfo.build((String)parentCode, (String)propCode, (String)localeValue));
                        continue block13;
                    }
                    case AMOUNT: {
                        if (!(property instanceof AmountProp)) continue block13;
                        props.add(EntityPropInfo.build((String)parentCode, (String)propCode, (String)localeValue));
                        continue block13;
                    }
                    case DATE: {
                        if (!(property instanceof DateProp)) continue block13;
                        props.add(EntityPropInfo.build((String)parentCode, (String)propCode, (String)localeValue));
                        continue block13;
                    }
                    case DATETIME: {
                        if (!(property instanceof DateTimeProp)) continue block13;
                        props.add(EntityPropInfo.build((String)parentCode, (String)propCode, (String)localeValue));
                        continue block13;
                    }
                    case ORG: {
                        if (!(property instanceof OrgProp)) continue block13;
                        props.add(EntityPropInfo.build((String)parentCode, (String)propCode, (String)localeValue));
                        continue block13;
                    }
                    case CURRENCY: {
                        if (!(property instanceof CurrencyProp)) continue block13;
                        props.add(EntityPropInfo.build((String)parentCode, (String)propCode, (String)localeValue));
                        continue block13;
                    }
                    case BASEDATA: {
                        if (!(property instanceof BasedataProp)) continue block13;
                        props.add(EntityPropInfo.build((String)parentCode, (String)propCode, (String)localeValue));
                        continue block13;
                    }
                    case BILL: {
                        if (!(property instanceof RefBillProp)) continue block13;
                        props.add(EntityPropInfo.build((String)parentCode, (String)propCode, (String)localeValue));
                        continue block13;
                    }
                    case BOOL: {
                        if (!(property instanceof BooleanProp)) continue block13;
                        props.add(EntityPropInfo.build((String)parentCode, (String)propCode, (String)localeValue));
                        continue block13;
                    }
                }
            }
        }
        return props;
    }

    public static void showSelectProps(SelectEntityPropParam param) {
        String entityNumber = param.getEntityNumber();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tmc_selectfield");
        MainEntityType sourceMainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setCurrentEntity(entityNumber);
        option.setIncludeChildEntity(param.isIncludeEntity());
        option.setOnlyPhysicsField(true);
        option.setIncludeEntryEntityAsKeyPrefix(param.isIncludeEntryEntityAsKeyPrefix());
        option.setIncludeBDPropPK(true);
        option.setIncludeBDRefProp(param.isIncludeRefProp());
        option.setIncludePKField(param.isIncludePKField());
        EntityPropTypeEnum[] propTypes = param.getPropTypes();
        if (propTypes != null) {
            block14: for (EntityPropTypeEnum propType : propTypes) {
                switch (propType) {
                    case STRING: {
                        option.addMatchedClassTypes(TextProp.class);
                        continue block14;
                    }
                    case ORG: {
                        option.addMatchedClassTypes(OrgProp.class);
                        option.addMatchedClassTypes(LongProp.class);
                        continue block14;
                    }
                    case BOOL: {
                        option.addMatchedClassTypes(BooleanProp.class);
                        continue block14;
                    }
                    case DATE: {
                        option.addMatchedClassTypes(DateProp.class);
                        option.addMatchedClassTypes(DateTimeProp.class);
                        continue block14;
                    }
                    case CURRENCY: {
                        option.addMatchedClassTypes(CurrencyProp.class);
                        option.addMatchedClassTypes(LongProp.class);
                        option.addMatchedClassTypes(BigIntProp.class);
                        continue block14;
                    }
                    case ENUM: {
                        option.addMatchedClassTypes(TextProp.class);
                        option.addMatchedClassTypes(ComboProp.class);
                        continue block14;
                    }
                    case LONG: {
                        option.addMatchedClassTypes(LongProp.class);
                        option.addMatchedClassTypes(BigIntProp.class);
                        option.addMatchedClassTypes(BasedataProp.class);
                        continue block14;
                    }
                    case AMOUNT: {
                        option.addMatchedClassTypes(AmountProp.class);
                        continue block14;
                    }
                    case DECIMAL: {
                        option.addMatchedClassTypes(DecimalProp.class);
                        continue block14;
                    }
                    case BASEDATA: {
                        option.addMatchedClassTypes(BasedataProp.class);
                        continue block14;
                    }
                    case DATETIME: {
                        option.addMatchedClassTypes(DateTimeProp.class);
                        continue block14;
                    }
                    case BILL: {
                        option.addMatchedClassTypes(BasedataProp.class);
                        option.addMatchedClassTypes(LongProp.class);
                        option.addMatchedClassTypes(BigIntProp.class);
                        option.addMatchedClassTypes(RefBillProp.class);
                        continue block14;
                    }
                }
            }
        }
        TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceMainType, (PropTreeBuildOption)option);
        SelectEntityPropHelper.updateNodeInfo(treeNode, param);
        String toJson = SerializationUtils.toJsonString((Object)treeNode);
        showParameter.getCustomParams().put("treenodes", toJson);
        showParameter.getCustomParams().put("ismulti", String.valueOf(param.isMultiSelect()));
        showParameter.getCustomParams().put("selectNodeType", param.getSelectNodeType());
        showParameter.setCloseCallBack(new CloseCallBack(param.getPlugin(), param.getCallBackActionId()));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        param.getView().showForm(showParameter);
    }

    private static void updateNodeInfo(TreeNode treeNode, SelectEntityPropParam param) {
        String BILLHEAD = "billhead";
        if (param.isIncludeRefProp()) {
            for (TreeNode child : treeNode.getChildren()) {
                String parentId = child.getId();
                if (!"billhead".equals(parentId)) {
                    child.setText(String.format("%s(%s)", child.getText(), child.getId()));
                }
                List children = child.getChildren();
                for (TreeNode node : children) {
                    String nodeId = node.getId();
                    int indexOf = nodeId.indexOf(".");
                    if (indexOf >= 0) {
                        nodeId = nodeId.substring(indexOf + 1);
                    }
                    if (nodeId.equals("id")) continue;
                    node.setText(String.format("%s(%s)", node.getText(), nodeId));
                    List children1 = node.getChildren();
                    if (!EmptyUtil.isNoEmpty((Object)children1)) continue;
                    for (TreeNode treeNode1 : children1) {
                        treeNode1.setText(String.format("%s(%s)", node.getText(), treeNode1.getId()));
                    }
                }
            }
        } else {
            Map<Boolean, List<String>> defProps = param.getDefProps();
            List<String> defEntryProps = param.getDefEntryProps();
            boolean includeHead = param.isIncludeHead();
            List firstNodeList = treeNode.getChildren();
            Iterator firstIt = firstNodeList.iterator();
            while (firstIt.hasNext()) {
                TreeNode firstNode = (TreeNode)firstIt.next();
                String firstNodeId = firstNode.getId();
                if (defEntryProps != null && !"billhead".equals(firstNodeId) && !defEntryProps.contains(firstNodeId)) {
                    firstIt.remove();
                    continue;
                }
                if (!includeHead && "billhead".equals(firstNodeId)) {
                    firstIt.remove();
                    continue;
                }
                if (!"billhead".equals(firstNodeId)) {
                    firstNode.setText(String.format("%s(%s)", firstNode.getText(), firstNode.getId()));
                }
                List children = firstNode.getChildren();
                Iterator<TreeNode> it = children.iterator();
                while (it.hasNext()) {
                    TreeNode node = (TreeNode)it.next();
                    String nodeId = node.getId();
                    String subText = node.getText();
                    if (SelectEntityPropHelper.dealDefPropRange(defProps, it, nodeId)) continue;
                    int indexOf = nodeId.indexOf(".");
                    if (indexOf >= 0) {
                        nodeId = nodeId.substring(indexOf + 1);
                    }
                    if (!"id".equals(nodeId)) {
                        node.setText(String.format("%s(%s)", subText, nodeId));
                        continue;
                    }
                    if (!"billhead".equals(firstNodeId)) continue;
                    node.setText(subText.substring(4));
                }
            }
        }
    }

    private static boolean dealDefPropRange(Map<Boolean, List<String>> defProps, Iterator<TreeNode> nodeIterator, String nodeId) {
        if (EmptyUtil.isEmpty(defProps)) {
            return false;
        }
        List<String> forBidFeilds = defProps.get(Boolean.FALSE);
        if (EmptyUtil.isNoEmpty(forBidFeilds) && forBidFeilds.contains(nodeId)) {
            nodeIterator.remove();
            return true;
        }
        List<String> rightFeilds = defProps.get(Boolean.TRUE);
        if (rightFeilds != null && !rightFeilds.contains(nodeId)) {
            nodeIterator.remove();
            return true;
        }
        return false;
    }

    public static String getSelectPropValues(String returnData) {
        return SelectEntityPropHelper.getSelectPropInfos(returnData).stream().map(EntityPropInfo::getCode).collect(Collectors.joining(","));
    }

    public static List<EntityPropInfo> getSelectPropInfos(String returnData) {
        ArrayList<EntityPropInfo> propInfos = new ArrayList<EntityPropInfo>(8);
        String[] fields = returnData.split(",");
        for (int i = 0; i < fields.length; i += 2) {
            propInfos.add(EntityPropInfo.build((String)fields[i], (String)fields[i + 1]));
        }
        return propInfos;
    }

    public static void initEnumPropItems(IFormView formView, String entityNumber, String propName, EntityPropTypeEnum ... propTypes) {
        List<EntityPropInfo> combos = SelectEntityPropHelper.getEntityProps(entityNumber, false, propTypes);
        SelectEntityPropHelper.initEnumPropItems(formView, propName, combos);
    }

    public static void initEnumPropItems(IFormView formView, String propName, List<EntityPropInfo> combos) {
        ArrayList items = new ArrayList();
        combos.forEach(o -> items.add(o.convertComboItem()));
        ((ComboEdit)formView.getControl(propName)).setComboItems(items);
    }
}

