/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.list;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterGridView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.FilterColumnSetFilterEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.util.EmptyUtil;

public abstract class AbstractTmcListPlugin
extends AbstractListPlugin {
    public void filterColumnSetFilter(SetFilterEvent args) {
        this.initPageFilterCache();
        this.initPageFilterValueCache((FilterColumnSetFilterEvent)args);
        String fieldName = args.getFieldName();
        List<QFilter> customFilter = this.addCustomFilterForFilterCol(fieldName);
        if (customFilter != null && customFilter.size() > 0) {
            args.setCustomQFilters(customFilter);
        }
        super.filterColumnSetFilter(args);
    }

    private void initPageFilterCache() {
        if (EmptyUtil.isEmpty((String)this.getPageCache().get("filterFields"))) {
            HashSet<String> filterFields = new HashSet<String>();
            FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
            List items = filterContainer.getItems();
            for (Control item : items) {
                if (!(item instanceof FilterGridView)) continue;
                for (FilterColumn column : ((FilterGridView)item).getFilterColumns()) {
                    filterFields.add(column.getFieldName());
                }
                this.getPageCache().put("filterFields", JSON.toJSONString(filterFields));
            }
        }
    }

    private void initPageFilterValueCache(FilterColumnSetFilterEvent args) {
        if (EmptyUtil.isNoEmpty((String)this.getPageCache().get("filterFields"))) {
            Set filterFields = (Set)JSON.parseObject((String)this.getPageCache().get("filterFields"), (TypeReference)new TypeReference<Set<String>>(){}, (Feature[])new Feature[0]);
            HashMap<String, List> filterFieldValues = new HashMap<String, List>(filterFields.size());
            for (String fieldName : filterFields) {
                filterFieldValues.put(fieldName, args.getCommonFilterValue(fieldName));
            }
            this.getPageCache().put("filterFieldValues", JSON.toJSONString(filterFieldValues));
        }
    }

    protected List<QFilter> addCustomFilterForFilterCol(String fieldName) {
        return null;
    }

    protected List<Object> getPageFilterColumnCache(String fieldName) {
        String json = this.getPageCache().get("filterFieldValues");
        if (EmptyUtil.isNoEmpty((String)json)) {
            Map filterFieldValues = (Map)JSON.parseObject((String)json, (TypeReference)new TypeReference<Map<String, List<Object>>>(){}, (Feature[])new Feature[0]);
            return (List)filterFieldValues.get(fieldName);
        }
        return null;
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter baseShowParameter = e.getParameter();
        OpenStyle style = new OpenStyle();
        style.setShowType(this.showModel());
        baseShowParameter.setOpenStyle(style);
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(this.disableDoubleClick());
    }

    protected List<Long> getSelectedIdList() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        List<Long> idList = new ArrayList<Long>(selectedRows.size());
        if (selectedRows.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AbstractTmcListPlugin_0", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
        } else {
            for (ListSelectedRow listSelectedRowValue : selectedRows) {
                idList.add((Long)listSelectedRowValue.getPrimaryKeyValue());
            }
        }
        String property = System.getProperty("unit_test");
        if (EmptyUtil.isNoEmpty((String)property) && "tmc".equals(property) && this.getPageCache().getAll().containsKey("ids")) {
            idList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("ids"), List.class);
        }
        return idList;
    }

    protected Long getSelectedId() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AbstractTmcListPlugin_0", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            return null;
        }
        HashSet<Long> idSet = new HashSet<Long>(selectedRows.size());
        for (int i = 0; i < selectedRows.size(); ++i) {
            idSet.add((Long)selectedRows.get(i).getPrimaryKeyValue());
        }
        if (idSet.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u8fdb\u884c\u5904\u7406\u3002", (String)"AbstractTmcListPlugin_1", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            return null;
        }
        return (Long)selectedRows.get(0).getPrimaryKeyValue();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initToolButtonStatus();
    }

    protected void initToolButtonStatus() {
    }

    protected ShowType showModel() {
        return ShowType.MainNewTabPage;
    }

    protected boolean disableDoubleClick() {
        return false;
    }

    protected String getDataEntityName() {
        BillList billList = (BillList)this.getControl("billlistap");
        return billList.getEntityType().getName();
    }

    protected String getPermissionItem() {
        String permItem = this.getView().getFormShowParameter().getPermissionItemId();
        if (EmptyUtil.isEmpty((String)permItem)) {
            permItem = "47150e89000000ac";
        }
        return permItem;
    }

    protected String getBillFormId() {
        BillList billList = (BillList)this.getControl("billlistap");
        return billList.getBillFormId();
    }
}

