/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.list.preint;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.preint.TmcNavAddNewBillParam;

public abstract class AbstractTmcIntBillNavAddNewPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    protected static final String PROP_LOANBILL = "loanbill";
    private TmcNavAddNewBillParam param = null;

    public void registerListener(EventObject e) {
        String showBillPropName = this.getParam().getBillPropName();
        if (StringUtils.isNotEmpty((CharSequence)showBillPropName)) {
            this.addClickListeners(new String[]{showBillPropName});
        }
        BasedataEdit company = (BasedataEdit)this.getControl("company");
        company.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initFilterView();
    }

    public void initFilterView() {
        Map customParam = this.getView().getFormShowParameter().getCustomParams();
        Object initParams = customParam.get("initParams");
        if (EmptyUtil.isNoEmpty(initParams)) {
            Map params = (Map)initParams;
            if (params.containsKey("bizdate")) {
                this.getModel().setValue("bizdate", (Object)DateUtils.stringToDate((String)((String)params.get("bizdate")), (String)"yyyy-MM-dd"));
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"bizdate"});
                this.getView().updateView("bizdate");
            }
            if (params.containsKey("orgs")) {
                Set orgs = (Set)SerializationUtils.fromJsonString((String)params.get("orgs").toString(), Set.class);
                this.getModel().setValue("company", (Object)orgs.stream().map(s -> Long.parseLong(s.toString())).toArray());
                this.getView().updateView("company");
            }
            if (params.containsKey("currencys")) {
                Set currencys = (Set)SerializationUtils.fromJsonString((String)params.get("currencys").toString(), Set.class);
                this.getModel().setValue("currency", (Object)currencys.stream().map(s -> Long.parseLong(s.toString())).toArray());
                this.getView().updateView("currency");
            }
        }
    }

    private TmcNavAddNewBillParam getParam() {
        if (this.param == null) {
            this.param = this.getNavAddNewBillParam();
        }
        return this.param;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (operateKey.equals("next")) {
            TmcNavAddNewBillParam tmcNavAddNewBillParam = this.getParam();
            List<Object> loanBillIds = this.beforeCalcInterest(tmcNavAddNewBillParam);
            Map<Object, IntBillInfo> calcInterests = this.calcInterest(tmcNavAddNewBillParam, loanBillIds);
            this.validateIntInfo(args, calcInterests);
            if (!args.isCancel()) {
                this.getPageCache().put("calcIntResult", JSON.toJSONString(calcInterests));
            }
        }
    }

    protected List<Object> beforeCalcInterest(TmcNavAddNewBillParam tmcNavAddNewBillParam) {
        return Collections.EMPTY_LIST;
    }

    protected abstract Map<Object, IntBillInfo> calcInterest(TmcNavAddNewBillParam var1, List<Object> var2);

    public void afterDoOperation(AfterDoOperationEventArgs evtArgs) {
        if (StringUtils.equals((CharSequence)"next", (CharSequence)evtArgs.getOperateKey()) && evtArgs.getOperationResult().isSuccess()) {
            this.getView().returnDataToParent(this.getNavFilterMap());
            this.getView().close();
        }
    }

    protected Map<String, Object> getNavFilterMap() {
        return new HashMap<String, Object>(16);
    }

    public void click(EventObject evt) {
        TmcNavAddNewBillParam tmcNavAddNewBillParam;
        String billPropName;
        super.click(evt);
        if (!(evt.getSource() instanceof Control)) {
            return;
        }
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals(billPropName = (tmcNavAddNewBillParam = this.getParam()).getBillPropName())) {
            this.showSelectBillF7(billPropName, tmcNavAddNewBillParam);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String property;
        switch (property = evt.getProperty().getName()) {
            case "company": {
                this.initCompanyFilter(evt);
                break;
            }
        }
    }

    protected abstract TmcNavAddNewBillParam getNavAddNewBillParam();

    private void showSelectBillF7(String billPropName, TmcNavAddNewBillParam tmcNavAddNewBillParam) {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)tmcNavAddNewBillParam.getBillEntityName(), (boolean)tmcNavAddNewBillParam.isMultiSelect(), (int)0, (boolean)true);
        parameter.getListFilterParameter().getQFilters().add(this.buildSelectBillFilter());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, TmcNavAddNewBillParam.getActionId(billPropName)));
        if (tmcNavAddNewBillParam.getCustomParamName() != null) {
            parameter.setCustomParam(tmcNavAddNewBillParam.getCustomParamName(), tmcNavAddNewBillParam.getCustomParamValue());
        }
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void initCompanyFilter(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        List<Long> authOrgIds = this.getAuthOrgIds();
        if (EmptyUtil.isEmpty(authOrgIds)) {
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "=", (Object)0));
        } else {
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", authOrgIds));
        }
    }

    private void validateIntInfo(BeforeDoOperationEventArgs args, Map<Object, IntBillInfo> calcInterests) {
        if (null == calcInterests || calcInterests.size() == 0) {
            this.getView().showErrorNotification(this.getNonIntDataTip());
            args.setCancel(true);
            return;
        }
    }

    private List<Long> getAuthOrgIds() {
        String appId = this.getView().getFormShowParameter().getAppId();
        String entity = (String)this.getView().getFormShowParameter().getCustomParam("entity");
        List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)entity, (String)"47150e89000000ac");
        return comIdList;
    }

    protected abstract QFilter buildSelectBillFilter();

    public abstract String getNonIntDataTip();

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        ListSelectedRowCollection selectedRow = (ListSelectedRowCollection)evt.getReturnData();
        String billPropName = this.getParam().getBillPropName();
        if (StringUtils.equals((CharSequence)TmcNavAddNewBillParam.getActionId(billPropName), (CharSequence)actionId) && EmptyUtil.isNoEmpty((Object)selectedRow)) {
            this.afterSelectBillData(selectedRow);
        }
    }

    protected void afterSelectBillData(ListSelectedRowCollection selectedRow) {
        String billPropName = this.getParam().getBillPropName();
        List billIds = selectedRow.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        List billnos = selectedRow.stream().map(ListSelectedRow::getBillNo).collect(Collectors.toList());
        this.getModel().setValue(billPropName, (Object)String.join((CharSequence)";", billnos));
        this.getPageCache().put(billPropName, SerializationUtils.toJsonString(billIds));
    }
}

