/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.tool;

import java.security.SecureRandom;
import java.util.Collection;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TmcCopyDataPlugin
extends AbstractFormPlugin
implements ItemClickListener,
ClickListener {
    private static final Log logger = LogFactory.getLog(TmcCopyDataPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"select"});
    }

    public void click(EventObject evt) {
        switch (((Control)evt.getSource()).getKey()) {
            case "select": {
                this.selectShow();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (key = op.getOperateKey()) {
            case "copy": {
                this.execute();
            }
        }
    }

    private void execute() {
        TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)true, (String[])new String[]{"sourcebill", "select"});
        DynamicObject sourceBill = (DynamicObject)this.getModel().getValue("sourcebill");
        String formid = sourceBill.getString("number");
        MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)formid);
        Long id = Long.valueOf((String)this.getModel().getValue("select"));
        DynamicObject bill = TmcDataServiceHelper.loadSingle((Object)id, (String)formid);
        int count = (Integer)this.getModel().getValue("count");
        DynamicObjectCollection colls = new DynamicObjectCollection();
        for (int index = 0; index < count; ++index) {
            String ramprops;
            DynamicObject copy = TmcDataServiceHelper.clone((DynamicObject)bill);
            Boolean isramnumber = (Boolean)this.getModel().getValue("isramnumber");
            if (isramnumber.booleanValue()) {
                if (mainEntity instanceof BillEntityType) {
                    copy.set(((BillEntityType)mainEntity).getBillNo(), (Object)("Tmc-Copy-" + this.genRandom()));
                } else {
                    copy.set("number", (Object)("Tmc-Copy-" + this.genRandom()));
                }
            }
            if (EmptyUtil.isNoEmpty((String)(ramprops = (String)this.getModel().getValue("ramprops")))) {
                String[] props;
                for (String prop : props = ramprops.split(",")) {
                    copy.set(prop, (Object)(copy.get(prop) + String.valueOf(this.genRandom())));
                }
            }
            int entc = (Integer)this.getModel().getValue("entc");
            String entprop = (String)this.getModel().getValue("entprop");
            if (EmptyUtil.isNoEmpty((String)entprop) && entc > 0) {
                DynamicObjectCollection entrys = copy.getDynamicObjectCollection(entprop);
                DynamicObject entry = (DynamicObject)entrys.get(0);
                for (int i = 0; i < entc; ++i) {
                    DynamicObject copye = TmcDataServiceHelper.clone((DynamicObject)entry);
                    entrys.add((Object)copye);
                }
            }
            colls.add((Object)copy);
            if (colls.size() < 1000) continue;
            TmcDataServiceHelper.save((DynamicObject[])((DynamicObject[])colls.toArray((Object[])new DynamicObject[colls.size()])));
            colls.removeAll((Collection)colls);
        }
        if (colls.size() > 0) {
            TmcDataServiceHelper.save((DynamicObject[])((DynamicObject[])colls.toArray((Object[])new DynamicObject[colls.size()])));
        }
    }

    private int genRandom() {
        try {
            return SecureRandom.getInstance("SHA1PRNG").nextInt(1000000);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return 0;
        }
    }

    private void selectShow() {
        DynamicObject sourceBill = (DynamicObject)this.getModel().getValue("sourcebill");
        String formid = sourceBill.getString("number");
        ListShowParameter param = ShowFormHelper.createShowListForm((String)formid, (boolean)false, (int)2);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "sourcebill");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)param);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("sourcebill".equals(e.getActionId()) && e.getReturnData() != null) {
            ListSelectedRowCollection coreBillCollection = (ListSelectedRowCollection)e.getReturnData();
            this.getModel().setValue("select", coreBillCollection.get(0).getPrimaryKeyValue());
        }
    }
}

