/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.tool;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcAttachmentHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TmcExecuteToolPlugin
extends AbstractFormPlugin
implements ItemClickListener,
ClickListener {
    private static final Log logger = LogFactory.getLog(TmcExecuteToolPlugin.class);
    private static final String innerAcctService = "innerAcctBalService";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_dowm", "btnbuild", "btnbuildall"});
    }

    public void click(EventObject evt) {
        switch (((Control)evt.getSource()).getKey()) {
            case "btnbuild": {
                this.buildInnerAcctBalance();
                break;
            }
            case "btnbuildall": {
                this.buildBalanceAll();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        switch (e.getProperty().getName()) {
            case "stream": {
                if (((Boolean)this.getModel().getValue("stream")).booleanValue()) {
                    String className = (String)this.getModel().getValue("textinput");
                    className = className.replaceAll("\\.", "/");
                    this.getModel().setValue("path", (Object)(className + ".class"));
                    break;
                }
                String className = (String)this.getModel().getValue("textinput");
                try {
                    Class<?> cls = Class.forName(className);
                    String f2 = cls.getProtectionDomain().getCodeSource().getLocation().getFile().substring(1);
                    this.getModel().setValue("path", (Object)f2);
                }
                catch (Exception ex) {
                    this.getView().showErrorNotification(ex.getMessage());
                }
                break;
            }
            case "settlecenter": {
                this.settleCenterChanged(e);
            }
        }
    }

    private void settleCenterChanged(PropertyChangedArgs e) {
        Object settlecenterId = ((DynamicObject)this.getModel().getValue("settlecenter")).getPkValue();
        QFilter sQFilter = new QFilter("settlecenter.id", "=", settlecenterId);
        DynamicObject scSetting = QueryServiceHelper.queryOne((String)"ifm_settcentersetting", (String)"acceptdate", (QFilter[])sQFilter.toArray());
        if (scSetting != null) {
            this.getModel().setValue("acceptdate", (Object)scSetting.getDate("acceptdate"));
            this.getModel().setValue("begindate", (Object)scSetting.getDate("acceptdate"));
        }
        BillList billlistap = (BillList)this.getControl("billlistap");
        billlistap.getQueryFilterParameter().setFilter(new QFilter("finorg.id", "=", settlecenterId));
        billlistap.refresh();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (key = op.getOperateKey()) {
            case "execute": {
                this.execute();
                break;
            }
            case "download": {
                this.downLoad();
                break;
            }
            case "test": {
                this.test();
                break;
            }
            case "help": {
                this.help();
            }
        }
    }

    private void execute() {
        Tab tabap = (Tab)this.getView().getControl("tab");
        switch (tabap.getCurrentTab()) {
            case "runtimetab": {
                this.showLib();
                break;
            }
            case "tabbank": {
                this.queryBankStatus();
            }
        }
    }

    private void queryBankStatus() {
        String bankEntity = (String)this.getModel().getValue("bankentity");
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{bankEntity, startDate, endDate})) {
            String selectBankField = "id,billno,sourcebillid,srcbilltype";
            String bankpaystate = "bankpaystate";
            if ("bei_bankagentpay".equals(bankEntity)) {
                bankpaystate = "paystate";
                selectBankField = "id,billno,sourcebillid,'cas_agentpaybill' as srcbilltype";
            } else if ("bei_banktransupbill".equals(bankEntity)) {
                bankpaystate = "paystate";
                selectBankField = "id,billno,sourcebillid,'fca_transupbill' as srcbilltype";
            } else if ("bei_banktransdownbill".equals(bankEntity)) {
                bankpaystate = "paystate";
                selectBankField = "id,billno,sourcebillid,'fca_transdownbill' as srcbilltype";
            }
            QFilter filter = new QFilter(bankpaystate, "=", (Object)"TS");
            filter.and("createtime", ">=", (Object)startDate);
            filter.and("createtime", "<=", (Object)endDate);
            DynamicObjectCollection query = QueryServiceHelper.query((String)bankEntity, (String)selectBankField, (QFilter[])filter.toArray());
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)query)) {
                Map<String, List<DynamicObject>> srcBillMap = query.stream().collect(Collectors.groupingBy(s -> s.getString("srcbilltype")));
                Map<Long, List<DynamicObject>> srcBillMapId = query.stream().collect(Collectors.groupingBy(s -> s.getLong("sourcebillid")));
                ArrayList<DynamicObjectCollection> recordList = new ArrayList<DynamicObjectCollection>(10);
                for (Map.Entry<String, List<DynamicObject>> entry : srcBillMap.entrySet()) {
                    String entryKey = entry.getKey();
                    if (EmptyUtil.isEmpty((String)entryKey)) continue;
                    List<DynamicObject> value = entry.getValue();
                    Set ids = value.stream().map(s -> s.getLong("sourcebillid")).collect(Collectors.toSet());
                    QFilter qFilter = new QFilter("id", "in", ids);
                    String billstatus = "billstatus";
                    if ("ifm_transhandlebill".equals(entryKey)) {
                        billstatus = "paidstatus";
                    }
                    qFilter.and(billstatus, "!=", (Object)"D");
                    DynamicObjectCollection srcBills = QueryServiceHelper.query((String)entryKey, (String)("id,billno," + billstatus + " as billstatus"), (QFilter[])qFilter.toArray());
                    if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)srcBills)) continue;
                    recordList.add(srcBills);
                }
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.deleteEntryData("entryentity");
                if (recordList.size() > 0) {
                    model.beginInit();
                    TableValueSetter vs = new TableValueSetter(new String[0]);
                    vs.addField("bankid", new Object[0]);
                    vs.addField("bankbillno", new Object[0]);
                    vs.addField("srcentity", new Object[0]);
                    vs.addField("srcid", new Object[0]);
                    vs.addField("srcbillno", new Object[0]);
                    vs.addField("srcstatus", new Object[0]);
                    for (DynamicObjectCollection srcBills : recordList) {
                        for (DynamicObject srcBill : srcBills) {
                            List<DynamicObject> destBills = srcBillMapId.get(srcBill.getLong("id"));
                            DynamicObject destBill = destBills.get(0);
                            vs.addRow(new Object[]{destBill.getLong("id"), destBill.get("billno"), destBill.get("srcbilltype"), srcBill.getLong("id"), srcBill.get("billno"), srcBill.get("billstatus")});
                        }
                    }
                    model.batchCreateNewEntryRow("entryentity", vs);
                    model.endInit();
                }
                this.getView().updateView("entryentity");
            }
        }
    }

    private void test() {
        TmcOperateServiceHelper.execOperate((String)"test", (String)"fcs_test", (Object[])new Long[]{1234567L}, (OperateOption)OperateOption.create());
    }

    private void showLib() {
        StringBuilder builder = new StringBuilder();
        String className = (String)this.getModel().getValue("textinput");
        try {
            Class<?> cls = Class.forName(className);
            String f1 = cls.getResource("").getPath() + cls.getSimpleName() + ".class";
            builder.append(f1).append(System.lineSeparator());
            String f2 = cls.getProtectionDomain().getCodeSource().getLocation().getFile().substring(1);
            builder.append(f2).append(System.lineSeparator());
            this.getModel().setValue("path", (Object)f2);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
        this.getModel().setValue("textresult", (Object)builder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downLoad() {
        InputStream is = null;
        try {
            String path = (String)this.getModel().getValue("path");
            try {
                is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(path);
                if (is == null) {
                    is = new FileInputStream(path);
                }
            }
            catch (Exception ex) {
                is = new FileInputStream(path);
            }
            String[] paths = path.split("/");
            Map aut = TmcAttachmentHelper.newModelTempFile((String)paths[paths.length - 1], null, (InputStream)is, (String)DBServiceHelper.genStringId(), (String)"");
            this.getView().download(aut.get("url").toString());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            is = null;
        }
    }

    private void buildInnerAcctBalance() {
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        List innerAcctIds = Arrays.stream(selectedRows.getPrimaryKeyValues()).map(v -> (Long)v).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(innerAcctIds)) {
            Date beginDate = (Date)this.getModel().getValue("begindate");
            TmcExecuteToolPlugin.invokeBizService(innerAcctService, TmcAppEnum.IFM.getValue(), "rebuilBalanceByInnerId", innerAcctIds, beginDate, null);
        }
    }

    private void buildBalanceAll() {
        TmcExecuteToolPlugin.invokeBizService(innerAcctService, TmcAppEnum.IFM.getValue(), "rebuildAllBalance", new Object[0]);
    }

    private static Object invokeBizService(String service, String appid, String method, Object ... param) {
        return DispatchServiceHelper.invokeBizService((String)TmcAppEnum.TMC.getValue(), (String)appid, (String)service, (String)method, (Object[])param);
    }

    private void help() {
    }
}

