/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.ebservice.enums;

import kd.bos.exception.ErrorCode;
import kd.tmc.fbp.common.enums.MultiLangEnumBridge;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.enums.EBExceptionSolutionEnum;
import kd.tmc.fbp.service.ebservice.errorcode.ErrorCodeUtils;

public enum EBExceptionMsgEnum {
    EBGCLOUD_KD_000001("ebgcloud_kd_000001", "ebgcloud_kd_000001", new MultiLangEnumBridge("\u94f6\u4f01\u4e91\u5ba2\u6237\u8ba4\u8bc1\u4fe1\u606f\uff08CA\u8bc1\u4e66\uff09\u4e0d\u5b58\u5728\u3002", "EBErrorCodeStatusEnum_1", "tmc-fbp-mservice"), EBExceptionSolutionEnum.EBGCLOUD_KD_000001_SOLUTION),
    EBGCLOUD_KD_000002("ebgcloud_kd_000002", "ebgcloud_kd_000001", new MultiLangEnumBridge("\u94f6\u4f01\u4e91\u5ba2\u6237\u8ba4\u8bc1\u4fe1\u606f\uff08CA\u8bc1\u4e66\uff09\u5df2\u8fc7\u671f\u3002", "EBErrorCodeStatusEnum_2", "tmc-fbp-mservice"), EBExceptionSolutionEnum.EBGCLOUD_KD_000002_SOLUTION),
    EBGCLOUD_KD_000003("ebgcloud_kd_000003", "ebgcloud_kd_000001", new MultiLangEnumBridge("\u94f6\u4f01\u54cd\u5e94\u62a5\u6587\u89e3\u5bc6\uff0c\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25\u3002", "EBErrorCodeStatusEnum_3", "tmc-fbp-mservice"), EBExceptionSolutionEnum.EBGCLOUD_KD_000003_SOLUTION),
    EBGCLOUD_KD_000003_API("ebgcloud_kd_000003_api", "ebgcloud_kd_000003_api", new MultiLangEnumBridge("\u94f6\u4f01\u54cd\u5e94\u62a5\u6587\u89e3\u5bc6\uff0c\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25\u3002", "EBErrorCodeStatusEnum_3", "tmc-fbp-mservice"), EBExceptionSolutionEnum.EBGCLOUD_KD_000003_API_SOLUTION),
    EBGCLOUD_KD_000004_API("ebgcloud_kd_000004_api", "ebgcloud_kd_000004_api", new MultiLangEnumBridge("\u8bf7\u6c42\u5ba2\u6237ID\u53f7\u4e0e\u5f53\u524d\u79df\u6237\u4e0d\u5339\u914d\u3002", "EBErrorCodeStatusEnum_6", "tmc-fbp-mservice"), EBExceptionSolutionEnum.EBGCLOUD_KD_000004_SOLUTION),
    PASSWORD_ERROR("password_error", "keystore password was incorrect", new MultiLangEnumBridge(), EBExceptionSolutionEnum.PASSWORD_ERROR_SOLUTION),
    DER_ERROR("password_error", "DER input, Integer tag error", new MultiLangEnumBridge(), EBExceptionSolutionEnum.DER_ERROR_SOLUTION),
    URL_ERROR("url_error", "url_error", new MultiLangEnumBridge(), EBExceptionSolutionEnum.URL_ERROR_SOLUTION),
    ACCTOKEN_ERROR("acctoken_error", "acctoken_error", new MultiLangEnumBridge("\u767b\u5f55\u914d\u7f6e\u4e2d\u5b58\u5728\u4e0d\u6b63\u786e\u7684\u5f00\u653e\u5e73\u53f0\u8ba4\u8bc1\u7cfb\u7edf\u7f16\u7801 \u6216 Access Token\u52a0\u5bc6\u8ba4\u8bc1\u79d8\u94a5\u3002", "EBErrorCodeStatusEnum_4", "tmc-fbp-mservice"), EBExceptionSolutionEnum.ACCTOKEN_ERROR_SOLUTION),
    USER_ERROR("user_error", "user_error", new MultiLangEnumBridge("\u767b\u5f55\u914d\u7f6e\u4e2d\u5b58\u5728\u4e0d\u6b63\u786e\u7684\u7528\u6237\u7c7b\u578b\u6216\u7528\u6237\u540d\u3002", "EBErrorCodeStatusEnum_5", "tmc-fbp-mservice"), EBExceptionSolutionEnum.USER_ERROR_SOLUTION);

    private final String errorCode;
    private final String message;
    private final MultiLangEnumBridge errorTip;
    private final EBExceptionSolutionEnum solution;

    private EBExceptionMsgEnum(String errorCode, String message, MultiLangEnumBridge errorTip, EBExceptionSolutionEnum solution) {
        this.errorCode = errorCode;
        this.message = message;
        this.errorTip = errorTip;
        this.solution = solution;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getMessage() {
        return this.message;
    }

    public String getErrorMsg(String message) {
        if (EmptyUtil.isNoEmpty((String)message)) {
            return message + "\u201d" + this.solution.getSolution();
        }
        return this.errorTip.loadKDString() + "\u201d" + this.solution.getSolution();
    }

    public static ErrorCode getErrorCode(String value) {
        ErrorCode errorCode = null;
        for (EBExceptionMsgEnum status : EBExceptionMsgEnum.values()) {
            if (!status.getErrorCode().equals(value)) continue;
            errorCode = ErrorCodeUtils.create(status.errorCode, status.getErrorMsg(null));
            break;
        }
        return errorCode;
    }

    public static ErrorCode getErrorCodeByCode(boolean isApi, String errorCode) {
        if (errorCode.contains(":")) {
            String code = errorCode.split(":")[0];
            if (isApi) {
                code = code + "_api";
            }
            return EBExceptionMsgEnum.getErrorCode(code);
        }
        return EBExceptionMsgEnum.getErrorCode(EBGCLOUD_KD_000003.getErrorCode());
    }

    public static ErrorCode getErrorCodeWithMessage(String message, String errorMessage) {
        ErrorCode errorCode = null;
        for (EBExceptionMsgEnum status : EBExceptionMsgEnum.values()) {
            if (EmptyUtil.isNoEmpty((String)message) && status.getMessage().equals(message)) {
                errorCode = ErrorCodeUtils.create(status.errorCode, status.getErrorMsg(errorMessage));
                break;
            }
            if (!status.getMessage().equals(errorMessage)) continue;
            errorCode = ErrorCodeUtils.create(status.errorCode, status.getErrorMsg(errorMessage));
            break;
        }
        return errorCode;
    }
}

