/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.ebservice.http;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.service.ebservice.errorcode.BeErrorCode;
import kd.tmc.fbp.service.ebservice.exception.EBConnectException;
import kd.tmc.fbp.service.ebservice.http.IEBRequestHandler;
import kd.tmc.fbp.service.ebservice.http.impl.NewEBRequestHandler;
import kd.tmc.fbp.service.ebservice.http.impl.OldEBRequestHandler;
import kd.tmc.fbp.service.ebservice.http.impl.RPCRequestHandler;
import kd.tmc.fbp.service.ebservice.log.BankLogService;
import kd.tmc.fbp.service.ebservice.service.IEBService;

public class EBRequestHandlerFactory {
    private static final Log logger = LogFactory.getLog(EBRequestHandlerFactory.class);
    private static final List<String> NEW_BIZ_ENTITY = Stream.of("bei_elecbalancestate", "bei_elecbalancestate_acc").collect(Collectors.toList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> IEBRequestHandler getEBRequestHandler(BankLogService log, IEBService<R> service) {
        Class<EBRequestHandlerFactory> clazz = EBRequestHandlerFactory.class;
        synchronized (EBRequestHandlerFactory.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return EBRequestHandlerFactory.getOldOrNewEBRequestHandler(log, service);
        }
    }

    private static <R> IEBRequestHandler getOldOrNewEBRequestHandler(BankLogService log, IEBService<R> service) {
        QFilter qFilter = new QFilter("isenable", "=", (Object)Boolean.TRUE);
        qFilter.or(new QFilter("isenable2", "=", (Object)Boolean.TRUE));
        DynamicObject serviceConfig = TmcDataServiceHelper.loadSingleFromCache((String)"bei_serviceconfig", (String)"id, customerid, cafile_tag, customerprivatekey, serveraddress,isenable,serveraddress2,isenable2,appscope_entity.e_bankcgno,isopenapi", (QFilter[])new QFilter[]{qFilter});
        if (serviceConfig == null) {
            throw new EBConnectException(new BeErrorCode().BE5000());
        }
        if (serviceConfig.getBoolean("isenable") && serviceConfig.getBoolean("isenable2")) {
            DynamicObjectCollection dynamicObjectCollection = serviceConfig.getDynamicObjectCollection("appscope_entity");
            if (dynamicObjectCollection.size() > 0) {
                Set appScopes = dynamicObjectCollection.stream().map(o -> o.getDynamicObject("e_bankcgno").getLong("id")).collect(Collectors.toSet());
                Long bankCateId = service.getBankCateId();
                if (NEW_BIZ_ENTITY.contains(service.getEntityName()) || appScopes.contains(bankCateId)) {
                    if (!serviceConfig.getBoolean("isopenapi")) {
                        return new RPCRequestHandler(log);
                    }
                    return new NewEBRequestHandler(log);
                }
                return new OldEBRequestHandler(log);
            }
            if (!serviceConfig.getBoolean("isopenapi")) {
                return new RPCRequestHandler(log);
            }
            return new NewEBRequestHandler(log);
        }
        if (serviceConfig.getBoolean("isenable2")) {
            DynamicObjectCollection dynamicObjectCollection = serviceConfig.getDynamicObjectCollection("appscope_entity");
            if (dynamicObjectCollection.size() > 0) {
                Set appScopes = dynamicObjectCollection.stream().map(o -> o.getDynamicObject("e_bankcgno").getLong("id")).collect(Collectors.toSet());
                Long bankCateId = service.getBankCateId();
                if (NEW_BIZ_ENTITY.contains(service.getEntityName()) || appScopes.contains(bankCateId)) {
                    if (!serviceConfig.getBoolean("isopenapi")) {
                        return new RPCRequestHandler(log);
                    }
                    return new NewEBRequestHandler(log);
                }
                throw new EBConnectException(new BeErrorCode().CONFIG_NOTFOUND_ERROR());
            }
            if (!serviceConfig.getBoolean("isopenapi")) {
                return new RPCRequestHandler(log);
            }
            return new NewEBRequestHandler(log);
        }
        if (serviceConfig.getBoolean("isenable")) {
            return new OldEBRequestHandler(log);
        }
        throw new EBConnectException(new BeErrorCode().CONFIG_NOTFOUND_ERROR());
    }
}

