/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.ebservice.http;

import java.util.Locale;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.service.ebservice.errorcode.EBErrorCode;
import kd.tmc.fbp.service.ebservice.exception.EBBizNCException;
import kd.tmc.fbp.service.ebservice.utils.SSLClient;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

public class HttpHelper {
    private static Log logger = LogFactory.getLog(HttpHelper.class);

    public String post(String url, String bodyJson, int timeout) {
        return HttpHelper.doPost(url, bodyJson, timeout);
    }

    public static String doPost(String url, String bodyJson, int timeout) {
        String string;
        long beginTime = System.currentTimeMillis();
        boolean withExc = false;
        try {
            String body;
            System.setProperty("javax.net.debug", "ssl");
            BasicHttpParams httpParams = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)5000);
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)timeout);
            SSLClient httpClient = null;
            httpClient = url.toLowerCase(Locale.ENGLISH).startsWith("https://") ? new SSLClient((HttpParams)httpParams) : new DefaultHttpClient((HttpParams)httpParams);
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Content-Type", "application/json; charset=UTF-8");
            StringEntity se = new StringEntity(bodyJson, "UTF-8");
            se.setContentType("text/json");
            se.setContentEncoding((Header)new BasicHeader("Content-Type", "application/json; charset=UTF-8"));
            httpPost.setEntity((HttpEntity)se);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new EBBizNCException(new EBErrorCode().CONNECT(), new String[]{String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u54cd\u5e94\u7801\uff1a%s", (String)"HttpHelper_0", (String)"tmc-fbp-mservice", (Object[])new Object[0]), statusCode)});
            }
            string = body = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (Exception e) {
            try {
                withExc = true;
                String s = e.getMessage();
                if (s == null) {
                    s = e.getCause() != null ? e.getCause().getMessage() : e.toString();
                }
                throw new EBBizNCException(e, new EBErrorCode().UNKNOW(), s);
            }
            catch (Throwable throwable) {
                System.clearProperty("javax.net.debug");
                long endTime = System.currentTimeMillis();
                if (withExc) {
                    logger.info(String.format("Http exception request\uff0ccost time\uff1a%sms", endTime - beginTime));
                } else {
                    logger.info(String.format("Http normal request\uff0ccost time\uff1a%sms", endTime - beginTime));
                }
                throw throwable;
            }
        }
        System.clearProperty("javax.net.debug");
        long endTime = System.currentTimeMillis();
        if (withExc) {
            logger.info(String.format("Http exception request\uff0ccost time\uff1a%sms", endTime - beginTime));
        } else {
            logger.info(String.format("Http normal request\uff0ccost time\uff1a%sms", endTime - beginTime));
        }
        return string;
    }
}

