/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.ebservice.http;

import java.net.ConnectException;
import java.util.Locale;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.service.ebservice.enums.EBExceptionMsgEnum;
import kd.tmc.fbp.service.ebservice.errorcode.EBErrorCode;
import kd.tmc.fbp.service.ebservice.exception.EBBizNCException;
import kd.tmc.fbp.service.ebservice.exception.EBConnectException;
import kd.tmc.fbp.service.ebservice.utils.CommonUtils;
import kd.tmc.fbp.service.ebservice.utils.SSLClient;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

public class NewHttpHelper {
    private static final Log logger = LogFactory.getLog(NewHttpHelper.class);

    public static String tokenPost(String url, String data) throws ConnectException {
        logger.info("tokenPost url =" + url);
        logger.info("tokenPost data =" + CommonUtils.prettyJson(data));
        try {
            BasicHttpParams httpParams = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)5000);
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)5000);
            SSLClient httpClient = null;
            if (url.toLowerCase(Locale.ENGLISH).startsWith("https://")) {
                logger.info("tokenPost use ssl");
                httpClient = new SSLClient((HttpParams)httpParams);
            } else {
                logger.info("tokenPost use nonssl");
                httpClient = new DefaultHttpClient((HttpParams)httpParams);
            }
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Content-Type", "application/json; charset=UTF-8");
            StringEntity se = new StringEntity(data, "UTF-8");
            se.setContentType("text/json");
            se.setContentEncoding((Header)new BasicHeader("Content-Type", "application/json; charset=UTF-8"));
            httpPost.setEntity((HttpEntity)se);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                logger.info("http response status code:" + statusCode);
                throw new EBConnectException(new EBErrorCode().CONNECT_ERROR(), new String[]{String.valueOf(statusCode)});
            }
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            logger.info("tokenPost response body =" + body);
            return body;
        }
        catch (Exception e) {
            logger.error(" ===== tokenPost() ERROR ===== " + e.getMessage());
            throw new EBConnectException(e, new EBErrorCode().CONNECT_ERROR(), e.getMessage());
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String post(String url, String bodyJson, String accessToken, int timeout) {
        String string;
        long beginTime = System.currentTimeMillis();
        boolean withExc = false;
        try {
            BasicHttpParams httpParams = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)5000);
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)timeout);
            SSLClient httpClient = null;
            httpClient = url.toLowerCase(Locale.ENGLISH).startsWith("https://") ? new SSLClient((HttpParams)httpParams) : new DefaultHttpClient((HttpParams)httpParams);
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Content-Type", "application/json; charset=UTF-8");
            httpPost.addHeader("accessToken", accessToken);
            httpPost.addHeader("api", "true");
            StringEntity se = new StringEntity(bodyJson, "UTF-8");
            se.setContentType("text/json");
            se.setContentEncoding((Header)new BasicHeader("Content-Type", "application/json; charset=UTF-8"));
            httpPost.setEntity((HttpEntity)se);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                logger.info("http response status code:" + statusCode);
                switch (statusCode) {
                    case 404: 
                    case 500: 
                    case 501: 
                    case 502: 
                    case 503: {
                        throw new EBConnectException(new EBErrorCode().CONNECT_ERROR(), new String[]{String.valueOf(statusCode)});
                    }
                }
                throw new EBBizNCException(new EBErrorCode().CONNECT_ERROR(), new String[]{String.valueOf(statusCode)});
            }
            string = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (ConnectTimeoutException e) {
            try {
                withExc = true;
                throw new EBConnectException(new EBErrorCode().CONNECT_ERROR(), new String[]{e.getMessage()});
                catch (EBConnectException e2) {
                    withExc = true;
                    throw e2;
                }
                catch (Exception e3) {
                    withExc = true;
                    logger.error(" =====http.post() ERROR ===== " + ExceptionUtils.getExceptionStackTraceMessage((Exception)e3));
                    String s = e3.getMessage();
                    if (s == null) {
                        s = e3.getCause() != null ? e3.getCause().getMessage() : e3.toString();
                    }
                    ErrorCode errorCode = EBExceptionMsgEnum.getErrorCodeWithMessage("url_error", s);
                    throw new EBBizNCException(e3, errorCode, new Object[0]);
                }
            }
            catch (Throwable throwable) {
                long endTime = System.currentTimeMillis();
                if (withExc) {
                    logger.error(String.format("Http exception request\uff0ccost time\uff1a%sms", endTime - beginTime));
                    throw throwable;
                }
                logger.info(String.format("Http normal request\uff0ccost time\uff1a%sms", endTime - beginTime));
                throw throwable;
            }
        }
        long endTime = System.currentTimeMillis();
        if (withExc) {
            logger.error(String.format("Http exception request\uff0ccost time\uff1a%sms", endTime - beginTime));
            return string;
        }
        logger.info(String.format("Http normal request\uff0ccost time\uff1a%sms", endTime - beginTime));
        return string;
    }
}

