/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.ebservice.http.impl;

import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.enums.AlgorithmEnum;
import kd.tmc.fbp.service.ebservice.enums.EBExceptionMsgEnum;
import kd.tmc.fbp.service.ebservice.errorcode.EBBizErrorCode;
import kd.tmc.fbp.service.ebservice.errorcode.EBErrorCode;
import kd.tmc.fbp.service.ebservice.exception.BESecurityException;
import kd.tmc.fbp.service.ebservice.exception.EBAuthException;
import kd.tmc.fbp.service.ebservice.exception.EBBizNCException;
import kd.tmc.fbp.service.ebservice.exception.EBConnectException;
import kd.tmc.fbp.service.ebservice.exception.EBSignException;
import kd.tmc.fbp.service.ebservice.http.IEBRequestHandler;
import kd.tmc.fbp.service.ebservice.http.NewHttpHelper;
import kd.tmc.fbp.service.ebservice.log.BankLogService;
import kd.tmc.fbp.service.ebservice.security.utils.AESDencryptUtil;
import kd.tmc.fbp.service.ebservice.security.utils.AESEncryptUtil;
import kd.tmc.fbp.service.ebservice.security.utils.SignUtil;
import kd.tmc.fbp.service.ebservice.security.utils.VerifySignUtil;
import kd.tmc.fbp.service.ebservice.token.AccessTokenManager;
import kd.tmc.fbp.service.ebservice.utils.CommonUtils;
import kd.tmc.fbp.service.ebservice.utils.JsonUtil;
import kd.tmc.fbp.webapi.ebentity.EBRequest;
import kd.tmc.fbp.webapi.ebentity.api.EBServiceRequest;
import kd.tmc.fbp.webapi.ebentity.api.EBServiceResponse;
import org.apache.commons.lang.RandomStringUtils;

public class NewEBRequestHandler
implements IEBRequestHandler {
    private static Log logger = LogFactory.getLog(NewEBRequestHandler.class);
    private static final String SUCCESS = "success";
    private static final String ACCESS_TOKEN_EXPIRE_TAG = "1";
    private static final IAppCache APP_CACHE = AppCache.get((String)"fbp");
    protected BankLogService log;
    private String customerID2;
    private String serverAddress2;

    public NewEBRequestHandler(BankLogService log) {
        this.log = log;
        log.setComment(ResManager.loadKDString((String)"\u94f6\u4f01\u670d\u52a1Https\u63a5\u53e3\u8c03\u7528", (String)"RPCRequestHandler_2", (String)"tmc-fbp-mservice", (Object[])new Object[0]));
        QFilter qFilter = new QFilter("isenable2", "=", (Object)Boolean.TRUE);
        DynamicObject serviceConfig = TmcDataServiceHelper.loadSingleFromCache((String)"bei_serviceconfig", (String)"id, customerid2, cafile_tag, customerprivatekey, serveraddress2, mcup", (QFilter[])new QFilter[]{qFilter});
        this.serverAddress2 = serviceConfig.getString("serveraddress2");
        this.customerID2 = serviceConfig.getString("customerid2");
    }

    @Override
    public String executeEBRequest(EBRequest request, String serverUrl, int timeout) {
        try {
            logger.info("------begin execute new EBG request------");
            logger.info("serviceConfig==[customerID2=" + this.customerID2 + ",serverAddress2=" + this.serverAddress2 + "]");
            String token = AccessTokenManager.getAccessToken();
            String response = this.getEBResponseData(request, serverUrl, token, timeout, null);
            if (response == null) {
                throw new EBBizNCException(new EBBizErrorCode().RESPONSE_ISNULL());
            }
            this.log.setResponse(response);
            logger.info("-------execute new EBG request end and response success------");
            return response;
        }
        catch (BESecurityException | EBAuthException | EBConnectException | EBSignException e) {
            this.log.setRequestException((Exception)((Object)e));
            logger.info("-------execute new EBG request error-----" + ((Object)((Object)e)).getClass() + "------");
            if (e instanceof EBConnectException) {
                throw new EBConnectException(new EBBizErrorCode().TOKEN_EXCEPTION(), new Object[]{e.getMessage()});
            }
            if (e instanceof EBSignException) {
                throw new EBSignException(new EBBizErrorCode().SIGN(), new Object[]{e.getMessage()});
            }
            throw e;
        }
        catch (Exception e) {
            logger.info("-------execute new EBG request error-otherException" + e.getClass() + "------");
            this.log.setResponseException(e);
            throw e;
        }
    }

    @Override
    public String getCustomerId() {
        return this.customerID2;
    }

    private String getEBResponseData(EBRequest request, String serviceUrl, String token, int timeout, String signAlgorithm) {
        Boolean isFirst = Boolean.TRUE;
        try {
            String errorCode;
            String url = this.serverAddress2 + serviceUrl;
            EBServiceRequest serviceRequest = new EBServiceRequest();
            serviceRequest.setBizType(request.getHeader().getBizType());
            serviceRequest.setCustomerID(this.customerID2);
            serviceRequest.setTimestamp(Long.valueOf(System.currentTimeMillis()));
            serviceRequest.setToken(token);
            if (EmptyUtil.isEmpty((String)signAlgorithm)) {
                signAlgorithm = (String)APP_CACHE.get("beiSignAlgorithm", String.class);
                if (EmptyUtil.isEmpty((String)signAlgorithm)) {
                    signAlgorithm = AlgorithmEnum.SHA256withRSA.getAlgorithm();
                }
            } else {
                isFirst = Boolean.FALSE;
            }
            serviceRequest.setSignAlgorithm(signAlgorithm);
            serviceRequest.setCustomerID(request.getHeader().getCustomId());
            serviceRequest.setData(JsonUtil.toJson(request));
            serviceRequest.setEncryptAlgorithm("AES");
            serviceRequest.setEncryptKey(NewEBRequestHandler.getRandomEncryptKey());
            serviceRequest.setVersion("1.0");
            AESEncryptUtil.setEncrypt(serviceRequest);
            AESEncryptUtil.setEncryptSKey(serviceRequest);
            String signData = SignUtil.signRequest(serviceRequest);
            serviceRequest.setSignData(signData);
            String bodyJson = JsonUtil.toJson(serviceRequest);
            logger.info("getEBResponseData url =" + url);
            logger.info("getEBResponseData request =" + bodyJson);
            String response = NewHttpHelper.post(url, bodyJson, token, timeout);
            logger.info("getEBResponseData response =" + response);
            Map responseMap = JsonUtil.fromJson(response, Map.class);
            boolean isSuccess = Boolean.parseBoolean(responseMap.get(SUCCESS).toString());
            if (!isSuccess && ACCESS_TOKEN_EXPIRE_TAG.equals(errorCode = Objects.toString(responseMap.get("error_code")))) {
                String errorDesc = Objects.toString(responseMap.get("error_desc"));
                AccessTokenManager.removeAccessToken();
                throw new EBBizNCException(new EBBizErrorCode().EB_BIZ_UNAUTHORIZED(), new Object[]{errorDesc});
            }
            ApiResult apiResult = JsonUtil.fromJson(response, ApiResult.class);
            Object dataObj = apiResult.getData();
            if (dataObj == null) {
                throw new EBBizNCException(new EBBizErrorCode().RESPONSE_ISNULL(), new Object[]{apiResult.getMessage()});
            }
            String data = JsonUtil.toJson(dataObj);
            if (StringUtils.isEmpty((String)data)) {
                logger.info("openApi \u8fd4\u56de\u9519\u8bef\u4fe1\u606f:" + response);
                return null;
            }
            EBServiceResponse ebServiceResponse = NewEBRequestHandler.parseResponse(data, signAlgorithm);
            if (ebServiceResponse != null) {
                if (!SUCCESS.equals(ebServiceResponse.getResponseCode()) && StringUtils.isEmpty((String)ebServiceResponse.getData())) {
                    throw new EBBizNCException(new EBBizErrorCode().RESPONSE(), new Object[]{ebServiceResponse.getResponseMsg()});
                }
            } else {
                throw new EBBizNCException(new EBBizErrorCode().RESPONSE_ISNULL());
            }
            return ebServiceResponse.getData();
        }
        catch (EBConnectException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof EBBizNCException && ((EBBizNCException)((Object)e)).getErrorCode().equals((Object)EBExceptionMsgEnum.getErrorCode(EBExceptionMsgEnum.EBGCLOUD_KD_000003.getErrorCode())) && isFirst.booleanValue()) {
                signAlgorithm = AlgorithmEnum.SHA256withRSA.getAlgorithm().equalsIgnoreCase(signAlgorithm) ? AlgorithmEnum.SHA1withRAS.getAlgorithm() : AlgorithmEnum.SHA256withRSA.getAlgorithm();
                logger.info("change signAlgorithm to reconnect:" + signAlgorithm);
                return this.getEBResponseData(request, serviceUrl, token, timeout, signAlgorithm);
            }
            throw new EBBizNCException(e, new EBErrorCode().EB_BIZ_EXCEPTION(), e.getMessage());
        }
    }

    private static String getRandomEncryptKey() {
        return RandomStringUtils.randomAlphanumeric((int)10);
    }

    private static EBServiceResponse parseResponse(String data, String signAlgorithm) {
        try {
            if (data != null) {
                EBServiceResponse ebServiceResponse = JsonUtil.fromJson(data, EBServiceResponse.class);
                if ("security_error".equals(ebServiceResponse.getResponseCode())) {
                    APP_CACHE.remove("beiSignAlgorithm");
                    ErrorCode errorCode = EBExceptionMsgEnum.getErrorCodeByCode(true, ebServiceResponse.getResponseMsg());
                    throw new EBBizNCException(errorCode);
                }
                logger.info("beiSignAlgorithm:" + signAlgorithm);
                if (EmptyUtil.isEmpty((String)((String)APP_CACHE.get("beiSignAlgorithm", String.class)))) {
                    APP_CACHE.put("beiSignAlgorithm", (Object)signAlgorithm);
                }
                if (ebServiceResponse.getSignData() != null) {
                    if (VerifySignUtil.verifyRequest(ebServiceResponse, signAlgorithm)) {
                        if (ebServiceResponse.getEncryptKey() != null) {
                            ebServiceResponse.setVersion("1.0");
                            AESDencryptUtil.getDecryptSkey(ebServiceResponse, signAlgorithm);
                            AESDencryptUtil.getAESDecrypt(ebServiceResponse);
                        }
                    } else {
                        logger.info("\u94f6\u4f01\u54cd\u5e94\u62a5\u6587\u89e3\u5bc6\uff0c\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25");
                        ErrorCode errorCode = EBExceptionMsgEnum.getErrorCodeByCode(true, ebServiceResponse.getResponseMsg());
                        throw new EBBizNCException(errorCode);
                    }
                }
                logger.info("\u94f6\u4f01\u54cd\u5e94\u62a5\u6587data= " + CommonUtils.prettyJson(ebServiceResponse.getData()));
                return ebServiceResponse;
            }
            logger.info("openApi\u54cd\u5e94\u62a5\u6587data\u4e3a\u7a7a\u503c");
            return null;
        }
        catch (Exception e) {
            if (e instanceof EBBizNCException && ((EBBizNCException)((Object)e)).getErrorCode().equals((Object)EBExceptionMsgEnum.getErrorCode(EBExceptionMsgEnum.EBGCLOUD_KD_000003.getErrorCode()))) {
                throw new EBBizNCException(EBExceptionMsgEnum.getErrorCode(EBExceptionMsgEnum.EBGCLOUD_KD_000003_API.getErrorCode()));
            }
            logger.info("getEBResponseData data =" + data);
            throw new EBBizNCException(e, new EBErrorCode().EB_BIZ_EXCEPTION(), e.getMessage());
        }
    }
}

