/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.ebservice.log;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.log.PayLog;
import kd.tmc.fbp.common.log.PayLogger;
import kd.tmc.fbp.common.log.bean.BankLog;
import kd.tmc.fbp.common.log.bean.BankLogDetail;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.webapi.ebentity.EBRequest;

public class BankLogService {
    private BankLog bankLog = new BankLog();
    private static final PayLogger payLogger = PayLogger.create(BankLogService.class);
    private static final Log logger = LogFactory.getLog(BankLogService.class);

    public BankLogService() {
        long bankLogId = DB.genLongId((String)EntityMetadataCache.getDataEntityType((String)"bei_banklog").getAlias());
        this.bankLog.setLogType("banklog");
        this.bankLog.setId(Long.valueOf(bankLogId));
        this.bankLog.setIsException("0");
        this.bankLog.setTime(new Date().getTime());
        this.bankLog.setExecutor(Long.valueOf(RequestContext.get().getCurrUserId()));
    }

    public BankLogService(BankLogInfo logInfo) {
        this();
        this.bankLog.setSourceId(logInfo.getSourceId());
        this.bankLog.setSrcBizId(logInfo.getSrcBizId());
        this.bankLog.setSourceBillNo(logInfo.getBillNo());
        this.bankLog.setSourceBillType(logInfo.getEntityName());
        this.bankLog.setCompanyId(logInfo.getOrgid());
        this.bankLog.setPayCurrencyId(logInfo.getPayCurrencyId());
        this.bankLog.setPayTotalAmt(logInfo.getPayTotalAmt());
        this.bankLog.setDetailList(logInfo.getLogDetailList());
        this.bankLog.setRequestId(logInfo.getRequestId());
    }

    public void setRequest(EBRequest request) {
        String bizType;
        List<String> types = Arrays.asList("notePayable", "noteReceivable", "queryNoteDetail");
        if (types.contains(bizType = request.getHeader().getBizType())) {
            String subBizType = request.getHeader().getSubBizType();
            bizType = bizType + "_" + subBizType;
        }
        logger.info("logRequest--request:" + JSON.toJSONString((Object)request));
        this.bankLog.setBankLogType(bizType);
        this.bankLog.setTransType("send");
        this.bankLog.setSendInfo(JSON.toJSONString((Object)request, (boolean)true));
        this.bankLog.setAccountBankNo(request.getHeader().getAccNo());
    }

    public void save() {
        this.bankLog.setInitSave(true);
        payLogger.log((PayLog)this.bankLog);
    }

    public void update() {
        this.bankLog.setInitSave(false);
        payLogger.log((PayLog)this.bankLog);
    }

    public void setResponse(String response) {
        JSONObject exception;
        this.bankLog.setReceiveInfo(response);
        JSONObject resp = JSON.parseObject((String)response);
        if (resp.containsKey((Object)"exception") && !EmptyUtil.isEmpty((Object)(exception = (JSONObject)resp.get((Object)"exception")))) {
            this.bankLog.setReceiveExceptionInfo(JSONObject.toJSONString((Object)exception));
            this.bankLog.setIsException("1");
            if (exception.containsKey((Object)"message")) {
                String exceptionMsg = this.getExceptionMsg((String)exception.get((Object)"message"));
                this.bankLog.setExceptionMsg(exceptionMsg);
            }
        }
    }

    public void setRequestException(Exception e) {
        this.bankLog.setSendExceptionInfo(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        this.bankLog.setExceptionMsg(this.getExceptionMsg(e.getMessage()));
        this.bankLog.setIsException("1");
    }

    public void setResponseException(Exception e) {
        this.bankLog.setReceiveExceptionInfo(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        this.bankLog.setIsException("1");
        this.bankLog.setExceptionMsg(this.getExceptionMsg(e.getMessage()));
    }

    public void setBizException(Exception e) {
        this.bankLog.setBizexceptioninfo(this.bankLog.getBizexceptioninfo() + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        this.bankLog.setIsException("1");
        this.bankLog.setExceptionMsg(this.getExceptionMsg(e.getMessage()));
    }

    public void setComment(String comment) {
        this.bankLog.setComment(comment);
    }

    public void setBankayState(String bankPayState, String payState) {
        this.bankLog.setBankPayState(bankPayState);
        List detailList = this.bankLog.getDetailList();
        if (detailList != null) {
            for (BankLogDetail detail : detailList) {
                detail.setPayState(payState);
            }
        }
    }

    public void setBankLogDetailPayState(String detailBizId, String state) {
        List detailList = this.bankLog.getDetailList();
        if (detailList != null) {
            for (BankLogDetail detail : detailList) {
                if (!detailBizId.equals(String.valueOf(detail.getPayBillId()))) continue;
                detail.setPayState(state);
            }
        }
    }

    private String getExceptionMsg(String errMessage) {
        if (errMessage != null && errMessage.length() > 50) {
            errMessage = errMessage.substring(0, 45) + "...";
        }
        return errMessage;
    }
}

