/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.ebservice.security.impl;

import java.lang.reflect.Constructor;
import kd.tmc.fbp.service.ebservice.security.atomic.IEncrypt;
import kd.tmc.fbp.service.ebservice.security.atomic.ISignature;
import kd.tmc.fbp.service.ebservice.security.exception.SecurityUnhandleException;
import kd.tmc.fbp.service.ebservice.security.register.EBSecurityCatalog;

public enum EBSecurityFactory {
    INSTANCE;


    public IEncrypt getEBEncrypt(String algorithm, byte[] encryptKey) {
        IEncrypt ebEncrypt = null;
        Class<? extends IEncrypt> classEncrypt = EBSecurityCatalog.getEncrypt(algorithm);
        try {
            Constructor<? extends IEncrypt> constructor = classEncrypt.getConstructor(byte[].class);
            ebEncrypt = constructor.newInstance(new Object[]{encryptKey});
        }
        catch (Exception e) {
            throw new SecurityUnhandleException(e);
        }
        return ebEncrypt;
    }

    public IEncrypt getEBEncrypt(String algorithm, byte[] privateKey, byte[] publicKey) {
        IEncrypt ebEncrypt = null;
        Class<? extends IEncrypt> classEncrypt = EBSecurityCatalog.getEncrypt(algorithm);
        try {
            Constructor<? extends IEncrypt> constructor = classEncrypt.getConstructor(byte[].class, byte[].class, Integer.TYPE);
            int mode = 3;
            if (null == privateKey) {
                mode = 1;
            }
            if (null == publicKey) {
                mode = 2;
            }
            ebEncrypt = constructor.newInstance(privateKey, publicKey, mode);
        }
        catch (Exception e) {
            throw new SecurityUnhandleException(e);
        }
        return ebEncrypt;
    }

    public ISignature getEBSignature(String algorithm, byte[] privateKey, byte[] publicKey) {
        ISignature ebSignature = null;
        Class<? extends ISignature> classSignature = EBSecurityCatalog.getSignature(algorithm);
        try {
            Constructor<? extends ISignature> constructor = classSignature.getConstructor(byte[].class, byte[].class);
            ebSignature = constructor.newInstance(privateKey, publicKey);
        }
        catch (Exception e) {
            throw new SecurityUnhandleException(e);
        }
        return ebSignature;
    }
}

