/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.ebservice.security.utils;

import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.service.ebservice.enums.AlgorithmEnum;
import kd.tmc.fbp.service.ebservice.security.utils.AESEncryptUtil;
import kd.tmc.fbp.service.ebservice.security.utils.EBKeyProvider;
import kd.tmc.fbp.service.ebservice.security.utils.HufuManager;
import kd.tmc.fbp.service.ebservice.security.utils.XOREncrypter;
import kd.tmc.fbp.webapi.ebentity.api.EBServiceResponse;
import org.apache.commons.codec.binary.Base64;

public class AESDencryptUtil {
    private static final Log logger = LogFactory.getLog(AESDencryptUtil.class);
    private static final String KEY_ALGORITHM = "AES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/GCM/PKCS5Padding";

    private static EBKeyProvider getEBKeyProvider() {
        QFilter qFilter = new QFilter("isenable2", "=", (Object)Boolean.TRUE);
        DynamicObject serviceConfig = TmcDataServiceHelper.loadSingle((String)"bei_serviceconfig", (String)"cafile_tag,isenable2,customerprivatekey,mcup", (QFilter[])new QFilter[]{qFilter});
        String fileContent = HufuManager.getValueByMcUp(serviceConfig);
        String customerPrivateKey = serviceConfig.getString("customerprivatekey");
        String customerKey = HufuManager.getCustomerKey();
        byte[] decodePW = XOREncrypter.decode(customerKey, customerPrivateKey);
        String certPwd = new String(decodePW);
        String alias = "";
        logger.info("AESDencryptUtil alias=" + alias);
        EBKeyProvider ebKeyProvider = new EBKeyProvider(fileContent, certPwd, alias);
        return ebKeyProvider;
    }

    public static void getDecryptSkey(EBServiceResponse response, String signAlgorithm) {
        byte[] privateKey = AESDencryptUtil.getEBKeyProvider().getPrivateKey().getEncoded();
        String sKey = AESDencryptUtil.decryptSkey(response.getEncryptKey(), privateKey, signAlgorithm);
        response.setEncryptKey(sKey);
    }

    public static String decryptSkey(String base64ContentSKey, byte[] privateKey, String signAlgorithm) {
        try {
            byte[] inputByte = Base64.decodeBase64((byte[])base64ContentSKey.getBytes("UTF-8"));
            RSAPrivateKey priKey = (RSAPrivateKey)KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(privateKey));
            Cipher cipher = AlgorithmEnum.SHA256withRSA.getAlgorithm().equalsIgnoreCase(signAlgorithm) ? Cipher.getInstance("RSA/ECB/OAEPWithSHA256AndMGF1Padding") : Cipher.getInstance("RSA/ECB/OAEPWithMD5AndMGF1Padding");
            cipher.init(2, priKey);
            return new String(cipher.doFinal(inputByte));
        }
        catch (Exception e) {
            logger.error("\u5bc6\u94a5\u89e3\u5bc6\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static void getAESDecrypt(EBServiceResponse response) {
        String data = response.getData();
        String skey = response.getEncryptKey();
        try {
            data = AESDencryptUtil.decrypt(data, skey);
            response.setData(data);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static String decrypt(String base64Content, String encryptPass) {
        byte[] content = Base64.decodeBase64((String)base64Content);
        if (content.length < 28) {
            throw new IllegalArgumentException();
        }
        GCMParameterSpec params = new GCMParameterSpec(128, content, 0, 12);
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(2, (Key)AESDencryptUtil.getSecretKey(encryptPass), params);
            byte[] decryptData = cipher.doFinal(content, 12, content.length - 12);
            return new String(decryptData);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static SecretKeySpec getSecretKey(String skey) throws NoSuchAlgorithmException {
        KeyGenerator kg = KeyGenerator.getInstance(KEY_ALGORITHM);
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(skey.getBytes());
        kg.init(AESEncryptUtil.getAESKeySize(), secureRandom);
        SecretKey secretKey = kg.generateKey();
        return new SecretKeySpec(secretKey.getEncoded(), KEY_ALGORITHM);
    }
}

