/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.ebservice.security.utils;

import java.security.PrivateKey;
import java.security.PublicKey;
import kd.bos.exception.ErrorCode;
import kd.tmc.fbp.service.ebservice.enums.EBExceptionMsgEnum;
import kd.tmc.fbp.service.ebservice.exception.EBBizNCException;
import kd.tmc.fbp.service.ebservice.security.utils.P12CertReader;

public class EBKeyProvider {
    private PrivateKey privateKey;
    private PublicKey publicKey;

    public EBKeyProvider(String fileContent, String certPwd, String alias) {
        try {
            P12CertReader p12CertReader = new P12CertReader(fileContent, certPwd, alias);
            p12CertReader.initKeyStore();
            this.privateKey = p12CertReader.getPrivateKey();
            this.publicKey = p12CertReader.getPublicKey();
        }
        catch (Exception e) {
            ErrorCode errorCode = EBExceptionMsgEnum.getErrorCodeWithMessage(null, e.getMessage());
            throw new EBBizNCException(errorCode);
        }
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }
}

