/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.ebservice.security.utils;

import kd.tmc.fbp.service.ebservice.security.atomic.IEncrypt;
import kd.tmc.fbp.service.ebservice.security.atomic.ISignature;
import kd.tmc.fbp.service.ebservice.security.impl.EBSecurityFactory;

public class EBSecuritySuit
implements IEncrypt,
ISignature {
    private String customID;
    private byte[] encryptKey;
    private byte[] kdPrivateKey;
    private byte[] customPublicKey;
    private String encryptAlgorithm;
    private String signAlgorithm;
    private IEncrypt EBEncrypt;
    private ISignature EBSignature;

    private void initEncrypt() {
        if (null == this.EBEncrypt) {
            this.EBEncrypt = EBSecurityFactory.INSTANCE.getEBEncrypt(this.encryptAlgorithm, this.encryptKey);
        }
    }

    private void initSign() {
        if (null == this.EBSignature) {
            this.EBSignature = EBSecurityFactory.INSTANCE.getEBSignature(this.signAlgorithm, this.kdPrivateKey, this.customPublicKey);
        }
    }

    @Override
    public String encrypt(byte[] source) {
        this.initEncrypt();
        return this.EBEncrypt.encrypt(source);
    }

    @Override
    public byte[] decrypt(String source) {
        this.initEncrypt();
        return this.EBEncrypt.decrypt(source);
    }

    @Override
    public String sign(byte[] source) {
        this.initSign();
        return this.EBSignature.sign(source);
    }

    @Override
    public boolean verify(String sign, byte[] content) {
        this.initSign();
        return this.EBSignature.verify(sign, content);
    }

    public void setSignAlgorithm(String signAlgorithm) {
        this.signAlgorithm = signAlgorithm;
    }

    public void setEncryptAlgorithm(String encryptAlgorithm) {
        this.encryptAlgorithm = encryptAlgorithm;
    }

    public void setCustomPublicKey(byte[] customPublicKey) {
        this.customPublicKey = customPublicKey;
    }

    public void setKdPrivateKey(byte[] kdPrivateKey) {
        this.kdPrivateKey = kdPrivateKey;
    }

    public void setEncryptKey(byte[] encryptKey) {
        this.encryptKey = encryptKey;
    }

    public String getCustomID() {
        return this.customID;
    }

    public void setCustomID(String customID) {
        this.customID = customID;
    }
}

