/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.ebservice.security.utils;

import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.security.Signature;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.service.ebservice.errorcode.EBErrorCode;
import kd.tmc.fbp.service.ebservice.exception.EBSignException;
import kd.tmc.fbp.service.ebservice.security.utils.HufuManager;
import kd.tmc.fbp.service.ebservice.security.utils.XOREncrypter;
import kd.tmc.fbp.webapi.ebentity.api.EBServiceResponse;

public class VerifySignUtil {
    private static final Log logger = LogFactory.getLog(VerifySignUtil.class);

    private static PublicKey getPublicKey() throws CertificateException {
        QFilter qFilter = new QFilter("isenable2", "=", (Object)Boolean.TRUE);
        DynamicObject serviceConfig = TmcDataServiceHelper.loadSingle((String)"bei_serviceconfig", (String)"publiccafile_tag", (QFilter[])new QFilter[]{qFilter});
        String fileContent = serviceConfig.getString("publiccafile_tag");
        String customerKey = HufuManager.getCustomerKey();
        X509Certificate x509Certificate = X509Certificate.getInstance(XOREncrypter.decode(customerKey, fileContent));
        PublicKey certPublicKey = x509Certificate.getPublicKey();
        return certPublicKey;
    }

    public static boolean verifyRequest(EBServiceResponse response, String signAlgorithm) {
        String content = VerifySignUtil.getPlainText(response);
        PublicKey publicKey = null;
        try {
            publicKey = VerifySignUtil.getPublicKey();
            return VerifySignUtil.verify(content, response.getSignData(), signAlgorithm, publicKey);
        }
        catch (Exception e) {
            logger.error("\u9a8c\u7b7e\u5f02\u5e38", (Throwable)e);
            throw new EBSignException(new EBErrorCode().EB_BIZ_SIGN_EXCEPTION(), new Object[]{e.getMessage()});
        }
    }

    public static boolean verify(String content, String signData, String signAlgorithm, PublicKey publicKey) {
        try {
            Signature signatureVerify = Signature.getInstance(signAlgorithm);
            signatureVerify.initVerify(publicKey);
            byte[] signedByte = TmcBusinessBaseHelper.decodeBase64((String)signData);
            byte[] data = content.getBytes(StandardCharsets.UTF_8);
            signatureVerify.update(data);
            return signatureVerify.verify(signedByte);
        }
        catch (Exception e) {
            logger.error("\u9a8c\u7b7e\u5f02\u5e38", (Throwable)e);
            throw new EBSignException(new EBErrorCode().EB_BIZ_SIGN_EXCEPTION(), new Object[]{e.getMessage()});
        }
    }

    private static String getPlainText(Object obj) {
        StringBuilder sb = new StringBuilder();
        String toSignData = "";
        if (obj instanceof EBServiceResponse) {
            EBServiceResponse response = (EBServiceResponse)obj;
            sb.append(response.getResponseCode()).append(response.getResponseMsg()).append(response.getData()).append(response.getEncryptKey());
            toSignData = sb.toString();
        }
        return toSignData;
    }
}

