/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.ebservice.service;

import com.alibaba.fastjson.JSON;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.enums.AlgorithmEnum;
import kd.tmc.fbp.service.ebservice.errorcode.BeErrorCode;
import kd.tmc.fbp.service.ebservice.exception.BEBizException;
import kd.tmc.fbp.service.ebservice.http.IEBRequestHandler;
import kd.tmc.fbp.service.ebservice.http.impl.NewEBRequestHandler;
import kd.tmc.fbp.service.ebservice.http.impl.RPCRequestHandler;
import kd.tmc.fbp.service.ebservice.log.BankLogService;
import kd.tmc.fbp.service.ebservice.security.atomic.ISignature;
import kd.tmc.fbp.service.ebservice.security.impl.EBSecurityFactory;
import kd.tmc.fbp.service.ebservice.security.utils.HufuManager;
import kd.tmc.fbp.service.ebservice.security.utils.XOREncrypter;
import kd.tmc.fbp.service.ebservice.utils.JsonUtil;
import kd.tmc.fbp.service.ebservice.utils.SSLClient;
import kd.tmc.fbp.webapi.ebentity.EBBody;
import kd.tmc.fbp.webapi.ebentity.EBHeader;
import kd.tmc.fbp.webapi.ebentity.EBRequest;
import kd.tmc.fbp.webapi.ebentity.api.EBServiceResponse;
import kd.tmc.fbp.webapi.ebentity.auth.AuthRequest;
import kd.tmc.fbp.webapi.ebentity.biz.ping.EBPingRequest;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

public class TestConnectService {
    private static final Log logger = LogFactory.getLog(TestConnectService.class);

    public static Map<String, Object> testConnect() throws Exception {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put("iserror", Boolean.TRUE);
        ArrayList<Integer> whichServiceEnable = new ArrayList<Integer>(2);
        String customerKey = HufuManager.getCustomerKey();
        QFilter qFilter = new QFilter("isenable", "=", (Object)Boolean.TRUE);
        qFilter.or(new QFilter("isenable2", "=", (Object)Boolean.TRUE));
        DynamicObject config = TmcDataServiceHelper.loadSingleFromCache((String)"bei_serviceconfig", (String)"customerid,customerid2,serveraddress,serveraddress2,cafile_tag,customerprivatekey,isenable,isenable2,appid,appsecret,isopenapi,mcup,tenantid", (QFilter[])new QFilter[]{qFilter});
        if (config == null) {
            throw new BEBizException(new BeErrorCode().BE5000());
        }
        if (config.getBoolean("isenable")) {
            TestConnectService.checkTenantId(config, config.getString("serveraddress"));
            String customerID = config.getString("customerid");
            String url = config.getString("serveraddress") + "/services/auth?customerID=" + customerID;
            String p12String = HufuManager.getValueByMcUp(config);
            String password = config.getString("customerprivatekey");
            String decodePW = new String(XOREncrypter.decode(customerKey, password));
            String content = "";
            String requestStr = "";
            AuthRequest authRequest = new AuthRequest();
            authRequest.setCustomerID(customerID);
            authRequest.setSignAlgorithm(AlgorithmEnum.SHA1withRAS.getAlgorithm());
            authRequest.setTimestamp(Long.valueOf(System.currentTimeMillis()));
            authRequest.setData("auth request");
            StringBuilder sb = new StringBuilder();
            sb.append(authRequest.getCustomerID()).append(authRequest.getTimestamp()).append(authRequest.getEncryptAlgorithm()).append(authRequest.getEncryptKey()).append(authRequest.getSignAlgorithm()).append(authRequest.getExtData());
            content = sb.toString();
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(new ByteArrayInputStream(XOREncrypter.decode(customerKey, p12String)), decodePW.toCharArray());
            String alias = ks.aliases().nextElement();
            PrivateKey priKey = (PrivateKey)ks.getKey(ks.aliases().nextElement(), decodePW.toCharArray());
            Certificate cert = ks.getCertificate(alias);
            PublicKey pubKey = cert.getPublicKey();
            ISignature signature = EBSecurityFactory.INSTANCE.getEBSignature(AlgorithmEnum.SHA1withRAS.getAlgorithm(), priKey.getEncoded(), pubKey.getEncoded());
            String signData = signature.sign(content.getBytes("UTF-8"));
            authRequest.setSignData(signData);
            requestStr = JSON.toJSONString((Object)authRequest);
            BasicHttpParams httpParams = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)5000);
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)5000);
            SSLClient httpClient = null;
            httpClient = url.toLowerCase(Locale.ENGLISH).startsWith("https://") ? new SSLClient((HttpParams)httpParams) : new DefaultHttpClient((HttpParams)httpParams);
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Content-Type", "application/json; charset=UTF-8");
            StringEntity se = new StringEntity(requestStr, "UTF-8");
            se.setContentType("text/json");
            se.setContentEncoding((Header)new BasicHeader("Content-Type", "application/json; charset=UTF-8"));
            httpPost.setEntity((HttpEntity)se);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            logger.info("\u94f6\u4f01\u4e92\u8054-\u6d4b\u8bd5\u94f6\u4f01\u670d\u52a1\u914d\u7f6e1(\u72ec\u7acb\u7248\u94f6\u4f01\u4e91)\u8fde\u63a5-\u94f6\u4f01response\uff1a" + result);
            EBServiceResponse res = (EBServiceResponse)JSON.parseObject((String)result, EBServiceResponse.class);
            if (res.getResponseCode().contains("error")) {
                if (EmptyUtil.isEmpty((String)res.getData())) {
                    String errorMsg = res.getResponseCode() + "{" + res.getResponseMsg() + "}";
                    resultMap.put("message", String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u5f02\u5e38\uff1a%s", (String)"TestConnectService_1", (String)"tmc-fbp-mservice", (Object[])new Object[0]), errorMsg));
                } else {
                    resultMap.put("message", String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a%s", (String)"TestConnectService_2", (String)"tmc-fbp-mservice", (Object[])new Object[0]), res.getData()));
                }
            }
            if (statusCode == 200) {
                resultMap.put("iserror", Boolean.FALSE);
                resultMap.put("message", ResManager.loadKDString((String)"\u72ec\u7acb\u7248\u94f6\u4f01\u4e91\u8fde\u63a5\u6210\u529f\u3002", (String)"TestConnectService_3", (String)"tmc-fbp-mservice", (Object[])new Object[0]));
                whichServiceEnable.add(1);
            } else {
                String msg = String.format(ResManager.loadKDString((String)"\u72ec\u7acb\u7248\u94f6\u4f01\u4e91\u9519\u8bef\u7684\u54cd\u5e94\u7801\uff1a%s", (String)"TestConnectService_4", (String)"tmc-fbp-mservice", (Object[])new Object[0]), response.getStatusLine());
                resultMap.put("message", msg);
            }
        }
        if (config.getBoolean("isenable2")) {
            IEBRequestHandler handler;
            String url2 = "/kapi/app/aqap/aqap_service";
            EBPingRequest request = new EBPingRequest();
            EBHeader ebHeader = new EBHeader();
            ebHeader.setBizType("ping");
            ebHeader.setClientName(ResManager.loadKDString((String)"\u91d1\u8776\u4e0b\u4e00\u4ee3\u4e91ERP", (String)"TestConnectService_5", (String)"tmc-fbp-mservice", (Object[])new Object[0]));
            ebHeader.setClientVersion("V1.0");
            ebHeader.setCurrency("CNY");
            ebHeader.setCustomId(config.getString("customerid2"));
            String identificationCode = TmcBusinessBaseHelper.toBase64String((byte[])(RequestContext.get().getTenantId() + RequestContext.get().getAccountId()).getBytes());
            ebHeader.setIdentificationCode(identificationCode);
            ebHeader.setOperationName("ping");
            ebHeader.setRequestTime(new Date().getTime());
            ebHeader.setSubBizType("connectTest");
            request.setHeader(ebHeader);
            request.setBody(new EBBody());
            logger.info("\u6d4b\u8bd5\u94f6\u4f01\u670d\u52a1\u914d\u7f6e2(\u661f\u701a-\u94f6\u4f01\u4e91)\u8fde\u63a5-\u8bf7\u6c42\u4f53\u5185\u5bb9data\uff1a" + JSON.toJSONString((Object)request) + ",url2 :" + url2);
            if (!config.getBoolean("isopenapi")) {
                handler = new RPCRequestHandler(new BankLogService());
            } else {
                TestConnectService.checkTenantId(config, config.getString("serveraddress2"));
                handler = new NewEBRequestHandler(new BankLogService());
            }
            request.getHeader().setCustomId(handler.getCustomerId());
            String response = handler.executeEBRequest((EBRequest)request, url2, 5000);
            logger.info("\u94f6\u4f01\u4e92\u8054-\u6d4b\u8bd5\u94f6\u4f01\u670d\u52a1\u914d\u7f6e2(\u661f\u701a-\u94f6\u4f01\u4e91)\u8fde\u63a5-\u94f6\u4f01response\uff1a" + response);
            Map responseMap = JsonUtil.fromJson(response, Map.class);
            if (responseMap.get("exception") == null) {
                resultMap.put("iserror", Boolean.FALSE);
                String message = resultMap.get("message") == null ? "" : resultMap.get("message") + ";";
                resultMap.put("message", String.format(ResManager.loadKDString((String)"%s\u661f\u701a-\u94f6\u4f01\u4e91\u8fde\u63a5\u6210\u529f\u3002", (String)"TestConnectService_6", (String)"tmc-fbp-mservice", (Object[])new Object[0]), message));
                whichServiceEnable.add(2);
            } else {
                Map responseDataMap = JsonUtil.fromJson(responseMap.get("exception").toString(), Map.class);
                String msg = resultMap.get("message") != null ? String.format(ResManager.loadKDString((String)"%1$s \u661f\u701a-\u94f6\u4f01\u4e91 \u9519\u8bef\u7684\u54cd\u5e94\u7801\uff1a%2$s", (String)"TestConnectService_7", (String)"tmc-fbp-mservice", (Object[])new Object[0]), resultMap.get("message"), responseDataMap.get("message")) : String.format(ResManager.loadKDString((String)"\u661f\u701a-\u94f6\u4f01\u4e91 \u9519\u8bef\u7684\u54cd\u5e94\u7801\uff1a%s", (String)"TestConnectService_8", (String)"tmc-fbp-mservice", (Object[])new Object[0]), responseDataMap.get("message"));
                resultMap.put("message", msg);
            }
        }
        resultMap.put("successPkIds", whichServiceEnable);
        return resultMap;
    }

    private static void checkTenantId(DynamicObject config, String serviceUrl) {
        String tenantId = config.getString("tenantid");
        String sysTenantId = RequestContext.get().getTenantId();
        if (EmptyUtil.isNoEmpty((String)tenantId) && !sysTenantId.equals(tenantId)) {
            throw new BEBizException(new BeErrorCode().TENANTID_ERROR(serviceUrl));
        }
    }
}

