/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.ebservice.service.executor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.helper.DivideGroupHelper;
import kd.tmc.fbp.service.ebservice.service.executor.EBExecutorBatchWrap;

public class EBServiceBatchExecutor<R> {
    private static Log logger = LogFactory.getLog(EBServiceBatchExecutor.class);
    private List<EBExecutorBatchWrap<R>> batchList = new ArrayList<EBExecutorBatchWrap<R>>(8);
    private static final int MAX_THREAD_CNT = 8;
    private static final int MAX_DEAL_SIZE = 20;
    private String errorInfo;
    private boolean exception;

    public List<R> execute() {
        ArrayList<R> resultList = new ArrayList<R>();
        if (this.batchList.size() == 0) {
            return resultList;
        }
        if (this.batchList.size() == 1) {
            EBExecutorBatchWrap<R> wrap = this.batchList.get(0);
            R result = wrap.getExecutor().execute(wrap.getEbService());
            resultList.add(result);
            return resultList;
        }
        DivideGroupHelper batch = new DivideGroupHelper(this.batchList, 20, 8);
        List bizBillList = batch.getResult();
        ArrayList<Future> futureList = new ArrayList<Future>(bizBillList.size());
        for (List currList : bizBillList) {
            RequestContext context = RequestContext.get();
            Future future = ThreadService.submit(() -> {
                RequestContext.copyAndSet((RequestContext)context);
                ArrayList currResultList = new ArrayList(currList.size());
                for (EBExecutorBatchWrap wrap : currList) {
                    Object result = wrap.getExecutor().execute(wrap.getEbService());
                    currResultList.add(result);
                }
                return currResultList;
            }, (TaskType)TaskType.FBP_EBSERVICE_BATCH_EXECUTOR);
            futureList.add(future);
        }
        try {
            for (Future future : futureList) {
                List results = (List)future.get();
                if (results == null) continue;
                resultList.addAll(results);
            }
            return resultList;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.exception = true;
            this.errorInfo = e.getMessage();
            return resultList;
        }
    }

    public String getErrorInfo() {
        return this.errorInfo;
    }

    public boolean hasException() {
        return this.exception;
    }

    public void addBatchTask(EBExecutorBatchWrap<R> task) {
        this.batchList.add(task);
    }
}

