/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.ebservice.utils;

import java.util.Date;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.DBServiceHelper;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.service.ebservice.enums.BankReturnStatusEnum;
import kd.tmc.fbp.webapi.ebentity.EBHeader;
import kd.tmc.fbp.webapi.ebentity.biz.pay.PayDetail;

public class BeServiceHelper {
    public static EBHeader parseHeader() {
        EBHeader header = new EBHeader();
        header.setClientName(ResManager.loadKDString((String)"\u91d1\u8776\u4e0b\u4e00\u4ee3\u4e91ERP", (String)"BeServiceHelper_0", (String)"tmc-fbp-mservice", (Object[])new Object[0]));
        header.setClientVersion("V1.0");
        header.setCurrency("CNY");
        String identificationCode = TmcBusinessBaseHelper.toBase64String((byte[])(RequestContext.get().getTenantId() + RequestContext.get().getAccountId()).getBytes());
        header.setIdentificationCode(identificationCode);
        header.setRequestTime(new Date().getTime());
        return header;
    }

    @Deprecated
    public static String[] getSerialNumber(int count) {
        String[] serials = new String[count];
        for (int i = 0; i < count; ++i) {
            serials[i] = UUID.randomUUID().toString();
        }
        return serials;
    }

    public static String generateSerialNumber() {
        return DBServiceHelper.genStringId();
    }

    public static BeBillStatusEnum transferState(String ebStatus) {
        if (ebStatus.equals(BankReturnStatusEnum.EB_PROCESSING.getValue())) {
            return BeBillStatusEnum.OS;
        }
        if (ebStatus.equals(BankReturnStatusEnum.BANK_PROCESSING.getValue())) {
            return BeBillStatusEnum.BP;
        }
        if (ebStatus.equals(BankReturnStatusEnum.BANK_SUCCESS.getValue())) {
            return BeBillStatusEnum.TS;
        }
        if (ebStatus.equals(BankReturnStatusEnum.BANK_FAIL.getValue())) {
            return BeBillStatusEnum.TF;
        }
        if (ebStatus.equals(BankReturnStatusEnum.BANK_UNKNOWN.getValue())) {
            return BeBillStatusEnum.NC;
        }
        return BeBillStatusEnum.NC;
    }

    public static boolean isTradeRefund(PayDetail detail) {
        return ResManager.loadKDString((String)"\u9000\u7968", (String)"BeServiceHelper_1", (String)"tmc-fbp-mservice", (Object[])new Object[0]).equals(detail.getBankMsg());
    }
}

