/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.entitymap.bean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BizRangeTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class EntityMapMatchBean {
    private String billRelationType;
    private String[] srcMatchFieldArray;
    private String[] tagMatchFieldArray;
    private Set<ThreeTuple<String, String, String>> entryLinks = new HashSet<ThreeTuple<String, String, String>>(10);
    private Set<String> selectSrcProps;
    private String srcEntity;
    private List<Pair<String[], String[]>> rowMapInfolist;
    private List<String> srcAttachments;
    private List<String> tagAttachments;
    private Boolean needSave = false;
    private static Boolean needChangeReverse = false;

    public static EntityMapMatchBean buildEntityModelBean(String srcEntityName, String tagEntityName, String bizType) {
        QFilter qFilter = new QFilter("biztype", "=", (Object)bizType).and("srcentity.number", "=", (Object)(needChangeReverse != false ? tagEntityName : srcEntityName)).and("tagentity.number", "=", (Object)(needChangeReverse != false ? srcEntityName : tagEntityName)).and("enable", "=", (Object)"1");
        DynamicObjectCollection entityMaps = QueryServiceHelper.query((String)"fbd_entitymapmodel", (String)"id", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entityMaps) || entityMaps.size() != 1) {
            return null;
        }
        Long entityMapId = entityMaps.stream().map(o -> o.getLong("id")).findFirst().get();
        return EntityMapMatchBean.buildEntityModelBean(entityMapId);
    }

    public static EntityMapMatchBean buildEntityModelBean(Long entityMapId) {
        EntityMapMatchBean buildEntityModelBean = new EntityMapMatchBean();
        DataSet entityMapDs = QueryServiceHelper.queryDataSet((String)"t_fbd_entitymapmodel", (String)"fbd_entitymapmodel", (String)"id,biztype,srcentity,tagentity,billrelationtype,matchsrcfieldval,matchtagfieldval,srcattach,tagattach,ishasentry,entryrelation,entryrelation.id,entryrelation.relationtype,entryrelation.entrysrcfieldval,entryrelation.entrytagfieldval,entryentity,entryentity.id,entryentity.srcfield,entryentity.targetfield", (QFilter[])new QFilter("id", "=", (Object)entityMapId).toArray(), (String)"id");
        if (!entityMapDs.hasNext()) {
            return null;
        }
        ArrayList<Pair<String[], String[]>> RowMapInfos = new ArrayList<Pair<String[], String[]>>(10);
        Row entityHeadRow = entityMapDs.copy().next();
        HashSet<String> selectSrcProps = new HashSet<String>(16);
        selectSrcProps.add("id");
        HashSet<ThreeTuple<String, String, String>> entryLinks = new HashSet<ThreeTuple<String, String, String>>(10);
        if (entityHeadRow.getBoolean("ishasentry").booleanValue()) {
            DataSet entityLinkInfos = entityMapDs.copy().groupBy(new String[]{"id", "entryrelation.id", "entryrelation.relationtype", "entryrelation.entrysrcfieldval", "entryrelation.entrytagfieldval"}).finish();
            for (Row entityMapInfo : entityLinkInfos) {
                String relationType = entityMapInfo.getString("entryrelation.relationtype");
                String entrySrcFieldval = entityMapInfo.getString("entryrelation.entrysrcfieldval");
                String entryTagFieldval = entityMapInfo.getString("entryrelation.entrytagfieldval");
                selectSrcProps.add(entrySrcFieldval);
                entryLinks.add((ThreeTuple<String, String, String>)(needChangeReverse != false ? new ThreeTuple((Object)relationType, (Object)entryTagFieldval, (Object)entrySrcFieldval) : new ThreeTuple((Object)relationType, (Object)entrySrcFieldval, (Object)entryTagFieldval)));
            }
        }
        if (BizRangeTypeEnum.isAttachment((String)entityHeadRow.getString("biztype"))) {
            String srcAttachs = entityHeadRow.getString("srcattach");
            String tagAttachs = entityHeadRow.getString("tagattach");
            if (EmptyUtil.isNoEmpty((String)srcAttachs)) {
                buildEntityModelBean.setSrcAttachments(Arrays.stream(srcAttachs.replaceFirst(",", "").split(",")).collect(Collectors.toList()));
            }
            if (EmptyUtil.isNoEmpty((String)tagAttachs)) {
                buildEntityModelBean.setTagAttachments(Arrays.stream(tagAttachs.replaceFirst(",", "").split(",")).collect(Collectors.toList()));
            }
        } else {
            DataSet entityMapInfos = entityMapDs.copy().groupBy(new String[]{"id", "entryentity.id", "entryentity.srcfield", "entryentity.targetfield"}).finish();
            for (Row entityMapInfo : entityMapInfos) {
                selectSrcProps.add(entityMapInfo.getString("entryentity.srcfield"));
                String srcField = entityMapInfo.getString("entryentity.srcfield");
                String targetField = entityMapInfo.getString("entryentity.targetfield");
                if (EmptyUtil.isEmpty((String)srcField) || EmptyUtil.isEmpty((String)targetField)) continue;
                RowMapInfos.add(needChangeReverse != false ? Pair.of((Object)targetField.split("\\."), (Object)srcField.split("\\.")) : Pair.of((Object)srcField.split("\\."), (Object)targetField.split("\\.")));
            }
        }
        String srcEntity = entityHeadRow.getString("srcentity");
        String billRelationType = entityHeadRow.getString("billrelationtype");
        String matchSrcFieldVal = entityHeadRow.getString("matchsrcfieldval");
        String matchTagFieldVal = entityHeadRow.getString("matchtagfieldval");
        String[] srcMatchFieldArray = matchSrcFieldVal.split("\\.");
        selectSrcProps.add(srcMatchFieldArray[0]);
        selectSrcProps.add(matchSrcFieldVal);
        String[] tagMatchFieldArray = matchTagFieldVal.split("\\.");
        buildEntityModelBean.setSrcEntity(srcEntity);
        buildEntityModelBean.setBillRelationType(billRelationType);
        buildEntityModelBean.setEntryLinks(entryLinks);
        buildEntityModelBean.setSelectSrcProps(selectSrcProps);
        buildEntityModelBean.setSrcMatchFieldArray(srcMatchFieldArray);
        buildEntityModelBean.setTagMatchFieldArray(tagMatchFieldArray);
        buildEntityModelBean.setRowMapInfolist(RowMapInfos);
        return buildEntityModelBean;
    }

    public String getBillRelationType() {
        return this.billRelationType;
    }

    public void setBillRelationType(String billRelationType) {
        this.billRelationType = billRelationType;
    }

    public String[] getSrcMatchFieldArray() {
        return this.srcMatchFieldArray;
    }

    public void setSrcMatchFieldArray(String[] srcMatchFieldArray) {
        this.srcMatchFieldArray = srcMatchFieldArray;
    }

    public String[] getTagMatchFieldArray() {
        return this.tagMatchFieldArray;
    }

    public void setTagMatchFieldArray(String[] tagMatchFieldArray) {
        this.tagMatchFieldArray = tagMatchFieldArray;
    }

    public Set<ThreeTuple<String, String, String>> getEntryLinks() {
        return this.entryLinks;
    }

    public void setEntryLinks(Set<ThreeTuple<String, String, String>> entryLinks) {
        this.entryLinks = entryLinks;
    }

    public Set<String> getSelectSrcProps() {
        return this.selectSrcProps;
    }

    public void setSelectSrcProps(Set<String> selectSrcProps) {
        this.selectSrcProps = selectSrcProps;
    }

    public List<Pair<String[], String[]>> getRowMapInfolist() {
        return this.rowMapInfolist;
    }

    public void setRowMapInfolist(List<Pair<String[], String[]>> rowMapInfolist) {
        this.rowMapInfolist = rowMapInfolist;
    }

    public String getSrcEntity() {
        return this.srcEntity;
    }

    public void setSrcEntity(String srcEntity) {
        this.srcEntity = srcEntity;
    }

    public List<String> getSrcAttachments() {
        return this.srcAttachments;
    }

    public void setSrcAttachments(List<String> srcAttachments) {
        this.srcAttachments = srcAttachments;
    }

    public List<String> getTagAttachments() {
        return this.tagAttachments;
    }

    public void setTagAttachments(List<String> tagAttachments) {
        this.tagAttachments = tagAttachments;
    }

    public Boolean getNeedSave() {
        return this.needSave;
    }

    public void setNeedSave(Boolean needSave) {
        this.needSave = needSave;
    }

    public static Boolean getNeedChangeReverse() {
        return needChangeReverse;
    }

    public static void setNeedChangeReverse(Boolean needChangeReverse) {
        EntityMapMatchBean.needChangeReverse = needChangeReverse;
    }

    public String toString() {
        return "EntityMapMatchBean{billRelationType='" + this.billRelationType + '\'' + ", srcMatchFieldArray=" + Arrays.toString(this.srcMatchFieldArray) + ", tagMatchFieldArray=" + Arrays.toString(this.tagMatchFieldArray) + ", entryLinks=" + this.entryLinks + ", selectSrcProps=" + this.selectSrcProps + ", srcEntity='" + this.srcEntity + '\'' + ", rowMapInfolist=" + this.rowMapInfolist + ", srcAttachments=" + this.srcAttachments + ", tagAttachments=" + this.tagAttachments + ", needSave=" + this.needSave + ", needChangeReverse=" + needChangeReverse + '}';
    }
}

