/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.entitymap.engine;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BillRelationTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.entitymap.bean.EntityMapMatchBean;
import kd.tmc.fbp.service.entitymap.engine.IEntityMapEngine;

public abstract class AbstractEntityMapEngine
implements IEntityMapEngine {
    protected static Log logger = LogFactory.getLog(AbstractEntityMapEngine.class);

    @Override
    public void execute(DynamicObject[] srcBills, DynamicObject[] tagBills, EntityMapMatchBean entityMapMatchBean) {
    }

    @Override
    public void execute(DynamicObject[] srcBills, IDataModel tagModel, EntityMapMatchBean entityMapMatchBean) {
    }

    @Override
    public DynamicObject[] getSrcBillInfo(DynamicObject[] srcBills, DynamicObject[] tagBills, EntityMapMatchBean entityMapMatchBean) {
        if (EmptyUtil.isNoEmpty((Object[])srcBills)) {
            return srcBills;
        }
        entityMapMatchBean.setNeedSave(true);
        String billRelationType = entityMapMatchBean.getBillRelationType();
        if (BillRelationTypeEnum.isH2H_SID((String)billRelationType) || BillRelationTypeEnum.isH2H_TID((String)billRelationType)) {
            return this.getH2HSrcBill(tagBills, entityMapMatchBean);
        }
        if (BillRelationTypeEnum.isH2E_SID((String)billRelationType)) {
            return this.getH2ESrcBill(tagBills, entityMapMatchBean);
        }
        if (BillRelationTypeEnum.isE2H_TID((String)billRelationType)) {
            return this.getE2HSrcBill(tagBills, entityMapMatchBean);
        }
        return null;
    }

    private DynamicObject[] getE2HSrcBill(DynamicObject[] tagBills, EntityMapMatchBean entityMapMatchBean) {
        String[] srcMatchFieldArray = entityMapMatchBean.getSrcMatchFieldArray();
        String[] tagMatchFieldArray = entityMapMatchBean.getTagMatchFieldArray();
        Set<String> selectSrcProps = entityMapMatchBean.getSelectSrcProps();
        String srcEntityName = entityMapMatchBean.getSrcEntity();
        Object[] srcKeys = Arrays.stream(tagBills).map(o -> o.get(tagMatchFieldArray[0])).toArray();
        return TmcDataServiceHelper.load((String)srcEntityName, (String)String.join((CharSequence)",", selectSrcProps), (QFilter[])new QFilter(srcMatchFieldArray[0] + "." + srcMatchFieldArray[1], "in", (Object)srcKeys).toArray());
    }

    private DynamicObject[] getH2ESrcBill(DynamicObject[] tagBills, EntityMapMatchBean entityMapMatchBean) {
        String[] srcMatchFieldArray = entityMapMatchBean.getSrcMatchFieldArray();
        String[] tagMatchFieldArray = entityMapMatchBean.getTagMatchFieldArray();
        Set<String> selectSrcProps = entityMapMatchBean.getSelectSrcProps();
        String srcEntityName = entityMapMatchBean.getSrcEntity();
        DynamicObject tagBill = tagBills[0];
        DynamicObjectCollection tagEntryInfos = tagBill.getDynamicObjectCollection(tagMatchFieldArray[0]);
        Object[] tagBillNoIds = tagEntryInfos.stream().map(o -> this.transDyn2Val(o.get(tagMatchFieldArray[1]))).toArray();
        return TmcDataServiceHelper.load((String)srcEntityName, (String)String.join((CharSequence)",", selectSrcProps), (QFilter[])new QFilter(srcMatchFieldArray[0], "in", (Object)tagBillNoIds).toArray());
    }

    private DynamicObject[] getH2HSrcBill(DynamicObject[] tagBills, EntityMapMatchBean entityMapMatchBean) {
        String[] srcMatchFieldArray = entityMapMatchBean.getSrcMatchFieldArray();
        String[] tagMatchFieldArray = entityMapMatchBean.getTagMatchFieldArray();
        Set<String> selectSrcProps = entityMapMatchBean.getSelectSrcProps();
        String srcEntityName = entityMapMatchBean.getSrcEntity();
        Object srcMatchFiledVal = tagBills[0].get(tagMatchFieldArray[0]);
        Object srcMatchVal = this.transDyn2Val(srcMatchFiledVal);
        return TmcDataServiceHelper.load((String)srcEntityName, (String)String.join((CharSequence)",", selectSrcProps), (QFilter[])new QFilter(srcMatchFieldArray[0], "=", srcMatchVal).toArray(), (String)"createtime desc");
    }

    protected Object transDyn2Val(Object dynVal) {
        if (EmptyUtil.isEmpty((Object)dynVal)) {
            return null;
        }
        if (dynVal instanceof DynamicObjectCollection) {
            return ((DynamicObjectCollection)dynVal).stream().map(o -> o.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
        }
        if (dynVal instanceof DynamicObject) {
            return ((DynamicObject)dynVal).getPkValue();
        }
        return dynVal;
    }
}

